/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.forms.layout.table;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.ITableWrapDataInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutImages;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutSupport;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.actions.SetAlignmentAction;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.actions.SetGrabAction;
import org.eclipse.wb.internal.xwt.model.forms.layout.table.TableWrapLayoutInfo;
import org.eclipse.wb.internal.xwt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

public final class TableWrapDataInfo
extends LayoutDataInfo
implements ITableWrapDataInfo {
    private boolean m_initialized;
    int x = -1;
    int y = -1;
    int width = 1;
    int height = 1;
    boolean horizontalGrab;
    boolean verticalGrab;
    int horizontalAlignment;
    int verticalAlignment;
    int heightHint;

    public TableWrapDataInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (TableWrapDataInfo.this.getParent() == object) {
                    TableWrapDataInfo.this.addContextMenu(manager);
                }
            }
        });
    }

    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        this.getCurrentObjectCell(this.getLayout(), this.getControl());
        this.getCurrentObjectFields();
    }

    void initialize(TableWrapLayoutInfo layout, ControlInfo controlInfo) throws Exception {
        if (!this.m_initialized) {
            this.m_initialized = true;
            this.getCurrentObjectCell(layout, controlInfo);
            this.getCurrentObjectFields();
        }
    }

    private void getCurrentObjectCell(TableWrapLayoutInfo layout, ControlInfo controlInfo) throws Exception {
        Point xyPoint;
        if (layout.getObject() != null && controlInfo.getObject() != null && (xyPoint = TableWrapLayoutSupport.getXY((Object)layout.getObject(), (Object)controlInfo.getObject())) != null) {
            this.x = xyPoint.x;
            this.y = xyPoint.y;
        }
    }

    private void getCurrentObjectFields() throws Exception {
        Object object = this.getObject();
        this.width = ReflectionUtils.getFieldInt((Object)object, (String)"colspan");
        this.height = ReflectionUtils.getFieldInt((Object)object, (String)"rowspan");
        this.horizontalGrab = ReflectionUtils.getFieldBoolean((Object)object, (String)"grabHorizontal");
        this.verticalGrab = ReflectionUtils.getFieldBoolean((Object)object, (String)"grabVertical");
        this.horizontalAlignment = ReflectionUtils.getFieldInt((Object)object, (String)"align");
        this.verticalAlignment = ReflectionUtils.getFieldInt((Object)object, (String)"valign");
        this.heightHint = ReflectionUtils.getFieldInt((Object)object, (String)"heightHint");
    }

    private ControlInfo getControl() {
        return (ControlInfo)this.getParent();
    }

    private TableWrapLayoutInfo getLayout() {
        CompositeInfo composite = (CompositeInfo)this.getControl().getParent();
        return (TableWrapLayoutInfo)composite.getLayout();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getHorizontalSpan() {
        return this.width;
    }

    public void setHorizontalSpan(int width) throws Exception {
        if (this.width != width) {
            this.width = width;
            this.getPropertyByTitle("colspan").setValue((Object)width);
        }
    }

    public int getVerticalSpan() {
        return this.height;
    }

    public void setVerticalSpan(int height) throws Exception {
        if (this.height != height) {
            this.height = height;
            this.getPropertyByTitle("rowspan").setValue((Object)height);
        }
    }

    public boolean getHorizontalGrab() {
        return this.horizontalGrab;
    }

    public void setHorizontalGrab(boolean grab) throws Exception {
        if (this.horizontalGrab != grab) {
            this.horizontalGrab = grab;
            this.getPropertyByTitle("grabHorizontal").setValue((Object)grab);
        }
    }

    public boolean getVerticalGrab() {
        return this.verticalGrab;
    }

    public void setVerticalGrab(boolean grab) throws Exception {
        if (this.verticalGrab != grab) {
            this.verticalGrab = grab;
            this.getPropertyByTitle("grabVertical").setValue((Object)grab);
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) throws Exception {
        if (this.horizontalAlignment != alignment) {
            this.horizontalAlignment = alignment;
            this.setEnumProperty("align", alignment);
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int alignment) throws Exception {
        if (this.verticalAlignment != alignment) {
            this.verticalAlignment = alignment;
            this.setEnumProperty("valign", alignment);
        }
    }

    public int getHeightHint() {
        return this.heightHint;
    }

    public void setHeightHint(int heightHint) throws Exception {
        if (this.heightHint != heightHint) {
            this.heightHint = heightHint;
            this.getPropertyByTitle("heightHint").setValue((Object)heightHint);
        }
    }

    private void setEnumProperty(String propertyTitle, int value) throws Exception {
        Property property = this.getPropertyByTitle(propertyTitle);
        property.setValue((Object)value);
    }

    public Image getSmallAlignmentImage(boolean horizontal) {
        if (horizontal) {
            switch (this.horizontalAlignment) {
                case 2: {
                    return TableWrapLayoutImages.getImage((String)"h/left.gif");
                }
                case 4: {
                    return TableWrapLayoutImages.getImage((String)"h/center.gif");
                }
                case 8: {
                    return TableWrapLayoutImages.getImage((String)"h/right.gif");
                }
            }
            Assert.isTrue((this.horizontalAlignment == 128 ? 1 : 0) != 0);
            return TableWrapLayoutImages.getImage((String)"h/fill.gif");
        }
        switch (this.verticalAlignment) {
            case 16: {
                return TableWrapLayoutImages.getImage((String)"v/top.gif");
            }
            case 32: {
                return TableWrapLayoutImages.getImage((String)"v/middle.gif");
            }
            case 64: {
                return TableWrapLayoutImages.getImage((String)"v/bottom.gif");
            }
        }
        Assert.isTrue((this.verticalAlignment == 128 ? 1 : 0) != 0);
        return TableWrapLayoutImages.getImage((String)"v/fill.gif");
    }

    public void addContextMenu(IMenuManager manager) {
        MenuManager manager2 = new MenuManager("Horizontal alignment");
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IContributionItem)manager2);
        manager2.add((IAction)new SetGrabAction((ITableWrapDataInfo)this, "&Grab excess space", "grow.gif", true));
        manager2.add((IContributionItem)new Separator());
        this.fillHorizontalAlignmentMenu((IMenuManager)manager2);
        manager2 = new MenuManager("Vertical alignment");
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IContributionItem)manager2);
        manager2.add((IAction)new SetGrabAction((ITableWrapDataInfo)this, "&Grab excess space", "grow.gif", false));
        manager2.add((IContributionItem)new Separator());
        this.fillVerticalAlignmentMenu((IMenuManager)manager2);
    }

    public void fillHorizontalAlignmentMenu(IMenuManager manager) {
        manager.add((IAction)new SetAlignmentAction((ITableWrapDataInfo)this, "&Left", "left.gif", true, 2));
        manager.add((IAction)new SetAlignmentAction((ITableWrapDataInfo)this, "&Center", "center.gif", true, 4));
        manager.add((IAction)new SetAlignmentAction((ITableWrapDataInfo)this, "&Right", "right.gif", true, 8));
        manager.add((IAction)new SetAlignmentAction((ITableWrapDataInfo)this, "&Fill", "fill.gif", true, 128));
    }

    public void fillVerticalAlignmentMenu(IMenuManager manager) {
        manager.add((IAction)new SetAlignmentAction((ITableWrapDataInfo)this, "&Top", "top.gif", false, 16));
        manager.add((IAction)new SetAlignmentAction((ITableWrapDataInfo)this, "&Middle", "middle.gif", false, 32));
        manager.add((IAction)new SetAlignmentAction((ITableWrapDataInfo)this, "&Bottom", "bottom.gif", false, 64));
        manager.add((IAction)new SetAlignmentAction((ITableWrapDataInfo)this, "&Fill", "fill.gif", false, 128));
    }
}

