/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceOutput;
import com.mongodb.ReadPreference;
import java.util.Iterator;
import java.util.logging.Level;
import org.bson.BSONObject;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSet;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSetMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryModel;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class MDbOperation {
    private QueryModel m_model;
    private DBCollection m_queryCollection;
    private DBObject m_fieldsObj;
    private DBObject m_queryObj;
    private MDbResultSetMetaData m_rsMetaData;
    private static final MDbOperation sm_factory = new MDbOperation();

    static MDbOperation createQueryOperation(QueryModel queryModel) {
        MDbOperation mDbOperation;
        if (queryModel == null || !queryModel.isValid()) {
            throw new IllegalArgumentException("null/invalid QueryModel");
        }
        if (queryModel.getQueryProperties().hasValidCommandOperation()) {
            MDbOperation mDbOperation2 = sm_factory;
            mDbOperation2.getClass();
            mDbOperation = mDbOperation2.new CommandOperation(queryModel);
        } else {
            mDbOperation = new MDbOperation(queryModel);
        }
        return mDbOperation;
    }

    private MDbOperation() {
    }

    private MDbOperation(QueryModel queryModel) {
        this.m_model = queryModel;
    }

    protected QueryModel getModel() {
        return this.m_model;
    }

    protected void setResultSetMetaData(MDbResultSetMetaData rsmd) {
        this.m_rsMetaData = rsmd;
    }

    MDbResultSetMetaData getResultSetMetaData() {
        return this.m_rsMetaData;
    }

    protected void resetPreparedState() {
        this.m_queryCollection = null;
        this.m_fieldsObj = null;
        this.m_queryObj = null;
        this.m_rsMetaData = null;
    }

    protected void prepare(DBCollection dbCollection) throws OdaException {
        this.resetPreparedState();
        QueryProperties queryProps = this.getModel().getQueryProperties();
        DBObject queryObj = queryProps.getFindQueryExprAsParsedObject();
        if (queryObj == null) {
            queryObj = new BasicDBObject();
        }
        DBObject fieldsObj = queryProps.getSelectedFieldsAsProjectionKeys();
        try {
            DBCursor mdRowsCursor = dbCollection.find(queryObj, fieldsObj);
            this.applyPropertiesToCursor(mdRowsCursor, queryProps, true, false);
            this.m_rsMetaData = new MDbResultSetMetaData(mdRowsCursor, queryProps.getSelectedFieldNames(), queryProps.isAutoFlattening());
            this.m_queryCollection = dbCollection;
            this.m_fieldsObj = fieldsObj;
            this.m_queryObj = queryObj;
        }
        catch (RuntimeException ex) {
            DriverUtil.getLogger().log(Level.SEVERE, "Encountered RuntimeException in QueryModel#prepareQuery(DBCollection).", ex);
            throw new OdaException((Throwable)ex);
        }
    }

    protected MDbResultSet execute() throws OdaException {
        if (this.m_queryObj == null || this.m_queryCollection == null) {
            throw new OdaException(Messages.mDbOp_invalidQueryExpr);
        }
        try {
            DBCursor rowsCursor = this.m_queryCollection.find(this.m_queryObj, this.m_fieldsObj);
            this.applyPropertiesToCursor(rowsCursor, this.getModel().getQueryProperties(), false, true);
            return new MDbResultSet((Iterator<DBObject>)rowsCursor, this.getResultSetMetaData(), this.getModel().getQueryProperties());
        }
        catch (RuntimeException ex) {
            DriverUtil.getLogger().log(Level.SEVERE, "Encountered RuntimeException: ", ex);
            throw new OdaException((Throwable)ex);
        }
    }

    private void applyPropertiesToCursor(DBCursor rowsCursor, QueryProperties queryProps, boolean includeMetaDataSearchLimit, boolean includeSortExpr) {
        Integer searchLimit;
        if (includeMetaDataSearchLimit && (searchLimit = Integer.valueOf(this.getModel().getEffectiveMDSearchLimit(queryProps))) > 0) {
            rowsCursor.limit(searchLimit.intValue());
        }
        MDbOperation.applyPropertiesToCursor(rowsCursor, queryProps, includeSortExpr);
    }

    static void applyPropertiesToCursor(DBCursor rowsCursor, QueryProperties queryProps, boolean includeSortExpr) {
        DBObject hintObj;
        ReadPreference readPref;
        if (includeSortExpr) {
            DBObject sortExprObj = null;
            try {
                sortExprObj = queryProps.getSortExprAsParsedObject();
            }
            catch (OdaException ex) {
                DriverUtil.getLogger().log(Level.WARNING, Messages.bind((String)"Unable to parse the user-defined Sort Expression: {0}", (Object)queryProps.getSortExpr()), ex);
            }
            if (sortExprObj != null) {
                rowsCursor.sort(sortExprObj);
            }
        }
        if ((readPref = queryProps.getTaggableReadPreference()) != null) {
            rowsCursor.setReadPreference(readPref);
        }
        if (queryProps.getBatchSize() > 0) {
            rowsCursor.batchSize(queryProps.getBatchSize().intValue());
        }
        if (queryProps.getNumDocsToSkip() > 0) {
            rowsCursor.skip(queryProps.getNumDocsToSkip().intValue());
        }
        if ((hintObj = queryProps.getIndexHintsAsParsedObject()) != null) {
            rowsCursor.hint(hintObj);
        } else {
            String hintValue = queryProps.getIndexHints();
            if (!hintValue.isEmpty()) {
                rowsCursor.hint(hintValue);
            }
        }
        if (queryProps.hasNoTimeOut()) {
            rowsCursor.addOption(16);
        }
        if (queryProps.isPartialResultsOk()) {
            rowsCursor.addOption(128);
        }
    }

    protected QueryProperties getEffectiveProperties() {
        return this.getModel().getQueryProperties();
    }

    static Iterable<DBObject> callAggregateCmd(DBCollection dbCollection, QueryProperties queryProps) throws OdaException {
        if (!queryProps.hasAggregateCommand()) {
            return null;
        }
        DBObject operationExprObj = queryProps.getOperationExprAsParsedObject(true);
        if (operationExprObj == null) {
            return null;
        }
        DBObject firstOp = QueryProperties.getFirstObjectSet(operationExprObj);
        if (firstOp == null) {
            return null;
        }
        DBObject[] addlOps = QueryProperties.getSecondaryObjectSets(operationExprObj);
        try {
            AggregationOutput output = addlOps != null ? dbCollection.aggregate(firstOp, addlOps) : dbCollection.aggregate(firstOp, new DBObject[0]);
            output.getCommandResult().throwOnError();
            return output.results();
        }
        catch (RuntimeException ex) {
            OdaException odaEx = new OdaException(Messages.mDbOp_aggrCmdFailed);
            odaEx.initCause((Throwable)ex);
            throw odaEx;
        }
    }

    static MapReduceOutput callMapReduceCmd(DBCollection dbCollection, QueryProperties queryProps) throws OdaException {
        DBObject mapReduceCmd;
        if (!queryProps.hasMapReduceCommand()) {
            return null;
        }
        DBObject command = queryProps.getOperationExprAsParsedObject(false);
        if (command == null) {
            return null;
        }
        if (command.containsField("mapreduce") || command.containsField("mapReduce")) {
            mapReduceCmd = command;
        } else {
            mapReduceCmd = new BasicDBObject("mapreduce", (Object)dbCollection.getName());
            mapReduceCmd.putAll((BSONObject)command);
        }
        try {
            MapReduceOutput output = dbCollection.mapReduce(mapReduceCmd);
            output.getCommandResult().throwOnError();
            return output;
        }
        catch (RuntimeException ex) {
            OdaException odaEx = new OdaException(Messages.bind((String)Messages.mDbOp_mapReduceCmdFailed, (Object)queryProps.getOperationExpression()));
            odaEx.initCause((Throwable)ex);
            throw odaEx;
        }
    }

    static Iterable<DBObject> callDBCommand(DB connectedDB, QueryProperties queryProps) throws OdaException {
        if (!queryProps.hasRunCommand()) {
            return null;
        }
        DBObject command = queryProps.getOperationExprAsParsedObject(false);
        if (command == null) {
            return null;
        }
        try {
            CommandResult cmdResult = connectedDB.command(command);
            cmdResult.throwOnError();
            BasicDBList resultList = new BasicDBList();
            resultList.add((Object)cmdResult);
            BasicDBList resultObject = resultList;
            return (Iterable)resultObject;
        }
        catch (RuntimeException ex) {
            OdaException odaEx = new OdaException(Messages.bind((String)Messages.mDbOp_dbCmdFailed, (Object)queryProps.getOperationExpression()));
            odaEx.initCause((Throwable)ex);
            throw odaEx;
        }
    }

    /* synthetic */ MDbOperation(QueryModel queryModel, MDbOperation mDbOperation) {
        this(queryModel);
    }

    public class CommandOperation
    extends MDbOperation {
        private Iterable<DBObject> m_cmdResultObjs;
        private boolean m_hasOutputCollection;

        private CommandOperation(QueryModel queryModel) {
            super(queryModel, null);
        }

        @Override
        protected void resetPreparedState() {
            this.m_cmdResultObjs = null;
            this.m_hasOutputCollection = false;
            super.resetPreparedState();
        }

        @Override
        protected void prepare(DBCollection dbCollection) throws OdaException {
            this.resetPreparedState();
            QueryProperties queryProps = this.getModel().getQueryProperties();
            QueryModel.validateCommandSyntax(queryProps.getOperationType(), queryProps.getOperationExpression());
            Iterable cmdResults = null;
            if (queryProps.hasAggregateCommand()) {
                cmdResults = CommandOperation.callAggregateCmd(dbCollection, queryProps);
            } else if (queryProps.hasRunCommand()) {
                cmdResults = CommandOperation.callDBCommand(this.getModel().getConnectedDB(), queryProps);
            } else if (queryProps.hasMapReduceCommand()) {
                MapReduceOutput mapReduceOut = CommandOperation.callMapReduceCmd(dbCollection, queryProps);
                DBCollection mapReduceCollection = mapReduceOut.getOutputCollection();
                if (mapReduceCollection != null) {
                    super.prepare(mapReduceCollection);
                    this.m_hasOutputCollection = true;
                    return;
                }
                cmdResults = mapReduceOut.results();
            }
            if (cmdResults == null) {
                return;
            }
            this.setResultSetMetaData(new MDbResultSetMetaData(cmdResults, this.getModel().getEffectiveMDSearchLimit(queryProps), queryProps.getSelectedFieldNames(), queryProps.isAutoFlattening()));
            this.m_cmdResultObjs = cmdResults;
        }

        @Override
        protected MDbResultSet execute() throws OdaException {
            if (this.m_cmdResultObjs != null) {
                return this.getCommandResults();
            }
            return super.execute();
        }

        private MDbResultSet getCommandResults() throws OdaException {
            if (this.m_cmdResultObjs == null) {
                throw new OdaException(Messages.mDbOp_noCmdResults);
            }
            return new MDbResultSet(this.m_cmdResultObjs.iterator(), this.getResultSetMetaData(), this.getModel().getQueryProperties());
        }

        @Override
        protected QueryProperties getEffectiveProperties() {
            QueryProperties queryProps = super.getEffectiveProperties();
            if (this.m_hasOutputCollection) {
                return queryProps;
            }
            if (queryProps.getFindQueryExpr().isEmpty() && queryProps.getSortExpr().isEmpty()) {
                return queryProps;
            }
            QueryProperties effectiveProps = QueryProperties.copy(queryProps);
            effectiveProps.setFindQueryExpr(null);
            effectiveProps.setSortExpr(null);
            return effectiveProps;
        }
    }
}

