/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.adapters;

import javax.xml.namespace.QName;
import org.eclipse.bpel.fnmeta.model.Argument;
import org.eclipse.bpel.fnmeta.model.Function;
import org.eclipse.bpel.fnmeta.model.Optionality;
import org.eclipse.bpel.model.adapters.AbstractStatefulAdapter;
import org.eclipse.bpel.validator.model.IFunctionMeta;

public class FunctionAdapter
extends AbstractStatefulAdapter
implements IFunctionMeta {
    QName fFunctionQName = null;

    @Override
    public String getClassName() {
        return ((Function)this.getTarget(null, Function.class)).getClassName();
    }

    @Override
    public String getComment() {
        return ((Function)this.getTarget(null, Function.class)).getHelp();
    }

    @Override
    public String getDeprecateComment() {
        return ((Function)this.getTarget(null, Function.class)).getDeprecateComment();
    }

    @Override
    public int getMaxArity() {
        int cnt = 0;
        Function fn = (Function)this.getTarget(null, Function.class);
        for (Argument a : fn.getArguments()) {
            if (a.getOptionality() == Optionality.OPTIONAL_MANY) {
                return Integer.MAX_VALUE;
            }
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int getMinArity() {
        Function fn = (Function)this.getTarget(null, Function.class);
        int cnt = 0;
        for (Argument a : fn.getArguments()) {
            if (a.getOptionality() != Optionality.REQUIRED) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public String getName() {
        return ((Function)this.getTarget(null, Function.class)).getName();
    }

    @Override
    public String getNamespacePrefix() {
        return ((Function)this.getTarget(null, Function.class)).getPrefix();
    }

    @Override
    public String getNamespaceUri() {
        return ((Function)this.getTarget(null, Function.class)).getNamespace();
    }

    @Override
    public QName getQName() {
        if (this.fFunctionQName != null) {
            return this.fFunctionQName;
        }
        Function fn = (Function)this.getTarget(null, Function.class);
        this.fFunctionQName = new QName(fn.getNamespace(), fn.getName(), fn.getPrefix());
        return this.fFunctionQName;
    }

    @Override
    public Class<?> getReturnType() {
        Function fn = (Function)this.getTarget(null, Function.class);
        if ("string".equalsIgnoreCase(fn.getReturnType())) {
            return String.class;
        }
        if ("boolean".equalsIgnoreCase(fn.getReturnType())) {
            return Boolean.class;
        }
        if ("number".equalsIgnoreCase(fn.getReturnType())) {
            return Number.class;
        }
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return ((Function)this.getTarget(null, Function.class)).getIsDeprecated();
    }
}

