/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.contributionitems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.search.query.ShowWhereUsedComponentNameQuery;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class ShowInOMEContributionItem
extends CompoundContributionItem {
    private static final String SHOW_IN_OME_COMMANDNAME = "org.eclipse.jubula.client.ui.rcp.commands.ShowInOME";
    private static final String JUMP_ID_COMMANDID = "org.eclipse.jubula.client.ui.rcp.commands.ShowInOME.parameter.jumpId";
    private static final String JUMP_ACTION_COMMANDID = "org.eclipse.jubula.client.ui.rcp.commands.ShowInOME.parameter.jumpAction";
    private static final String JUMP_AUTNAME_COMMANDID = "org.eclipse.jubula.client.ui.rcp.commands.ShowInOME.parameter.jumpAutName";
    private static final String ACTION_OBJ_MAP = "ObjectMappingSearchResultElementAction";
    private static final String ACTION_NODE_ELEM = "NodeSearchResultElementAction";

    protected IContributionItem[] getContributionItems() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            Object element = treeSelection.getFirstElement();
            if (treeSelection.size() == 1 && element instanceof IComponentNamePO) {
                IContributionItem[] contributionArr;
                List<BasicSearchResult.SearchResultElement<?>> resultElements;
                IComponentNamePO componentName = (IComponentNamePO)element;
                if (CompNameManager.getInstance().getUsageByGuid(componentName.getGuid()) > 0 && (resultElements = this.getOMEOccurences(componentName)) != null && (contributionArr = this.createContributionItemArray(resultElements, componentName)) != null) {
                    return contributionArr;
                }
            }
        }
        return new IContributionItem[]{CommandHelper.createContributionItem((String)SHOW_IN_OME_COMMANDNAME, null, (String)"(no occurrences found)", (int)8)};
    }

    private IContributionItem[] createContributionItemArray(List<BasicSearchResult.SearchResultElement<?>> resultElements, IComponentNamePO componentName) {
        Map<IAUTMainPO, String> auts;
        ArrayList<IContributionItem> assignedContributionItems = new ArrayList<IContributionItem>();
        ArrayList<IContributionItem> unassignedContributionItems = new ArrayList<IContributionItem>();
        ArrayList unassignedSearchResults = new ArrayList();
        HashSet<String> autNames = new HashSet<String>();
        for (BasicSearchResult.SearchResultElement<?> resultElement : resultElements) {
            BasicSearchResult.ISearchResultElementAction<?> action = resultElement.getAction();
            if (action instanceof BasicSearchResult.ObjectMappingSearchResultElementAction) {
                String resultElementName = resultElement.getName();
                autNames.add(resultElementName.substring(0, resultElementName.indexOf(47) - 1));
                this.createAssignedContributionItem(assignedContributionItems, resultElement);
                continue;
            }
            if (!(action instanceof BasicSearchResult.NodeSearchResultElementAction)) continue;
            unassignedSearchResults.add(resultElement);
        }
        if (unassignedSearchResults.size() > 0 && (auts = this.determineAUTs(componentName)).size() > 0) {
            for (IAUTMainPO aut : auts.keySet()) {
                if (autNames.contains(aut.getName())) continue;
                this.createUnassignedContributionItem(unassignedContributionItems, aut);
            }
        }
        ArrayList<Object> allContributionItems = new ArrayList<Object>();
        allContributionItems.addAll(unassignedContributionItems);
        if (unassignedContributionItems.size() > 0 && assignedContributionItems.size() > 0) {
            allContributionItems.add(new Separator());
        }
        allContributionItems.addAll(assignedContributionItems);
        if (allContributionItems.size() > 0) {
            return allContributionItems.toArray(new IContributionItem[allContributionItems.size()]);
        }
        return null;
    }

    private Map<IAUTMainPO, String> determineAUTs(IComponentNamePO componentName) {
        HashMap<IAUTMainPO, String> auts = new HashMap<IAUTMainPO, String>();
        block0: for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
            for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                for (String compNameGuid : assoc.getLogicalNames()) {
                    if (!componentName.getGuid().equals(compNameGuid)) continue;
                    auts.put(aut, componentName.getGuid());
                    continue block0;
                }
            }
        }
        return auts;
    }

    private void createAssignedContributionItem(List<IContributionItem> assignedContributionItems, BasicSearchResult.SearchResultElement<?> resultElement) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(JUMP_ID_COMMANDID, String.valueOf(resultElement.getData()));
        params.put(JUMP_ACTION_COMMANDID, ACTION_OBJ_MAP);
        IContributionItem contributionItem = CommandHelper.createContributionItem((String)SHOW_IN_OME_COMMANDNAME, params, (String)resultElement.getName(), (int)8);
        assignedContributionItems.add(contributionItem);
    }

    private void createUnassignedContributionItem(List<IContributionItem> unassignedContributionItems, IAUTMainPO aut) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(JUMP_AUTNAME_COMMANDID, aut.getName());
        params.put(JUMP_ACTION_COMMANDID, ACTION_NODE_ELEM);
        IContributionItem contributionItem = CommandHelper.createContributionItem((String)SHOW_IN_OME_COMMANDNAME, params, (String)(String.valueOf(aut.getName()) + " (AUT)"), (int)8);
        unassignedContributionItems.add(contributionItem);
    }

    private List<BasicSearchResult.SearchResultElement<?>> getOMEOccurences(IComponentNamePO componentName) {
        if (componentName != null) {
            ShowWhereUsedComponentNameQuery query = new ShowWhereUsedComponentNameQuery(componentName);
            query.run((IProgressMonitor)new NullProgressMonitor());
            ISearchResult searchResult = query.getSearchResult();
            ArrayList objectMappingResults = new ArrayList();
            if (searchResult instanceof BasicSearchResult) {
                BasicSearchResult basicResult = (BasicSearchResult)query.getSearchResult();
                List resultList = basicResult.getResultList();
                for (BasicSearchResult.SearchResultElement element : resultList) {
                    BasicSearchResult.ISearchResultElementAction action = element.getAction();
                    if (!(action instanceof BasicSearchResult.ObjectMappingSearchResultElementAction) && !(action instanceof BasicSearchResult.NodeSearchResultElementAction)) continue;
                    objectMappingResults.add(element);
                }
            }
            return objectMappingResults;
        }
        return null;
    }
}

