/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.libra.facet.Messages;
import org.eclipse.libra.facet.OSGiBundleFacetRealm;
import org.eclipse.libra.facet.OSGiBundleFacetUtils;
import org.eclipse.libra.facet.internal.LibraFacetPlugin;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundleFacetInstallConfig
extends ActionConfig
implements IFacetedProjectListener {
    private static final String QUALIFIER = "qualifier";
    private IObservableValue symbolicNameValue;
    private IObservableValue versionValue;
    private IObservableValue nameValue;
    private IObservableValue vendorValue;
    private Map<String, String> headers;

    public OSGiBundleFacetInstallConfig() {
        Realm realm = OSGiBundleFacetRealm.getRealm();
        this.headers = new HashMap<String, String>();
        this.symbolicNameValue = new WritableValue(realm, this.getDefaultSymbolicName(), String.class);
        this.versionValue = new WritableValue(realm, (Object)this.getDefaultVersion(), String.class);
        this.nameValue = new WritableValue(realm, this.getDefaultSymbolicName(), String.class);
        this.vendorValue = new WritableValue(realm, this.getDefaultVendor(), String.class);
    }

    public IObservableValue getSymbolicNameValue() {
        return this.symbolicNameValue;
    }

    public IObservableValue getVersionValue() {
        return this.versionValue;
    }

    public IObservableValue getNameValue() {
        return this.nameValue;
    }

    public IObservableValue getVendorValue() {
        return this.vendorValue;
    }

    public String getSymbolicName() {
        return (String)this.getSymbolicNameValue().getValue();
    }

    public Version getVersion() {
        return Version.parseVersion((String)((String)this.getVersionValue().getValue()));
    }

    public String getName() {
        return (String)this.getNameValue().getValue();
    }

    public String getVendor() {
        return (String)this.getVendorValue().getValue();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setFacetedProjectWorkingCopy(IFacetedProjectWorkingCopy fpjwc) {
        super.setFacetedProjectWorkingCopy(fpjwc);
        fpjwc.addListener((IFacetedProjectListener)this, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_NAME_CHANGED});
        this.updateHeaders();
        this.updateDefaultValues();
    }

    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.PROJECT_NAME_CHANGED) {
            this.updateDefaultNameValues();
        }
    }

    private void updateHeaders() {
        try {
            IFile manifest = null;
            IProject project = this.getProject();
            if (project != null) {
                manifest = OSGiBundleFacetUtils.getManifestFile(project);
            }
            if (manifest != null && manifest.exists()) {
                Map manifestHeaders = ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), null);
                for (Map.Entry entry : manifestHeaders.entrySet()) {
                    this.headers.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (Exception e) {
            LibraFacetPlugin.logError(e);
        }
    }

    private void updateDefaultNameValues() {
        this.symbolicNameValue.setValue(this.getDefaultSymbolicName());
        this.nameValue.setValue(this.getDefaultName());
    }

    private void updateDefaultValues() {
        this.symbolicNameValue.setValue(this.getDefaultSymbolicName());
        this.versionValue.setValue((Object)this.getDefaultVersion());
        this.nameValue.setValue(this.getDefaultName());
        this.vendorValue.setValue(this.getDefaultVendor());
    }

    private Object getDefaultSymbolicName() {
        String symbolicName = null;
        if (this.headers.containsKey("Bundle-SymbolicName")) {
            symbolicName = this.headers.get("Bundle-SymbolicName");
        } else {
            IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
            if (fpjwc != null) {
                symbolicName = fpjwc.getProjectName();
            }
        }
        return symbolicName;
    }

    private String getDefaultVersion() {
        String version = null;
        version = this.headers.containsKey("Bundle-Version") ? this.headers.get("Bundle-Version") : new Version(1, 0, 0, QUALIFIER).toString();
        return version;
    }

    private Object getDefaultName() {
        String bundleName = null;
        if (this.headers.containsKey("Bundle-Name")) {
            bundleName = this.headers.get("Bundle-Name");
        } else {
            IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
            if (fpjwc != null && (bundleName = fpjwc.getProjectName()) != null && bundleName.length() > 0 && !Character.isTitleCase(bundleName.charAt(0))) {
                StringBuilder builder = new StringBuilder(bundleName);
                builder.replace(0, 1, String.valueOf(Character.toTitleCase(bundleName.charAt(0))));
                bundleName = builder.toString();
            }
        }
        return bundleName;
    }

    private Object getDefaultVendor() {
        String vendor = null;
        if (this.headers.containsKey("Bundle-Vendor")) {
            vendor = this.headers.get("Bundle-Vendor");
        }
        return vendor;
    }

    private IProject getProject() {
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        if (fpjwc == null) {
            return null;
        }
        IFacetedProject fproj = fpjwc.getFacetedProject();
        if (fproj == null) {
            return null;
        }
        return fproj.getProject();
    }

    public static class SymbolicNameValidator
    implements IValidator {
        public IStatus validate(Object value) {
            String symbolicName = (String)value;
            if (symbolicName == null || symbolicName.trim().length() == 0) {
                return ValidationStatus.error((String)Messages.OSGiBundleFacetInstallConfig_EmptySymbolicName);
            }
            return ValidationStatus.ok();
        }
    }

    public static class VersionValidator
    implements IValidator {
        public IStatus validate(Object value) {
            String version = (String)value;
            if (version == null || version.trim().length() == 0) {
                return ValidationStatus.error((String)Messages.OSGiBundleFacetInstallConfig_EmptyVersion);
            }
            return ValidationStatus.ok();
        }
    }
}

