/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.util;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.pmf.pim.Action;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.ApplicationAction;
import org.eclipse.pmf.pim.Authentication;
import org.eclipse.pmf.pim.Command;
import org.eclipse.pmf.pim.CompositeDataForm;
import org.eclipse.pmf.pim.DataAssocication;
import org.eclipse.pmf.pim.DataCollection;
import org.eclipse.pmf.pim.DataComposite;
import org.eclipse.pmf.pim.DataConverter;
import org.eclipse.pmf.pim.DataElement;
import org.eclipse.pmf.pim.DataField;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.DataFormFolder;
import org.eclipse.pmf.pim.DataFormSelector;
import org.eclipse.pmf.pim.DataGroup;
import org.eclipse.pmf.pim.DataInheritance;
import org.eclipse.pmf.pim.DataItem;
import org.eclipse.pmf.pim.DataModelManagerFactory;
import org.eclipse.pmf.pim.DataReference;
import org.eclipse.pmf.pim.ElementalDataForm;
import org.eclipse.pmf.pim.Library;
import org.eclipse.pmf.pim.PMF;
import org.eclipse.pmf.pim.PMFObject;
import org.eclipse.pmf.pim.PMFPackage;
import org.eclipse.pmf.pim.RegexValidator;
import org.eclipse.pmf.pim.Sorter;
import org.eclipse.pmf.pim.SortingDirection;
import org.eclipse.pmf.pim.SystemAction;
import org.eclipse.pmf.pim.UIObject;
import org.eclipse.pmf.pim.Validator;
import org.eclipse.pmf.pim.ViewProfile;
import org.eclipse.pmf.pim.Wizard;

public class PMFValidator
extends EObjectValidator {
    public static final PMFValidator INSTANCE = new PMFValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.pmf.pim";
    public static final int DATAFORM__NO_CIRCULAR_CONTAINMENT = 20;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return PMFPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDataForm((DataForm)value, diagnostics, context);
            }
            case 1: {
                return this.validateElementalDataForm((ElementalDataForm)value, diagnostics, context);
            }
            case 2: {
                return this.validateCompositeDataForm((CompositeDataForm)value, diagnostics, context);
            }
            case 3: {
                return this.validateDataFormSelector((DataFormSelector)value, diagnostics, context);
            }
            case 4: {
                return this.validateDataField((DataField)value, diagnostics, context);
            }
            case 5: {
                return this.validateDataElement((DataElement)value, diagnostics, context);
            }
            case 6: {
                return this.validateDataCollection((DataCollection)value, diagnostics, context);
            }
            case 7: {
                return this.validateApplication((Application)value, diagnostics, context);
            }
            case 8: {
                return this.validateDataComposite((DataComposite)value, diagnostics, context);
            }
            case 9: {
                return this.validateDataGroup((DataGroup)value, diagnostics, context);
            }
            case 10: {
                return this.validateDataItem((DataItem)value, diagnostics, context);
            }
            case 11: {
                return this.validateDataReference((DataReference)value, diagnostics, context);
            }
            case 12: {
                return this.validateUIObject((UIObject)value, diagnostics, context);
            }
            case 13: {
                return this.validateCommand((Command)value, diagnostics, context);
            }
            case 14: {
                return this.validateAction((Action)value, diagnostics, context);
            }
            case 15: {
                return this.validateSystemAction((SystemAction)value, diagnostics, context);
            }
            case 16: {
                return this.validateApplicationAction((ApplicationAction)value, diagnostics, context);
            }
            case 17: {
                return this.validateDataFormFolder((DataFormFolder)value, diagnostics, context);
            }
            case 18: {
                return this.validateTypeToDataFormFolderEntryMap((Map.Entry)value, diagnostics, context);
            }
            case 19: {
                return this.validatePMF((PMF)value, diagnostics, context);
            }
            case 20: {
                return this.validateDataModelManagerFactory((DataModelManagerFactory)value, diagnostics, context);
            }
            case 21: {
                return this.validateDataConverter((DataConverter)value, diagnostics, context);
            }
            case 22: {
                return this.validateValidator((Validator)value, diagnostics, context);
            }
            case 23: {
                return this.validateViewProfile((ViewProfile)value, diagnostics, context);
            }
            case 24: {
                return this.validatePMFObject((PMFObject)value, diagnostics, context);
            }
            case 25: {
                return this.validateSorter((Sorter)value, diagnostics, context);
            }
            case 26: {
                return this.validateDataInheritance((DataInheritance)value, diagnostics, context);
            }
            case 27: {
                return this.validateDataAssocication((DataAssocication)value, diagnostics, context);
            }
            case 28: {
                return this.validateLibrary((Library)value, diagnostics, context);
            }
            case 29: {
                return this.validateRegexValidator((RegexValidator)value, diagnostics, context);
            }
            case 30: {
                return this.validateEClassToEventEntryMap((Map.Entry)value, diagnostics, context);
            }
            case 31: {
                return this.validateAuthentication((Authentication)value, diagnostics, context);
            }
            case 32: {
                return this.validateWizard((Wizard)value, diagnostics, context);
            }
            case 33: {
                return this.validateSortingDirection((SortingDirection)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDataForm(DataForm dataForm, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataForm, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataForm, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataForm_nameConflict(dataForm, diagnostics, context);
        }
        return result;
    }

    public boolean validateElementalDataForm(ElementalDataForm elementalDataForm, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(elementalDataForm, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(elementalDataForm, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(elementalDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(elementalDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(elementalDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(elementalDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(elementalDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(elementalDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(elementalDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(elementalDataForm, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompositeDataForm(CompositeDataForm compositeDataForm, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(compositeDataForm, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(compositeDataForm, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(compositeDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(compositeDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(compositeDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(compositeDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(compositeDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(compositeDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(compositeDataForm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(compositeDataForm, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataFormSelector(DataFormSelector dataFormSelector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataFormSelector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataFormSelector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataFormSelector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataFormSelector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataFormSelector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataFormSelector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataFormSelector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataFormSelector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataFormSelector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataFormSelector, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataField(DataField dataField, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataField, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataField, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataField, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataElement(DataElement dataElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataElement_TypeMismatch(DataElement dataElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"TypeMismatch", PMFValidator.getObjectLabel((EObject)dataElement, context)}, new Object[]{dataElement}, context));
        }
        return true;
    }

    public boolean validateDataCollection(DataCollection dataCollection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataCollection, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataCollection, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataCollection, diagnostics, context);
        }
        return result;
    }

    public boolean validateApplication(Application application, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryDefaultConstraint(application, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateApplication_validate(application, diagnostics, context);
        }
        return result;
    }

    public boolean validateApplication_validate(Application application, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return application.validate(diagnostics, context);
    }

    public boolean validateDataForm_nameConflict(DataForm dataForm, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryDefaultConstraint(dataForm, diagnostics, context);
        if (result || diagnostics != null) {
            result &= dataForm.validate_nameConflict(diagnostics, context);
        }
        return result;
    }

    public boolean validateDataComposite(DataComposite dataComposite, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataComposite, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataComposite, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataComposite, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataComposite, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataComposite, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataComposite, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataComposite, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataComposite, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataComposite, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataComposite, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataGroup(DataGroup dataGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataGroup, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataGroup, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataGroup, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataItem(DataItem dataItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataItem, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataItem, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataItem, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataReference(DataReference dataReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataReference, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataReference, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataReference, diagnostics, context);
        }
        return result;
    }

    public boolean validateUIObject(UIObject uiObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(uiObject, diagnostics, context);
    }

    public boolean validateCommand(Command command, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(command, diagnostics, context);
    }

    public boolean validateAction(Action action, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(action, diagnostics, context);
    }

    public boolean validateSystemAction(SystemAction systemAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(systemAction, diagnostics, context);
    }

    public boolean validateApplicationAction(ApplicationAction applicationAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(applicationAction, diagnostics, context);
    }

    public boolean validateDataFormFolder(DataFormFolder dataFormFolder, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataFormFolder, diagnostics, context);
    }

    public boolean validateTypeToDataFormFolderEntryMap(Map.Entry<?, ?> typeToDataFormFolderEntryMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)typeToDataFormFolderEntryMap, diagnostics, context);
    }

    public boolean validatePMF(PMF pmf, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(pmf, diagnostics, context);
    }

    public boolean validateDataModelManagerFactory(DataModelManagerFactory dataModelManagerFactory, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataModelManagerFactory, diagnostics, context);
    }

    public boolean validateDataConverter(DataConverter dataConverter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataConverter, diagnostics, context);
    }

    public boolean validateValidator(Validator validator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(validator, diagnostics, context);
    }

    public boolean validateViewProfile(ViewProfile viewProfile, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(viewProfile, diagnostics, context);
    }

    public boolean validatePMFObject(PMFObject pmfObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(pmfObject, diagnostics, context);
    }

    public boolean validateSorter(Sorter sorter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(sorter, diagnostics, context);
    }

    public boolean validateDataInheritance(DataInheritance dataInheritance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataInheritance, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataInheritance, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataInheritance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataInheritance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataInheritance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataInheritance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataInheritance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataInheritance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataInheritance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataInheritance, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataAssocication(DataAssocication dataAssocication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataAssocication, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataAssocication, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataAssocication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataAssocication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataAssocication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataAssocication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataAssocication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataAssocication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataAssocication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataElement_TypeMismatch(dataAssocication, diagnostics, context);
        }
        return result;
    }

    public boolean validateLibrary(Library library, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryDefaultConstraint(library, diagnostics, context);
        if (result || diagnostics != null) {
            for (Map.Entry dataFormFolder : library.getDataFormFolders()) {
                for (DataForm dataForm : ((DataFormFolder)dataFormFolder.getValue()).getDataForms()) {
                    result &= this.validateDataForm(dataForm, diagnostics, context);
                }
            }
        }
        return result;
    }

    public boolean validateRegexValidator(RegexValidator regexValidator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(regexValidator, diagnostics, context);
    }

    public boolean validateEClassToEventEntryMap(Map.Entry<?, ?> eClassToEventEntryMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)eClassToEventEntryMap, diagnostics, context);
    }

    public boolean validateAuthentication(Authentication authentication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(authentication, diagnostics, context);
    }

    public boolean validateWizard(Wizard wizard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(wizard, diagnostics, context);
    }

    public boolean validateSortingDirection(SortingDirection sortingDirection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

