/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.search;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.s2e.nls.internal.search.NlsFindKeysJob;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.ui.text.Match;

public class NlsFindKeyQuery
extends FileSearchQuery {
    private final String m_nlsKey;
    private final INlsProject m_project;

    public NlsFindKeyQuery(INlsProject project, String nlsKey) {
        super("", false, false, null);
        this.m_project = project;
        this.m_nlsKey = nlsKey;
    }

    public String getResultLabel(int matches) {
        return "References to the NLS key '" + this.getNlsKey() + "' (" + matches + ")";
    }

    public String getLabel() {
        return "Find references to the NLS key '" + this.getNlsKey() + "'...";
    }

    public FileSearchResult getSearchResult() {
        return (FileSearchResult)super.getSearchResult();
    }

    public IStatus run(IProgressMonitor monitor) {
        NlsFindKeysJob nlsFindReferencesJob = new NlsFindKeysJob(this.getNlsKey(), this.getLabel());
        nlsFindReferencesJob.run(monitor);
        List<Match> matches = nlsFindReferencesJob.getMatches(this.getNlsKey());
        this.getSearchResult().removeAll();
        this.getSearchResult().addMatches(matches.toArray(new Match[matches.size()]));
        return Status.OK_STATUS;
    }

    public String getNlsKey() {
        return this.m_nlsKey;
    }

    public INlsProject getProject() {
        return this.m_project;
    }
}

