/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.internal.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.internal.dto.DtoDerivedResourceHandler;
import org.eclipse.scout.sdk.s2e.trigger.IDerivedResourceHandler;
import org.eclipse.scout.sdk.s2e.trigger.IDerivedResourceHandlerFactory;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class DtoDerivedResourceHandlerFactory
implements IDerivedResourceHandlerFactory {
    @Override
    public List<IDerivedResourceHandler> createHandlersFor(Set<IResource> resources, IJavaEnvironmentProvider envProvider, IJavaSearchScope searchScope) throws CoreException {
        HashSet<IType> baseTypes = new HashSet<IType>();
        this.findScopeCandidates(searchScope, baseTypes);
        this.findResourceCandidates(resources, baseTypes);
        if (baseTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IDerivedResourceHandler> handlers = new ArrayList<IDerivedResourceHandler>(baseTypes.size());
        for (IType t : baseTypes) {
            handlers.add(new DtoDerivedResourceHandler(t, envProvider));
        }
        return handlers;
    }

    protected void findResourceCandidates(Set<IResource> resources, Collection<IType> collector) throws CoreException {
        for (IResource r : resources) {
            IJavaElement javaElement = JavaCore.create((IResource)r);
            if (!S2eUtils.exists(javaElement) || javaElement.getElementType() != 5) continue;
            ICompilationUnit icu = (ICompilationUnit)javaElement;
            IType[] iTypeArray = icu.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType candidate = iTypeArray[n2];
                if (this.acceptType(candidate) && S2eUtils.exists((IJavaElement)S2eUtils.getFirstAnnotationInSupertypeHierarchy(candidate, "org.eclipse.scout.rt.client.dto.Data", "org.eclipse.scout.rt.client.dto.FormData", "org.eclipse.scout.rt.client.dto.PageData"))) {
                    collector.add(candidate);
                }
                ++n2;
            }
        }
    }

    protected void findScopeCandidates(IJavaSearchScope scope, Collection<IType> collector) throws CoreException {
        if (scope == null) {
            return;
        }
        for (IType candidate : S2eUtils.findAllTypesAnnotatedWith("org.eclipse.scout.rt.client.dto.Data", scope, null)) {
            if (!this.acceptType(candidate)) continue;
            collector.add(candidate);
        }
        for (IType candidate : S2eUtils.findAllTypesAnnotatedWith("org.eclipse.scout.rt.client.dto.FormData", scope, null)) {
            if (!this.acceptType(candidate)) continue;
            collector.add(candidate);
        }
        for (IType candidate : S2eUtils.findAllTypesAnnotatedWith("org.eclipse.scout.rt.client.dto.PageData", scope, null)) {
            if (!this.acceptType(candidate)) continue;
            collector.add(candidate);
        }
    }

    protected boolean acceptType(IType jdtType) throws CoreException {
        return S2eUtils.exists((IJavaElement)jdtType) && S2eUtils.exists((IJavaElement)jdtType.getJavaProject()) && !jdtType.isAnonymous() && !jdtType.isBinary() && jdtType.getDeclaringType() == null && Flags.isPublic((int)jdtType.getFlags());
    }
}

