/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.ImageProvider;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractMenuContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.LayersActivationAction;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.graphics.Image;

public class LayersContribution
extends AbstractMenuContributionItem {
    private static final ImageDescriptor DESC_LAYER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/layers.gif");

    @Override
    protected Image getMenuImage() {
        EObject diagram;
        Diagram gmfDiagram = this.part.getDiagram();
        if (gmfDiagram != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram) {
            super.setDiagram((DDiagram)diagram);
            if (!this.getActivatedOptionalLayers().isEmpty()) {
                return DiagramUIPlugin.Implementation.getDecoratedCheckedImage(DESC_LAYER);
            }
        }
        return DiagramUIPlugin.getPlugin().getImage(DESC_LAYER);
    }

    @Override
    protected String getLabel() {
        return Messages.LayersContribution_label;
    }

    @Override
    protected void setDiagram(DDiagram diagram) {
        super.setDiagram(diagram);
    }

    @Override
    protected void menuShow(IMenuManager manager) {
        Collection<Layer> layers = this.getOptionalLayers();
        ArrayList<Layer> nonTransientlayers = new ArrayList<Layer>();
        ArrayList<Layer> transientLayers = new ArrayList<Layer>();
        for (Layer layer : layers) {
            if (LayerHelper.isTransientLayer((Layer)layer)) {
                transientLayers.add(layer);
                continue;
            }
            nonTransientlayers.add(layer);
        }
        for (Layer layer : nonTransientlayers) {
            this.addLayerMenuItem(manager, layer);
        }
        manager.add((IContributionItem)new Separator("Transient layers"));
        for (Layer layer : transientLayers) {
            this.addLayerMenuItem(manager, layer);
        }
    }

    private Collection<Layer> getOptionalLayers() {
        DiagramDescription diagramDesc = this.diagram.getDescription();
        ArrayList<Layer> allLayers = new ArrayList<Layer>((Collection<Layer>)new DiagramComponentizationManager().getAllLayers(this.session.getSelectedViewpoints(false), diagramDesc));
        allLayers.remove(diagramDesc.getDefaultLayer());
        Iterables.removeIf(allLayers, (Predicate)new Predicate<Layer>(){

            public boolean apply(Layer layer) {
                if (layer instanceof AdditionalLayer) {
                    return !((AdditionalLayer)layer).isOptional();
                }
                return false;
            }
        });
        return allLayers;
    }

    private Collection<Layer> getActivatedOptionalLayers() {
        Collection allLayers = new ArrayList(new DDiagramQuery(this.diagram).getAllActivatedLayers()).stream().filter(layer -> {
            if (layer instanceof AdditionalLayer) {
                return ((AdditionalLayer)layer).isOptional();
            }
            return false;
        }).collect(Collectors.toList());
        return allLayers;
    }

    private void addLayerMenuItem(IMenuManager manager, Layer layer) {
        String nameEntry = MessageTranslator.INSTANCE.getMessage((EObject)layer, new IdentifiedElementQuery((IdentifiedElement)layer).getLabel());
        LayersActivationAction action = new LayersActivationAction(nameEntry, 2, this.diagram, layer);
        if (!StringUtil.isEmpty((String)layer.getIcon())) {
            action.setImageDescriptor(ImageProvider.getImageDescriptor((String)layer.getIcon()));
        }
        manager.add((IContributionItem)new ActionContributionItem((IAction)action){

            public void dispose() {
                super.dispose();
                ((LayersActivationAction)this.getAction()).dispose();
            }
        });
        this.addTooltip(this.getTooltipText(layer));
    }

    private String getTooltipText(Layer layer) {
        String endUserDoc = layer.getEndUserDocumentation();
        if (endUserDoc != null && endUserDoc.trim().length() > 0) {
            return endUserDoc;
        }
        String nameEntry = MessageTranslator.INSTANCE.getMessage((EObject)layer, new IdentifiedElementQuery((IdentifiedElement)layer).getLabel());
        return nameEntry;
    }
}

