/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.CompareWithRevisionAction;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.ui.history.HistoryPageCompareEditorInput;
import org.eclipse.team.ui.history.HistoryPageSource;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.part.IPage;

public class ReplaceWithRevisionAction
extends CompareWithRevisionAction {
    @Override
    protected void showCompareInDialog(Shell shell, Object object) {
        IHistoryPageSource pageSource = HistoryPageSource.getHistoryPageSource((Object)object);
        if (pageSource != null && pageSource.canShowHistoryFor(object)) {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(false);
            cc.setRightEditable(false);
            HistoryPageCompareEditorInput input = new HistoryPageCompareEditorInput(cc, pageSource, object){

                public void saveChanges(IProgressMonitor monitor) throws CoreException {
                    super.saveChanges(monitor);
                    ((CVSHistoryPage)this.getHistoryPage()).saveChanges(monitor);
                    this.setDirty(false);
                }

                protected void performReplace(Object o) throws CoreException {
                    FileRevisionTypedElement right = (FileRevisionTypedElement)o;
                    IFile file = (IFile)this.getCompareResult();
                    file.setContents(right.getContents(), false, true, null);
                }

                protected IPage createPage(CompareViewerPane parent, IToolBarManager toolBarManager) {
                    IPage page = super.createPage(parent, toolBarManager);
                    this.setTitle(NLS.bind((String)CVSUIMessages.ReplaceWithRevisionAction_0, (Object)((IHistoryPage)page).getName()));
                    this.setPageDescription(((IHistoryPage)page).getName());
                    return page;
                }
            };
            input.setReplace(true);
            CompareUI.openCompareDialog((CompareEditorInput)input);
        }
    }

    @Override
    protected String getActionTitle() {
        return CVSUIMessages.ReplaceWithRevisionAction_1;
    }

    @Override
    protected boolean isShowInDialog() {
        return true;
    }
}

