/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.rete.aggregation.IAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;

public abstract class AbstractColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends SingleInputNode
implements Clearable,
IAggregatorNode {
    protected final IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator;
    protected final TupleMask groupMask;
    protected final TupleMask columnMask;
    protected final int sourceWidth;
    protected final IQueryRuntimeContext runtimeContext;
    protected final AggregateResult NEUTRAL;
    protected AggregatorOuterIndexer aggregatorOuterIndexer;
    protected AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexers;

    public AbstractColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, TupleMask columnMask) {
        super(reteContainer);
        this.operator = operator;
        this.groupMask = groupMask;
        this.columnMask = columnMask;
        this.sourceWidth = groupMask.indices.length;
        this.runtimeContext = reteContainer.getNetwork().getEngine().getRuntimeContext();
        this.NEUTRAL = operator.getAggregate(operator.createNeutral());
        reteContainer.registerClearable(this);
    }

    public AbstractColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, int aggregatedColumn) {
        this(reteContainer, operator, groupMask, TupleMask.selectSingle((int)aggregatedColumn, (int)groupMask.sourceWidth));
    }

    @Override
    public CommunicationTracker getCommunicationTracker() {
        return this.reteContainer.getCommunicationTracker();
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendChild(Receiver receiver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Indexer getAggregatorOuterIndexer() {
        if (this.aggregatorOuterIndexer == null) {
            this.aggregatorOuterIndexer = new AggregatorOuterIndexer();
            this.getCommunicationTracker().registerDependency(this, this.aggregatorOuterIndexer);
        }
        return this.aggregatorOuterIndexer;
    }

    @Override
    public Indexer getAggregatorOuterIdentityIndexer(int resultPositionInSignature) {
        if (this.aggregatorOuterIdentityIndexers == null) {
            this.aggregatorOuterIdentityIndexers = new AggregatorOuterIdentityIndexer[this.sourceWidth + 1];
        }
        if (this.aggregatorOuterIdentityIndexers[resultPositionInSignature] == null) {
            this.aggregatorOuterIdentityIndexers[resultPositionInSignature] = new AggregatorOuterIdentityIndexer(resultPositionInSignature);
            this.getCommunicationTracker().registerDependency(this, this.aggregatorOuterIdentityIndexers[resultPositionInSignature]);
        }
        return this.aggregatorOuterIdentityIndexers[resultPositionInSignature];
    }

    public void propagate(Tuple group, AggregateResult oldValue, AggregateResult newValue, Timestamp timestamp) {
        if (!Objects.equals(oldValue, newValue)) {
            Tuple oldResultTuple = this.tupleFromAggregateResult(group, oldValue);
            Tuple newResultTuple = this.tupleFromAggregateResult(group, newValue);
            if (this.aggregatorOuterIndexer != null) {
                this.aggregatorOuterIndexer.propagate(group, oldResultTuple, newResultTuple, timestamp);
            }
            if (this.aggregatorOuterIdentityIndexers != null) {
                AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexerArray = this.aggregatorOuterIdentityIndexers;
                int n = this.aggregatorOuterIdentityIndexers.length;
                int n2 = 0;
                while (n2 < n) {
                    AggregatorOuterIdentityIndexer aggregatorOuterIdentityIndexer = aggregatorOuterIdentityIndexerArray[n2];
                    if (aggregatorOuterIdentityIndexer != null) {
                        aggregatorOuterIdentityIndexer.propagate(group, oldResultTuple, newResultTuple, timestamp);
                    }
                    ++n2;
                }
            }
        }
    }

    public abstract Tuple getAggregateTuple(Tuple var1);

    public abstract AggregateResult getAggregateResult(Tuple var1);

    protected Tuple tupleFromAggregateResult(Tuple groupTuple, AggregateResult aggregateResult) {
        if (aggregateResult == null) {
            return null;
        }
        return Tuples.staticArityLeftInheritanceTupleOf((Tuple)groupTuple, (Object)this.runtimeContext.wrapElement(aggregateResult));
    }

    protected class AggregatorOuterIdentityIndexer
    extends StandardIndexer {
        protected final int resultPositionInSignature;
        protected final TupleMask pruneResult;
        protected final TupleMask reorderMask;

        public AggregatorOuterIdentityIndexer(int resultPositionInSignature) {
            super(AbstractColumnAggregatorNode.this.reteContainer, TupleMask.displace((int)AbstractColumnAggregatorNode.this.sourceWidth, (int)resultPositionInSignature, (int)(AbstractColumnAggregatorNode.this.sourceWidth + 1)));
            this.parent = AbstractColumnAggregatorNode.this;
            this.resultPositionInSignature = resultPositionInSignature;
            this.pruneResult = TupleMask.omit((int)resultPositionInSignature, (int)(AbstractColumnAggregatorNode.this.sourceWidth + 1));
            this.reorderMask = resultPositionInSignature == AbstractColumnAggregatorNode.this.sourceWidth ? null : this.mask;
        }

        @Override
        public Collection<Tuple> get(Tuple signatureWithResult) {
            Tuple prunedSignature = this.pruneResult.transform((ITuple)signatureWithResult);
            Object result = AbstractColumnAggregatorNode.this.getAggregateResult(prunedSignature);
            if (result != null && Objects.equals(signatureWithResult.get(this.resultPositionInSignature), result)) {
                return Collections.singleton(signatureWithResult);
            }
            return null;
        }

        public void propagate(Tuple signature, Tuple oldTuple, Tuple newTuple, Timestamp timestamp) {
            if (oldTuple != null) {
                this.propagate(Direction.REVOKE, this.reorder(oldTuple), signature, true, timestamp);
            }
            if (newTuple != null) {
                this.propagate(Direction.INSERT, this.reorder(newTuple), signature, true, timestamp);
            }
        }

        private Tuple reorder(Tuple signatureWithResult) {
            Tuple transformed = this.reorderMask == null ? signatureWithResult : this.reorderMask.transform((ITuple)signatureWithResult);
            return transformed;
        }

        @Override
        public Node getActiveNode() {
            return AbstractColumnAggregatorNode.this;
        }
    }

    protected class AggregatorOuterIndexer
    extends StandardIndexer {
        public AggregatorOuterIndexer() {
            super(AbstractColumnAggregatorNode.this.reteContainer, TupleMask.omit((int)AbstractColumnAggregatorNode.this.sourceWidth, (int)(AbstractColumnAggregatorNode.this.sourceWidth + 1)));
            this.parent = AbstractColumnAggregatorNode.this;
        }

        @Override
        public Collection<Tuple> get(Tuple signature) {
            Tuple aggregateTuple = AbstractColumnAggregatorNode.this.getAggregateTuple(signature);
            return aggregateTuple == null ? null : Collections.singleton(aggregateTuple);
        }

        public void propagate(Tuple signature, Tuple oldTuple, Tuple newTuple, Timestamp timestamp) {
            if (oldTuple != null) {
                this.propagate(Direction.REVOKE, oldTuple, signature, true, timestamp);
            }
            if (newTuple != null) {
                this.propagate(Direction.INSERT, newTuple, signature, true, timestamp);
            }
        }

        @Override
        public Node getActiveNode() {
            return AbstractColumnAggregatorNode.this;
        }
    }
}

