/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.dap;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import org.eclipse.cdt.debug.dap.CDTDebugProtocol;
import org.eclipse.cdt.debug.dap.ICDTDebugProtocolClient;
import org.eclipse.cdt.debug.dap.ICDTDebugProtocolServer;
import org.eclipse.cdt.debug.dap.MemoryBlock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.debug.DebugLauncher;

public class DapDebugTarget
extends DSPDebugTarget
implements IMemoryBlockRetrievalExtension,
ICDTDebugProtocolClient {
    public DapDebugTarget(ILaunch launch, Runnable processCleanup, InputStream in, OutputStream out, Map<String, Object> dspParameters) {
        super(launch, processCleanup, in, out, dspParameters);
    }

    protected Launcher<? extends IDebugProtocolServer> createLauncher(UnaryOperator<MessageConsumer> wrapper, InputStream in, OutputStream out, ExecutorService threadPool) {
        Launcher debugProtocolLauncher = DebugLauncher.createLauncher((Object)this, ICDTDebugProtocolServer.class, (InputStream)in, (OutputStream)out, (ExecutorService)threadPool, wrapper);
        return debugProtocolLauncher;
    }

    public ICDTDebugProtocolServer getDebugProtocolServer() {
        return (ICDTDebugProtocolServer)super.getDebugProtocolServer();
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.dap", 5011, "getMemoryBlock() not supported, use getExtendedMemoryBlock()", null));
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object context) throws DebugException {
        BigInteger bigBaseAddress;
        try {
            bigBaseAddress = BigInteger.valueOf(Long.decode(expression));
        }
        catch (NumberFormatException nfexc) {
            CDTDebugProtocol.MemoryRequestArguments memoryRequestArguments = new CDTDebugProtocol.MemoryRequestArguments();
            memoryRequestArguments.setAddress(expression);
            memoryRequestArguments.setLength(1L);
            CompletableFuture<CDTDebugProtocol.MemoryContents> memory = this.getDebugProtocolServer().memory(memoryRequestArguments);
            CDTDebugProtocol.MemoryContents body = (CDTDebugProtocol.MemoryContents)DapDebugTarget.complete(memory);
            String address = body.getAddress();
            try {
                bigBaseAddress = BigInteger.valueOf(Long.decode(address));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new MemoryBlock(this, expression, bigBaseAddress, context);
    }
}

