/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.script.ScriptException;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.qt.core.IQMLAnalyzer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class QMLTernFileUpdateJob
extends Job {
    private List<IResourceDelta> deltaList;
    private final IQMLAnalyzer analyzer = Activator.getService(IQMLAnalyzer.class);

    public QMLTernFileUpdateJob(List<IResourceDelta> deltas) {
        super("Add/Remove Files in Tern");
        this.deltaList = deltas;
    }

    protected IStatus run(IProgressMonitor monitor) {
        for (IResourceDelta delta : this.deltaList) {
            IResource resource = delta.getResource();
            String fileName = resource.getFullPath().toString().substring(1);
            if (!(resource instanceof IFile)) continue;
            IFile file = (IFile)resource;
            try {
                if ((delta.getKind() & 1) > 0) {
                    this.analyzer.addFile(fileName, this.readFileContents(file.getContents()));
                    continue;
                }
                if ((delta.getKind() & 2) <= 0) continue;
                this.analyzer.deleteFile(fileName);
            }
            catch (NoSuchMethodException e) {
                Activator.log(e);
            }
            catch (ScriptException e) {
                Activator.log(e);
            }
            catch (IOException e) {
                Activator.log(e);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return Status.OK_STATUS;
    }

    private String readFileContents(InputStream stream) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder();
        while ((read = stream.read()) != -1) {
            sb.append((char)read);
        }
        return sb.toString();
    }
}

