/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.indexing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageSourceModule;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.parser.printer.SimpleCodePrinter;
import org.eclipse.emf.common.util.EList;

public class PackageSourceCollector
extends TclVisitor {
    public static final String PACKAGE = "package";
    static final String REQUIRE = "require";
    static final String PROVIDE = "provide";
    static final String IFNEEDED = "ifneeded";
    static final String EXACT = "-exact";
    static final String SOURCE = "source";
    private final Map<IScriptProject, List<TclModuleInfo>> modules = new HashMap<IScriptProject, List<TclModuleInfo>>();
    private TclModuleInfo currentModuleInfo;
    private ISourceModule currentModule;

    public void process(List<TclCommand> declaration, ISourceModule module) {
        this.currentModule = module;
        try {
            this.currentModuleInfo = this.getCreateCurrentModuleInfo(module);
            this.currentModuleInfo.getProvided().clear();
            this.currentModuleInfo.getRequired().clear();
            this.currentModuleInfo.getSourced().clear();
            TclParserUtils.traverse(declaration, (TclVisitor)this);
        }
        catch (Exception e) {
            TclPlugin.error(e);
        }
    }

    public TclModuleInfo getCreateCurrentModuleInfo(ISourceModule module) {
        if (module != null) {
            String identifier = module.getHandleIdentifier();
            IScriptProject scriptProject = module.getScriptProject();
            List<TclModuleInfo> list = this.modules.get(scriptProject);
            if (list == null) {
                list = new ArrayList<TclModuleInfo>();
                this.modules.put(scriptProject, list);
            }
            TclModuleInfo result = null;
            for (TclModuleInfo info : list) {
                if (!info.getHandle().equals(identifier)) continue;
                result = info;
                break;
            }
            if (result == null) {
                result = TclPackagesFactory.eINSTANCE.createTclModuleInfo();
                result.setHandle(identifier);
                result.setExternal(module instanceof IExternalSourceModule);
                list.add(result);
            }
            return result;
        }
        return TclPackagesFactory.eINSTANCE.createTclModuleInfo();
    }

    public boolean visit(TclCommand command) {
        Command definition = command.getDefinition();
        if (definition != null && PACKAGE.equals(definition.getName())) {
            this.processPackageCommand(command);
        }
        if (!(this.currentModule instanceof TclPackageSourceModule) && definition != null && SOURCE.equals(definition.getName())) {
            this.processSourceCommand(command);
        }
        return super.visit(command);
    }

    private TclArgument getStringArg(EList<TclArgument> args, int index) {
        if (index < args.size()) {
            return (TclArgument)args.get(index);
        }
        return null;
    }

    private void processPackageCommand(TclCommand command) {
        EList args = command.getArguments();
        TclArgument style = this.getStringArg((EList<TclArgument>)args, 0);
        if (style == null) {
            return;
        }
        String keyword = SimpleCodePrinter.getArgumentString((TclArgument)style, (int)style.getStart());
        if (REQUIRE.equalsIgnoreCase(keyword)) {
            TclArgument pkgName = this.getStringArg((EList<TclArgument>)args, 1);
            if (pkgName == null) {
                return;
            }
            String packageName = SimpleCodePrinter.getArgumentString((TclArgument)pkgName, (int)pkgName.getStart());
            if (EXACT.equals(packageName)) {
                pkgName = this.getStringArg((EList<TclArgument>)args, 2);
                if (pkgName == null) {
                    return;
                }
                packageName = SimpleCodePrinter.getArgumentString((TclArgument)pkgName, (int)pkgName.getStart());
            }
            TclSourceEntry entry = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
            entry.setValue(packageName);
            entry.setStart(pkgName.getStart());
            entry.setEnd(pkgName.getEnd());
            this.currentModuleInfo.getRequired().add((Object)entry);
        } else if (PROVIDE.equalsIgnoreCase(keyword)) {
            TclArgument pkgName = this.getStringArg((EList<TclArgument>)args, 1);
            if (pkgName == null) {
                return;
            }
            String pkg = SimpleCodePrinter.getArgumentString((TclArgument)pkgName, (int)pkgName.getStart());
            TclSourceEntry entry = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
            entry.setValue(pkg);
            entry.setStart(pkgName.getStart());
            entry.setEnd(pkgName.getEnd());
            this.currentModuleInfo.getProvided().add((Object)entry);
        }
    }

    private void processSourceCommand(TclCommand command) {
        EList arguments = command.getArguments();
        for (TclArgument tclArgument : arguments) {
            TclSourceEntry entry = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
            entry.setStart(tclArgument.getStart());
            entry.setEnd(tclArgument.getEnd());
            this.currentModuleInfo.getSourced().add((Object)entry);
            entry.setValue(SimpleCodePrinter.getArgumentString((TclArgument)tclArgument, (int)tclArgument.getStart()));
        }
    }

    public Map<IScriptProject, List<TclModuleInfo>> getModules() {
        return this.modules;
    }

    public TclModuleInfo getCurrentModuleInfo() {
        return this.currentModuleInfo;
    }
}

