/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ToggleableWarningLabel
extends Composite {
    private Label warningText;
    private Label image;
    private boolean isBuiltInImage;

    public ToggleableWarningLabel(Composite parent, int style) {
        super(parent, style);
        this.setVisible(false);
        this.setLayout((Layout)new GridLayout(2, false));
        this.image = new Label((Composite)this, 0);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.image);
        this.image.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.isBuiltInImage = true;
        this.warningText = new Label((Composite)this, 64);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.warningText);
    }

    public void showMessage(String message) {
        if (!this.isBuiltInImage) {
            this.image.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            this.isBuiltInImage = true;
        }
        this.setText(message);
    }

    public void hideMessage() {
        if (this.getVisible()) {
            this.changeVisibility(false);
        }
    }

    protected void setImage(Image image) {
        this.image.setImage(image);
        this.isBuiltInImage = false;
    }

    protected void setText(String message) {
        this.warningText.setText(message);
        this.layout(true);
        this.changeVisibility(true);
    }

    protected void changeVisibility(boolean visible) {
        this.setVisible(visible);
        GridData data = (GridData)this.getLayoutData();
        data.exclude = !visible;
        this.getParent().layout();
    }
}

