/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.model.CDOModelConstants;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.model.CDOClassInfoImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageInfoImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageUnitImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOTypeImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOModelUtil
implements CDOModelConstants {
    private static final EClass ROOT_TYPE = EcorePackage.eINSTANCE.getEObject();
    private static CDOType[] coreTypes;

    static {
        ArrayList<CDOType> types = new ArrayList<CDOType>();
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEBigDecimal(), CDOType.BIG_DECIMAL);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEBigInteger(), CDOType.BIG_INTEGER);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), CDOType.BOOLEAN_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), CDOType.BOOLEAN);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEByteArray(), CDOType.BYTE_ARRAY);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEByteObject(), CDOType.BYTE_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEByte(), CDOType.BYTE);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), CDOType.CHARACTER_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEChar(), CDOType.CHAR);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEDate(), CDOType.DATE);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), CDOType.DOUBLE_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEDouble(), CDOType.DOUBLE);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), CDOType.FLOAT_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEFloat(), CDOType.FLOAT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), CDOType.INTEGER_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEInt(), CDOType.INT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEJavaClass(), CDOType.JAVA_CLASS);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEJavaObject(), CDOType.JAVA_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getELongObject(), CDOType.LONG_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getELong(), CDOType.LONG);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEShortObject(), CDOType.SHORT_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEShort(), CDOType.SHORT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEString(), CDOType.STRING);
        coreTypes = types.toArray(new CDOType[types.size()]);
    }

    private static void registerCoreType(List<CDOType> types, EClassifier classifier, CDOType type) {
        int index = classifier.getClassifierID();
        while (index >= types.size()) {
            types.add(null);
        }
        types.set(index, type);
    }

    private CDOModelUtil() {
    }

    public static boolean isCorePackage(EPackage ePackage) {
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[0] != null) {
            return CDOPackageRegistryImpl.SYSTEM_ELEMENTS[0] == ePackage;
        }
        String nsURI = ePackage.getNsURI();
        return "http://www.eclipse.org/emf/2002/Ecore".equals(nsURI);
    }

    public static boolean isRoot(EClass eClass) {
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[1] != null) {
            return CDOPackageRegistryImpl.SYSTEM_ELEMENTS[1] == eClass;
        }
        if (CDOModelUtil.isCorePackage(eClass.getEPackage())) {
            String name = eClass.getName();
            return "EObject".equals(name);
        }
        return false;
    }

    public static boolean isResourcePackage(EPackage ePackage) {
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[2] != null) {
            return CDOPackageRegistryImpl.SYSTEM_ELEMENTS[2] == ePackage;
        }
        String nsURI = ePackage.getNsURI();
        return "http://www.eclipse.org/emf/CDO/Eresource/4.0.0".equals(nsURI);
    }

    public static boolean isResource(EClass eClass) {
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[3] != null) {
            return CDOPackageRegistryImpl.SYSTEM_ELEMENTS[3] == eClass;
        }
        if (CDOModelUtil.isResourcePackage(eClass.getEPackage())) {
            String name = eClass.getName();
            return "CDOResource".equals(name);
        }
        return false;
    }

    public static boolean isResourceFolder(EClass eClass) {
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[4] != null) {
            return CDOPackageRegistryImpl.SYSTEM_ELEMENTS[4] == eClass;
        }
        if (CDOModelUtil.isResourcePackage(eClass.getEPackage())) {
            String name = eClass.getName();
            return "CDOResourceFolder".equals(name);
        }
        return false;
    }

    public static boolean isResourceNode(EClass eClass) {
        return CDOModelUtil.isResourcePackage(eClass.getEPackage());
    }

    public static boolean isResourcePathFeature(EStructuralFeature eStructuralFeature) {
        String name;
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[8] == eStructuralFeature) {
            return true;
        }
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[9] == eStructuralFeature) {
            return true;
        }
        return CDOModelUtil.isResourceNode(eStructuralFeature.eClass()) && ("folder".equals(name = eStructuralFeature.getName()) || "name".equals(name));
    }

    public static boolean isTypesPackage(EPackage ePackage) {
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[5] != null) {
            return CDOPackageRegistryImpl.SYSTEM_ELEMENTS[5] == ePackage;
        }
        String nsURI = ePackage.getNsURI();
        return "http://www.eclipse.org/emf/CDO/Etypes/4.0.0".equals(nsURI);
    }

    public static boolean isSystemPackage(EPackage ePackage) {
        return CDOModelUtil.isCorePackage(ePackage) || CDOModelUtil.isResourcePackage(ePackage) || CDOModelUtil.isTypesPackage(ePackage);
    }

    public static boolean isSystemPackageURI(String nsURI) {
        return "http://www.eclipse.org/emf/2002/Ecore".equals(nsURI) || "http://www.eclipse.org/emf/CDO/Eresource/4.0.0".equals(nsURI) || "http://www.eclipse.org/emf/CDO/Etypes/4.0.0".equals(nsURI);
    }

    public static boolean isLob(EClassifier eClassifier) {
        if (CDOPackageRegistryImpl.SYSTEM_ELEMENTS[6] != null && CDOPackageRegistryImpl.SYSTEM_ELEMENTS[7] != null) {
            return CDOPackageRegistryImpl.SYSTEM_ELEMENTS[6] == eClassifier || CDOPackageRegistryImpl.SYSTEM_ELEMENTS[7] == eClassifier;
        }
        if (CDOModelUtil.isTypesPackage(eClassifier.getEPackage())) {
            String name = eClassifier.getName();
            return "Blob".equals(name) || "Clob".equals(name);
        }
        return false;
    }

    public static CDOType getType(EStructuralFeature feature) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            return CDOType.FEATURE_MAP_ENTRY;
        }
        return CDOModelUtil.getType(feature.getEType());
    }

    public static CDOType getType(byte typeID) {
        return CDOTypeImpl.getType(typeID);
    }

    public static CDOType getType(EClassifier classifier) {
        if (classifier instanceof EClass) {
            return CDOType.OBJECT;
        }
        if (classifier instanceof EEnum) {
            return CDOType.ENUM_ORDINAL;
        }
        EDataType eDataType = (EDataType)classifier;
        EPackage ePackage = eDataType.getEPackage();
        if (CDOModelUtil.isCorePackage(ePackage)) {
            CDOType type = CDOModelUtil.getCoreType((EClassifier)eDataType);
            if (type != null) {
                return type;
            }
        } else if (CDOModelUtil.isTypesPackage(ePackage)) {
            String name = eDataType.getName();
            if ("Blob".equals(name)) {
                return CDOType.BLOB;
            }
            if ("Clob".equals(name)) {
                return CDOType.CLOB;
            }
            throw new IllegalArgumentException("Illegal data type: " + eDataType);
        }
        return CDOType.CUSTOM;
    }

    public static CDOType getCoreType(EClassifier eDataType) {
        int index = eDataType.getClassifierID();
        if (index >= 0 && index < coreTypes.length) {
            return coreTypes[index];
        }
        return null;
    }

    public static CDOType getPrimitiveType(Class<? extends Object> primitiveType) {
        if (primitiveType == String.class) {
            return CDOType.STRING;
        }
        if (primitiveType == Boolean.class) {
            return CDOType.BOOLEAN;
        }
        if (primitiveType == Integer.class) {
            return CDOType.INT;
        }
        if (primitiveType == Double.class) {
            return CDOType.DOUBLE;
        }
        if (primitiveType == Float.class) {
            return CDOType.FLOAT;
        }
        if (primitiveType == Long.class) {
            return CDOType.LONG;
        }
        if (primitiveType == Date.class) {
            return CDOType.DATE;
        }
        if (primitiveType == Byte.class) {
            return CDOType.BYTE;
        }
        if (primitiveType == Character.class) {
            return CDOType.CHAR;
        }
        if (primitiveType == Object[].class) {
            return CDOType.OBJECT_ARRAY;
        }
        if (EEnumLiteral.class.isAssignableFrom(primitiveType) || Enumerator.class.isAssignableFrom(primitiveType)) {
            return CDOType.ENUM_LITERAL;
        }
        if (Map.class.isAssignableFrom(primitiveType)) {
            return CDOType.MAP;
        }
        if (Set.class.isAssignableFrom(primitiveType)) {
            return CDOType.SET;
        }
        if (List.class.isAssignableFrom(primitiveType)) {
            return CDOType.LIST;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOModelUtil.7"), primitiveType));
    }

    public static CDOType getTypeOfObject(Object object) {
        if (object == null || object instanceof CDOID || object instanceof CDORevision) {
            return CDOType.OBJECT;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == String.class) {
            return CDOType.STRING;
        }
        if (objectClass == Integer.class) {
            return CDOType.INTEGER_OBJECT;
        }
        if (objectClass == Long.class) {
            return CDOType.LONG_OBJECT;
        }
        if (objectClass == Boolean.class) {
            return CDOType.BOOLEAN_OBJECT;
        }
        if (objectClass == Character.class) {
            return CDOType.CHARACTER_OBJECT;
        }
        if (objectClass == Double.class) {
            return CDOType.DOUBLE_OBJECT;
        }
        if (objectClass == Float.class) {
            return CDOType.FLOAT_OBJECT;
        }
        if (objectClass == Short.class) {
            return CDOType.SHORT_OBJECT;
        }
        if (objectClass == Byte.class) {
            return CDOType.BYTE_OBJECT;
        }
        if (objectClass == byte[].class) {
            return CDOType.BYTE_ARRAY;
        }
        if (objectClass == Date.class || object instanceof Date) {
            return CDOType.DATE;
        }
        if (object instanceof EEnumLiteral) {
            return CDOType.ENUM_LITERAL;
        }
        if (objectClass == BigDecimal.class || object instanceof BigDecimal) {
            return CDOType.BIG_DECIMAL;
        }
        if (objectClass == BigInteger.class || object instanceof BigInteger) {
            return CDOType.BIG_INTEGER;
        }
        if (object instanceof FeatureMap.Entry) {
            return CDOType.FEATURE_MAP_ENTRY;
        }
        if (object instanceof Throwable) {
            return CDOType.EXCEPTION;
        }
        throw new IllegalArgumentException("Object type " + objectClass.getName() + " is not supported.");
    }

    public static CDOPackageInfo getPackageInfo(Object value, CDOPackageRegistry packageRegistry) {
        CDOPackageInfo packageInfo;
        if (value instanceof EPackage) {
            return packageRegistry.getPackageInfo((EPackage)value);
        }
        if (value instanceof CDOPackageInfo && (packageInfo = (CDOPackageInfo)value).getPackageUnit().getPackageRegistry() == packageRegistry) {
            return packageInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDOClassInfo getClassInfo(EClass eClass) {
        EClass eClass2 = eClass;
        synchronized (eClass2) {
            EList adapters = eClass.eAdapters();
            CDOClassInfo classInfo = (CDOClassInfo)EcoreUtil.getAdapter((List)adapters, CDOClassInfo.class);
            if (classInfo == null) {
                classInfo = new CDOClassInfoImpl();
                adapters.add(0, (Object)classInfo);
            }
            return classInfo;
        }
    }

    @Deprecated
    public static EStructuralFeature[] getAllPersistentFeatures(EClass eClass) {
        CDOClassInfo classInfo = CDOModelUtil.getClassInfo(eClass);
        return classInfo.getAllPersistentFeatures();
    }

    public static CDOPackageUnit createPackageUnit() {
        return new CDOPackageUnitImpl();
    }

    public static CDOPackageInfo createPackageInfo() {
        return new CDOPackageInfoImpl();
    }

    public static EPackage readPackage(ExtendedDataInput in, ResourceSet resourceSet, boolean lookForResource) throws IOException {
        String uri = in.readString();
        boolean zipped = in.readBoolean();
        byte[] bytes = in.readByteArray();
        return EMFUtil.createEPackage(uri, bytes, zipped, resourceSet, lookForResource);
    }

    public static void writePackage(ExtendedDataOutput out, EPackage ePackage, boolean zipped, EPackage.Registry packageRegistry) throws IOException {
        CDOModelUtil.checkCrossResourceURIs(ePackage);
        byte[] bytes = EMFUtil.getEPackageBytes(ePackage, zipped, packageRegistry);
        out.writeString(ePackage.getNsURI());
        out.writeBoolean(zipped);
        out.writeByteArray(bytes);
    }

    /*
     * Unable to fully structure code
     */
    public static void checkCrossResourceURIs(EPackage ePackage) {
        it = ePackage.eAllContents();
        while (it.hasNext()) {
            e = (EObject)it.next();
            if (e instanceof EAnnotation) {
                it.prune();
                continue;
            }
            for (EObject r : e.eCrossReferences()) {
                refTarget = null;
                if (r.eIsProxy()) {
                    msg = "Package '%s' contains unresolved proxy '%s'";
                    msg = String.format(msg, new Object[]{ePackage.getNsURI(), ((InternalEObject)r).eProxyURI()});
                    throw new IllegalStateException(msg);
                }
                if (r.eResource() == null || r.eResource() == e.eResource()) continue;
                pkg = null;
                if (r instanceof EClassifier) {
                    refTarget = r;
                    pkg = ((EClassifier)r).getEPackage();
                } else if (r instanceof EStructuralFeature) {
                    refTarget = r;
                    feature = (EStructuralFeature)r;
                    ownerClass = (EClass)feature.eContainer();
                    pkg = ownerClass.getEPackage();
                } else if (r instanceof EGenericType && (c = (genType = (EGenericType)r).getEClassifier()) != null) {
                    refTarget = c;
                    pkg = c.getEPackage();
                }
                if (pkg != null) ** GOTO lbl31
                continue;
lbl-1000:
                // 1 sources

                {
                    pkg = pkg.getESuperPackage();
lbl31:
                    // 2 sources

                    ** while (pkg.getESuperPackage() != null)
                }
lbl32:
                // 1 sources

                resourceURI = refTarget.eResource().getURI().toString();
                if (resourceURI.toString().equals(pkg.getNsURI())) continue;
                msg = "URI of the resource (%s) does not match the nsURI (%s) of the top-level package;\nthis can be fixed by calling Resource.setURI(URI) after loading the packages,\nor by configuring a URI mapping from nsURI's to location URI's before loading the packages,\nand then loading them with their nsURI's";
                msg = String.format(msg, new Object[]{resourceURI, pkg.getNsURI()});
                throw new IllegalStateException(msg);
            }
        }
    }

    public static Map<EClass, List<EClass>> getSubTypes(EPackage.Registry packageRegistry) {
        HashMap<EClass, List<EClass>> result = new HashMap<EClass, List<EClass>>();
        for (String nsURI : packageRegistry.keySet()) {
            EPackage ePackage = packageRegistry.getEPackage(nsURI);
            CDOModelUtil.getSubTypes(ePackage, result);
        }
        return result;
    }

    private static void getSubTypes(EPackage ePackage, Map<EClass, List<EClass>> result) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            EClass eClass = (EClass)classifier;
            CDOModelUtil.getSubType(eClass, ROOT_TYPE, result);
            for (EClass eSuperType : eClass.getEAllSuperTypes()) {
                CDOModelUtil.getSubType(eClass, eSuperType, result);
            }
        }
    }

    private static void getSubType(EClass eClass, EClass eSuperType, Map<EClass, List<EClass>> result) {
        if (eSuperType.eIsProxy()) {
            OM.LOG.warn("getSubTypes encountered a proxy EClass which will be ignored: " + eSuperType);
            return;
        }
        List<EClass> list = result.get(eSuperType);
        if (list == null) {
            list = new ArrayList<EClass>();
            result.put(eSuperType, list);
        }
        list.add(eClass);
    }
}

