/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.explorer.ui.ViewerUtil;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutStateManager;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutViewerRefresh;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.ui.CDOLabelDecorator;
import org.eclipse.emf.cdo.ui.CDOTreeExpansionAgent;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public final class CDOCheckoutState {
    private static final Image CHECKOUT_IMAGE = OM.getImage("icons/checkout.gif");
    private static final Image CHECKOUT_CLOSED_IMAGE = OM.getImage("icons/checkout_closed.gif");
    private static final Image FOLDER_IMAGE = OM.getImage("icons/CDOResourceFolder.gif");
    private static final Image ERROR_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private static final IEditorRegistry EDITOR_REGISTRY = PlatformUI.getWorkbench().getEditorRegistry();
    private final IListener checkoutManagerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            CDOCheckoutManager.CheckoutStateEvent e;
            if (event instanceof CDOCheckoutManager.CheckoutStateEvent && (e = (CDOCheckoutManager.CheckoutStateEvent)event).getCheckout() == CDOCheckoutState.this.checkout) {
                CDOCheckout.State state = e.getNewState();
                if (state == CDOCheckout.State.Open) {
                    CDOCheckoutState.this.initTreeExpansionAgent();
                } else if (state == CDOCheckout.State.Closed) {
                    CDOCheckoutState.this.disposeTreeExpansionAgent();
                }
            }
        }
    };
    private final EventBroker eventBroker = new EventBroker();
    private final CDOCheckoutStateManager stateManager;
    private final CDOCheckout checkout;
    private final ComposedAdapterFactory adapterFactory;
    private final ContentProvider contentProvider;
    private final LabelProvider labelProvider;
    private CDOTreeExpansionAgent treeExpansionAgent;

    CDOCheckoutState(CDOCheckoutStateManager stateManager, CDOCheckout checkout) {
        this.stateManager = stateManager;
        this.checkout = checkout;
        this.adapterFactory = CDOEditor.createAdapterFactory((boolean)true);
        CDOCheckoutViewerRefresh viewerRefresh = stateManager.getViewerRefresh();
        CDOCheckoutContentProvider main = stateManager.getMainContentProvider();
        this.contentProvider = new ContentProvider(this, viewerRefresh);
        this.contentProvider.inputChanged((Viewer)main.getViewer(), null, main.getInput());
        ResourceManager resourceManager = stateManager.getResourceManager();
        this.labelProvider = new LabelProvider(this, resourceManager);
        this.labelProvider.addListener(this.eventBroker);
        this.initTreeExpansionAgent();
        CDOExplorerUtil.getCheckoutManager().addListener(this.checkoutManagerListener);
    }

    void inputChanged(TreeViewer newTreeViewer, Object oldInput, Object newInput) {
        this.contentProvider.inputChanged((Viewer)newTreeViewer, oldInput, newInput);
        if (this.treeExpansionAgent != null && newTreeViewer != this.treeExpansionAgent.getViewer()) {
            this.disposeTreeExpansionAgent();
        }
        if (newTreeViewer != null) {
            this.initTreeExpansionAgent();
        }
    }

    public CDOCheckout getCheckout() {
        return this.checkout;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public ContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void addListener(ILabelProviderListener listener) {
        this.eventBroker.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.eventBroker.removeListener(listener);
    }

    public void dispose() {
        CDOExplorerUtil.getCheckoutManager().removeListener(this.checkoutManagerListener);
        this.disposeTreeExpansionAgent();
        this.labelProvider.dispose();
        this.contentProvider.dispose();
        this.adapterFactory.dispose();
        this.eventBroker.dispose();
    }

    private void disposeTreeExpansionAgent() {
        if (this.treeExpansionAgent != null) {
            this.treeExpansionAgent.dispose();
            this.treeExpansionAgent = null;
        }
    }

    private void initTreeExpansionAgent() {
        TreeViewer viewer;
        CDOView view;
        if (this.treeExpansionAgent == null && (view = this.checkout.getView()) != null && (viewer = this.stateManager.getMainContentProvider().getViewer()) != null) {
            this.treeExpansionAgent = new CDOTreeExpansionAgent(view, viewer);
        }
    }

    public static final class ContentProvider
    extends AdapterFactoryContentProvider {
        private final CDOCheckoutState checkoutState;

        public ContentProvider(CDOCheckoutState checkoutState, AdapterFactoryContentProvider.ViewerRefresh viewerRefresh) {
            super((AdapterFactory)checkoutState.getAdapterFactory());
            this.checkoutState = checkoutState;
            this.viewerRefresh = viewerRefresh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getElements(Object object) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                return super.getElements(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getChildren(Object object) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                return super.getChildren(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasChildren(Object object) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                return super.hasChildren(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getParent(Object object) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                return super.getParent(object);
            }
        }

        public void notifyChanged(Notification notification) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof EObject) {
                CDOCheckout checkout;
                Adapter adapter;
                EReference reference;
                EObject eObject = (EObject)notifier;
                Object feature = notification.getFeature();
                if (feature instanceof EReference && (reference = (EReference)feature).isContainment() && (adapter = EcoreUtil.getAdapter((List)eObject.eAdapters(), CDOCheckout.class)) instanceof CDOCheckout && (checkout = (CDOCheckout)adapter).isOpen()) {
                    notification = new ViewerNotification(notification, (Object)checkout, true, true);
                }
            }
            super.notifyChanged(notification);
        }
    }

    private static final class EventBroker
    extends EventManager
    implements ILabelProviderListener {
        private EventBroker() {
        }

        public void addListener(ILabelProviderListener listener) {
            this.addListenerObject(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.removeListenerObject(listener);
        }

        public void labelProviderChanged(final LabelProviderChangedEvent event) {
            Object[] listeners = this.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ILabelProviderListener listener = (ILabelProviderListener)listeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        listener.labelProviderChanged(event);
                    }
                });
                ++i;
            }
        }

        public void dispose() {
            this.clearListeners();
        }
    }

    public static final class LabelProvider
    extends AdapterFactoryLabelProvider
    implements IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private final CDOCheckoutState checkoutState;
        private final ResourceManager resourceManager;

        public LabelProvider(CDOCheckoutState checkoutState, ResourceManager resourceManager) {
            super((AdapterFactory)checkoutState.getAdapterFactory());
            this.checkoutState = checkoutState;
            this.resourceManager = resourceManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Color getForeground(Object object) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                if (object instanceof ViewerUtil.Pending) {
                    return ContainerItemProvider.PENDING_COLOR;
                }
                return super.getForeground(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Color getBackground(Object object) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                return super.getBackground(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Font getFont(Object object) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                return super.getFont(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getText(Object element) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                try {
                    CDOElement checkoutElement;
                    CDOCheckout checkout;
                    String text;
                    if (element instanceof CDOCheckout && !StringUtil.isEmpty((String)(text = (checkout = (CDOCheckout)element).getLabel()))) {
                        return text;
                    }
                    if (element instanceof CDOElement && !StringUtil.isEmpty((String)(text = (checkoutElement = (CDOElement)element).toString()))) {
                        return text;
                    }
                    if (element instanceof EObject) {
                        checkoutElement = (CDOElement)EcoreUtil.getExistingAdapter((Notifier)((Notifier)element), CDOElement.class);
                        if (checkoutElement != null && !StringUtil.isEmpty((String)(text = checkoutElement.toString(element)))) {
                            return text;
                        }
                        if (element instanceof CDOResourceNode) {
                            CDOResourceNode resourceNode = (CDOResourceNode)element;
                            String name = resourceNode.getName();
                            if (name == null) {
                                return "";
                            }
                            return name;
                        }
                    }
                    if (element instanceof ViewerUtil.Pending) {
                        ViewerUtil.Pending pending = (ViewerUtil.Pending)element;
                        return pending.getText();
                    }
                    String text2 = super.getText(element);
                    if (!StringUtil.isEmpty((String)text2)) {
                        return text2;
                    }
                }
                catch (Exception text2) {
                    // empty catch block
                }
                try {
                    EObject eObject;
                    EClass eClass;
                    String text;
                    if (element instanceof EObject && !StringUtil.isEmpty((String)(text = this.getText(eClass = (eObject = (EObject)element).eClass())))) {
                        return text;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return element.getClass().getSimpleName();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image getImage(Object element) {
            CDOCheckoutState cDOCheckoutState = this.checkoutState;
            synchronized (cDOCheckoutState) {
                try {
                    if (element instanceof CDOCheckout) {
                        CDOCheckout checkout = (CDOCheckout)element;
                        if (checkout.isOpen()) {
                            return CDOLabelDecorator.decorate((Image)CHECKOUT_IMAGE, (Object)checkout.getRootObject());
                        }
                        return CHECKOUT_CLOSED_IMAGE;
                    }
                    if (element instanceof ViewerUtil.Pending) {
                        return ContainerItemProvider.PENDING_IMAGE;
                    }
                    if (element instanceof CDOElement) {
                        element = ((CDOElement)element).getDelegate();
                        Image image = this.doGetImage(element);
                        return CDOLabelDecorator.decorate((Image)image, (Object)element);
                    }
                    Image image = this.doGetImage(element);
                    if (image == null) {
                        return ERROR_IMAGE;
                    }
                    return image;
                }
                catch (Exception ex) {
                    return ERROR_IMAGE;
                }
            }
        }

        private Image doGetImage(Object element) {
            if (element instanceof CDOResourceLeaf) {
                Image image;
                String name = ((CDOResourceLeaf)element).getName();
                if (name == null) {
                    return FOLDER_IMAGE;
                }
                IEditorDescriptor editorDescriptor = EDITOR_REGISTRY.getDefaultEditor(name);
                if (editorDescriptor != null && !"org.eclipse.ui.DefaultTextEditor".equals(editorDescriptor.getId()) && (image = this.getWorkbenchImage(name)) != null) {
                    return image;
                }
            }
            return super.getImage(element);
        }

        private Image getWorkbenchImage(String name) {
            ImageDescriptor imageDescriptor = EDITOR_REGISTRY.getImageDescriptor(name);
            if (imageDescriptor != null) {
                return (Image)this.resourceManager.get((DeviceResourceDescriptor)imageDescriptor);
            }
            return null;
        }
    }
}

