/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.internal.explorer.checkouts.OfflineCDOCheckout;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.handlers.AbstractBaseHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceCheckinHandler
extends AbstractBaseHandler<OfflineCDOCheckout> {
    public WorkspaceCheckinHandler() {
        super(OfflineCDOCheckout.class, Boolean.valueOf(false));
    }

    protected boolean updateSelection(ISelection selection) {
        OfflineCDOCheckout checkout;
        boolean result = super.updateSelection(selection);
        if (result && !(checkout = (OfflineCDOCheckout)this.elements.get(0)).isDirty()) {
            return false;
        }
        return result;
    }

    protected void doExecute(final ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        OfflineCDOCheckout checkout = (OfflineCDOCheckout)this.elements.get(0);
        InternalCDOWorkspace workspace = checkout.getWorkspace();
        if (workspace != null) {
            InternalCDOTransaction.ChangeSetOutdatedException exception = null;
            try {
                workspace.checkin();
            }
            catch (CommitException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof InternalCDOTransaction.ChangeSetOutdatedException) {
                    exception = (InternalCDOTransaction.ChangeSetOutdatedException)cause;
                }
                throw ex;
            }
            catch (InternalCDOTransaction.ChangeSetOutdatedException ex) {
                exception = ex;
            }
            if (exception != null) {
                UIUtil.syncExec((Runnable)new Runnable(){

                    public void run() {
                        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                        if (shell == null) {
                            shell = UIUtil.getShell();
                        }
                        MessageDialog.openError((Shell)shell, (String)"Checkin Error", (String)"Your checkout is outdated and needs to be updated.");
                    }
                });
            }
        }
    }
}

