/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.treecontentmanager.EMFCompareDeferredTreeContentManager;
import org.eclipse.emf.compare.ide.ui.internal.treecontentmanager.EMFCompareDeferredTreeContentManagerUtil;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider2;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class EMFCompareStructureMergeViewerContentProvider
extends AdapterFactoryContentProvider
implements IJobChangeListener {
    private final EMFCompareDeferredTreeContentManager contentManagerAdapter;
    private boolean isFetchingGroup;
    private final ReentrantLock lock;
    private final List<FetchListener> listeners;
    private List<CallbackHolder> callbacks;
    private Object[] pending;

    public EMFCompareStructureMergeViewerContentProvider(AdapterFactory adapterFactory, AbstractTreeViewer viewer) {
        super(adapterFactory);
        this.contentManagerAdapter = EMFCompareDeferredTreeContentManagerUtil.createEMFDeferredTreeContentManager(viewer);
        this.contentManagerAdapter.addUpdateCompleteListener(this);
        this.lock = new ReentrantLock();
        this.listeners = new CopyOnWriteArrayList<FetchListener>();
        this.callbacks = new CopyOnWriteArrayList<CallbackHolder>();
    }

    public Object getParent(Object element) {
        Optional cia;
        Object parentNode;
        Object ret = element instanceof CompareInputAdapter ? ((parentNode = super.getParent((Object)((Adapter)element).getTarget())) instanceof TreeNode ? ((cia = Iterators.tryFind((Iterator)((TreeNode)parentNode).eAdapters().iterator(), (Predicate)Predicates.instanceOf(CompareInputAdapter.class))).isPresent() ? cia.get() : parentNode) : parentNode) : (element instanceof ICompareInput ? null : super.getParent(element));
        return ret;
    }

    public void runWhenReady(CallbackType type, Runnable runnable) {
        this.lock.lock();
        try {
            if (this.isFetchingGroup) {
                this.callbacks.add(new CallbackHolder(runnable, type));
            } else {
                this.run(runnable, type);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void run(Runnable callback, CallbackType type) {
        switch (type) {
            case IN_UI_SYNC: {
                SWTUtil.safeSyncExec((Runnable)callback);
                break;
            }
            case IN_UI_ASYNC: {
                SWTUtil.safeAsyncExec((Runnable)callback);
                break;
            }
            default: {
                callback.run();
            }
        }
    }

    public boolean addFetchingListener(FetchListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeFetchingListener(FetchListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean hasChildren(Object element) {
        boolean ret = element instanceof CompareInputAdapter ? super.hasChildren((Object)((Adapter)element).getTarget()) : (element instanceof ICompareInput ? false : super.hasChildren(element));
        return ret;
    }

    public Object[] getChildren(Object element) {
        Object[] rawChildren = this.getRawChildren(element);
        return this.adaptElementsToCompareInput(rawChildren);
    }

    protected Object[] getRawChildren(Object element) {
        Object[] children = element instanceof CompareInputAdapter ? this.getCompareInputAdapterChildren((CompareInputAdapter)((Object)element)) : (element instanceof ICompareInput ? new Object[]{} : super.getChildren(element));
        if (children == null) {
            children = new Object[]{};
        }
        return children;
    }

    protected Object[] adaptElementsToCompareInput(Object[] elements) {
        Object[] result = new Object[elements.length];
        int i = 0;
        while (i < result.length) {
            Object child = elements[i];
            if (child instanceof PendingUpdateAdapter) {
                result[i] = child;
            } else {
                result[i] = this.adapterFactory.adapt(child, ICompareInput.class);
                if (result[i] == null) {
                    result[i] = child;
                }
            }
            ++i;
        }
        return result;
    }

    private Object[] getCompareInputAdapterChildren(CompareInputAdapter compareInputAdapter) {
        TreeNode treeNode;
        Notifier target = compareInputAdapter.getTarget();
        if (target instanceof TreeNode && (treeNode = (TreeNode)target).getData() instanceof Comparison) {
            IDifferenceGroupProvider2 groupProvider2 = this.getGroupProvider2(treeNode);
            this.lock.lock();
            try {
                if (groupProvider2 != null && !groupProvider2.groupsAreBuilt()) {
                    Object[] objectArray = this.deferReturnChildren(compareInputAdapter);
                    return objectArray;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return super.getChildren((Object)compareInputAdapter.getTarget());
    }

    private Object[] deferReturnChildren(CompareInputAdapter compareInputAdapter) {
        if (!this.isFetchingGroup) {
            this.isFetchingGroup = true;
            for (FetchListener callback : this.listeners) {
                callback.startFetching();
            }
            compareInputAdapter.setDeferredAdapter(new EMFCompareStructureMergeViewerContentProviderDeferredAdapter(this));
            this.pending = this.contentManagerAdapter.getChildren((Object)compareInputAdapter);
        }
        return this.pending;
    }

    private IDifferenceGroupProvider2 getGroupProvider2(TreeNode treeNode) {
        IDifferenceGroupProvider2 result = null;
        Optional searchResult = Iterables.tryFind((Iterable)treeNode.eAdapters(), (Predicate)Predicates.instanceOf(IDifferenceGroupProvider2.class));
        if (searchResult.isPresent()) {
            return (IDifferenceGroupProvider2)searchResult.get();
        }
        return result;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public void dispose() {
        super.dispose();
        this.contentManagerAdapter.removeUpdateCompleteListener(this);
        this.listeners.clear();
    }

    public void notifyChanged(Notification notification) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && this.viewer.getInput() != null) {
            if (notification instanceof IViewerNotification) {
                if (this.viewerRefresh == null) {
                    this.viewerRefresh = new EMFCompareViewerRefresh(this.viewer);
                }
                if (this.viewerRefresh.addNotification((IViewerNotification)notification)) {
                    this.viewer.getControl().getDisplay().asyncExec((Runnable)this.viewerRefresh);
                }
            } else {
                NotifyChangedToViewerRefresh.handleNotifyChanged((Viewer)this.viewer, (Object)notification.getNotifier(), (int)notification.getEventType(), (Object)notification.getFeature(), (Object)notification.getOldValue(), (Object)notification.getNewValue(), (int)notification.getPosition());
            }
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        if (event.getResult().isOK()) {
            this.lock.lock();
            try {
                if (this.isFetchingGroup) {
                    this.isFetchingGroup = false;
                    this.pending = null;
                    for (FetchListener listener : this.listeners) {
                        listener.doneFetching();
                        if (!this.isFetchingGroup) continue;
                        return;
                    }
                    Iterator<CallbackHolder> callbacksIterator = this.callbacks.iterator();
                    while (callbacksIterator.hasNext()) {
                        CallbackHolder callbackHolder = callbacksIterator.next();
                        this.run(callbackHolder.getCallback(), callbackHolder.getType());
                        if (!this.isFetchingGroup) continue;
                        ArrayList remainingCallBack = Lists.newArrayList(callbacksIterator);
                        this.callbacks = new CopyOnWriteArrayList<CallbackHolder>(remainingCallBack);
                        return;
                    }
                    this.callbacks.clear();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private static class CallbackHolder {
        private final Runnable callback;
        private final CallbackType callbackType;

        public CallbackHolder(Runnable callback, CallbackType callbackType) {
            this.callback = callback;
            this.callbackType = callbackType;
        }

        private Runnable getCallback() {
            return this.callback;
        }

        private CallbackType getType() {
            return this.callbackType;
        }
    }

    public static enum CallbackType {
        IN_UI_SYNC,
        IN_UI_ASYNC,
        IN_CURRENT_THREAD;

    }

    private static class EMFCompareStructureMergeViewerContentProviderDeferredAdapter
    implements IDeferredWorkbenchAdapter {
        private final EMFCompareStructureMergeViewerContentProvider contentProvider;

        public EMFCompareStructureMergeViewerContentProviderDeferredAdapter(EMFCompareStructureMergeViewerContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewerContentProvider.deferredWorkbenchAdapter.label");
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (!monitor.isCanceled() && object instanceof CompareInputAdapter) {
                Notifier target = ((Adapter)object).getTarget();
                Object[] children = this.contentProvider.getChildren(target);
                collector.add(children, monitor);
            }
        }

        public boolean isContainer() {
            return true;
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }
    }

    private static class EMFCompareViewerRefresh
    extends AdapterFactoryContentProvider.ViewerRefresh {
        int count = 0;
        final Viewer targetViewer;

        public EMFCompareViewerRefresh(Viewer viewer) {
            super(viewer);
            this.targetViewer = viewer;
        }

        protected void refresh(IViewerNotification notification) {
            Object element = notification.getElement();
            if (this.targetViewer instanceof StructuredViewer) {
                StructuredViewer structuredViewer = (StructuredViewer)this.targetViewer;
                ISelection selection = structuredViewer.getSelection();
                boolean isStaleSelection = this.isStale(selection);
                if (isStaleSelection) {
                    this.targetViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                AbstractTreeViewer treeViewer = structuredViewer instanceof AbstractTreeViewer ? (AbstractTreeViewer)structuredViewer : null;
                List expandedElements = treeViewer == null ? Collections.emptyList() : Arrays.asList(treeViewer.getExpandedElements());
                boolean isStaleExpandedElements = this.isStale(expandedElements);
                if (element != null) {
                    if (notification.isContentRefresh()) {
                        structuredViewer.refresh(element, notification.isLabelUpdate());
                    } else if (notification.isLabelUpdate()) {
                        structuredViewer.update(element, null);
                    }
                } else {
                    structuredViewer.refresh(notification.isLabelUpdate());
                }
                if (isStaleSelection || isStaleExpandedElements) {
                    Object object = structuredViewer.getInput();
                    EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)object);
                    if (editingDomain == null) {
                        Object[] objectArray = ((IStructuredContentProvider)structuredViewer.getContentProvider()).getElements(object);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)child);
                            if (editingDomain != null) break;
                            ++n2;
                        }
                    }
                    if (editingDomain instanceof AdapterFactoryEditingDomain) {
                        AdapterFactoryEditingDomain adapterFactoryEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
                        if (treeViewer != null && isStaleExpandedElements) {
                            treeViewer.setExpandedElements(adapterFactoryEditingDomain.resolve(expandedElements).toArray());
                        }
                        if (isStaleSelection) {
                            structuredViewer.setSelection((ISelection)new StructuredSelection(adapterFactoryEditingDomain.resolve((Collection)((IStructuredSelection)selection).toList())), true);
                        }
                    }
                }
            } else {
                this.targetViewer.refresh();
            }
        }

        private boolean isStale(Object object) {
            if (object instanceof IWrapperItemProvider) {
                IWrapperItemProvider wrapper = (IWrapperItemProvider)object;
                return this.isStale(wrapper.getValue()) || this.isStale(wrapper.getOwner());
            }
            if (object instanceof Collection) {
                for (Object item : (Collection)object) {
                    if (!this.isStale(item)) continue;
                    return true;
                }
                return false;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (this.isStale(item)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                return eObject.eIsProxy() && eObject.eAdapters().isEmpty();
            }
            if (object instanceof FeatureMap.Entry) {
                return this.isStale(((FeatureMap.Entry)object).getValue());
            }
            if (object == null) {
                return false;
            }
            if (object instanceof IStructuredSelection) {
                return this.isStale(((IStructuredSelection)object).toArray());
            }
            return false;
        }

        public synchronized boolean addNotification(IViewerNotification notification) {
            if (super.addNotification(notification)) {
                this.count = 0;
                return true;
            }
            if (this.count > 30) {
                super.addNotification((IViewerNotification)new ViewerNotification((Notification)notification, null, true, true));
            }
            ++this.count;
            return false;
        }
    }

    static class FetchListener {
        FetchListener() {
        }

        public void startFetching() {
        }

        public void doneFetching() {
        }
    }
}

