/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.search.data.SearchOptions;
import org.eclipse.jubula.client.ui.rcp.search.data.TestSuiteBrowserWrapper;
import org.eclipse.jubula.client.ui.rcp.search.data.TreeViewSelectionRetriever;
import org.eclipse.jubula.client.ui.rcp.search.data.TypeName;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractStringQuery;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;

public abstract class AbstractTraverserQuery
extends AbstractStringQuery
implements ITreeNodeOperation<INodePO> {
    protected AbstractTraverserQuery(SearchOptions searchData, String viewId) {
        super(searchData, viewId);
    }

    protected void traverse() {
        boolean searchInCurrentSelection = this.getSearchOptions().hasNodesToBeSelected();
        if (searchInCurrentSelection) {
            if (this.getSearchOptions().isSearchingInTestSuiteBrowser()) {
                this.traverseStructuredSelection(TreeViewSelectionRetriever.getStructuredSelection(TestSuiteBrowserWrapper.getInstance()));
            }
            if (this.getSearchOptions().isSearchingInTestCaseBrowser()) {
                this.traverseTestCaseBrowsers();
            }
        } else {
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            TreeTraverser tt = new TreeTraverser((INodePO)activeProject, (ITreeNodeOperation)this, true, true);
            tt.traverse(true);
        }
    }

    private void traverseTestCaseBrowsers() {
        ArrayList<TestCaseBrowser> tcbs = new ArrayList();
        MultipleTCBTracker tracker = MultipleTCBTracker.getInstance();
        if (this.getSearchOptions().isSearchinInTestCaseBrowsersAll()) {
            tcbs = tracker.getOpenTCBs();
        } else {
            TestCaseBrowser masterTCB = tracker.getMainTCB();
            if (masterTCB != null) {
                tcbs.add(masterTCB);
            }
        }
        this.traverseTestCaseBrowserList(tcbs);
    }

    private void traverseTestCaseBrowserList(List<TestCaseBrowser> tcbs) {
        for (TestCaseBrowser tcb : tcbs) {
            this.traverseStructuredSelection(TreeViewSelectionRetriever.getStructuredSelection(tcb));
        }
    }

    private void traverseStructuredSelection(IStructuredSelection structuredSelection) {
        if (structuredSelection != null) {
            List selectionList = structuredSelection.toList();
            for (INodePO node : selectionList) {
                this.traverseNodePO(node);
            }
        }
    }

    private void traverseNodePO(INodePO node) {
        TreeTraverser tt = new TreeTraverser(node, (ITreeNodeOperation)this);
        tt.traverse(true);
    }

    protected boolean matchingSearchType(INodePO node) {
        for (TypeName type : this.getSearchOptions().getSelectedSearchableTypes()) {
            if (!type.getType().equals(node.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (alreadyVisited) {
            return false;
        }
        if (this.getSearchOptions().isSearchingInReusedProjects() || parent == null || node.getParentProjectId().equals(this.getSearchOptions().getProject().getId())) {
            IProgressMonitor monitor = this.getMonitor();
            monitor.worked(1);
            return this.operate(node) && !monitor.isCanceled();
        }
        return false;
    }

    public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
    }

    protected abstract boolean operate(INodePO var1);
}

