/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.xpdl.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.eclipse.jwt.transformations.api.TransformationService;
import org.eclipse.jwt.transformations.properties.ExtractPropertiesService;
import org.eclipse.jwt.transformations.xslt.tools.CustomXslFunctions;
import org.eclipse.jwt.transformations.xslt.tools.XSLTProcessor;

public class Jwt2XpdlService
extends TransformationService {
    public static final String XSL_XPDL_RESOURCE_PART1 = "/org/eclipse/jwt/transformations/xpdl/impl/jwt2xpdl-part1.xsl";
    public static final String XSL_XPDL_RESOURCE_PART2 = "/org/eclipse/jwt/transformations/xpdl/impl/jwt2xpdl-part2.xsl";

    public void transform(String inFilePath, String outFilePath) throws IOException, TransformationException {
        String propertiesFile = File.createTempFile("jwt", "properties").getAbsolutePath();
        ExtractPropertiesService propertiesExtractor = new ExtractPropertiesService();
        propertiesExtractor.transform(inFilePath, propertiesFile);
        Map resources = propertiesExtractor.getAttachedResources();
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(propertiesFile)));
        CustomXslFunctions.setContext((Properties)properties, (Map)resources);
        InputStream xslResource1 = ((Object)((Object)this)).getClass().getResourceAsStream(XSL_XPDL_RESOURCE_PART1);
        InputStream xslResource2 = ((Object)((Object)this)).getClass().getResourceAsStream(XSL_XPDL_RESOURCE_PART2);
        new XSLTProcessor().processXSLT(inFilePath, outFilePath, new InputStream[]{xslResource1, xslResource2});
        CustomXslFunctions.setContext(null, null);
    }
}

