/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.pages.externalSheet.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.pages.externalSheet.IWEExternalSheetProvider;
import org.eclipse.jwt.we.misc.extensions.ExtensionsHelper;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WEExternalSheetManager {
    private static final Logger logger = Logger.getLogger(WEExternalSheetManager.class);
    private static WEExternalSheetManager myinstance = null;
    private HashMap<String, IConfigurationElement> externalEditorSheets;

    public static WEExternalSheetManager getInstance() {
        if (myinstance == null) {
            myinstance = new WEExternalSheetManager();
        }
        return myinstance;
    }

    private void loadExternalSheetsIntoMap() {
        String extension_point_id = PluginProperties.extension_point_sheet;
        logger.debug("get sheets from extension point " + extension_point_id);
        try {
            this.externalEditorSheets = new HashMap();
            IConfigurationElement[] confElements = ExtensionsHelper.findConfigurationElements(extension_point_id);
            if (confElements == null) {
                logger.debug("no external sheets found");
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = confElements;
            int n = confElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement point = iConfigurationElementArray[n2];
                String externalSheetTitle = point.getAttribute("title");
                this.externalEditorSheets.put(externalSheetTitle, point);
                logger.info("JWT Extension - found SHEET at " + extension_point_id + ": " + externalSheetTitle);
                ++n2;
            }
        }
        catch (Exception e) {
            logger.warning("error loading external sheets", e);
        }
    }

    public HashMap<String, IConfigurationElement> getExternalSheets() {
        if (this.externalEditorSheets == null) {
            this.loadExternalSheetsIntoMap();
        }
        return this.externalEditorSheets;
    }

    public void displayExternalSheet(WEEditor editor, String sheetTitle) {
        try {
            int pageID;
            IConfigurationElement point = this.getExternalSheets().get(sheetTitle);
            if (point.getAttribute("multiple").equals("false")) {
                int i = 0;
                while (i < editor.getPageCount()) {
                    if (editor.getTabFolder().getItem(i).getText().equals(sheetTitle)) {
                        editor.activatePage(i);
                        return;
                    }
                    ++i;
                }
            }
            IWEExternalSheetProvider externalSheetProvider = (IWEExternalSheetProvider)point.createExecutableExtension("class");
            externalSheetProvider.init(editor);
            Object externalSheet = externalSheetProvider.getExternalSheet();
            externalSheetProvider = null;
            int n = pageID = editor.getActivePage() == -1 ? editor.getPageCount() : editor.getActivePage() + 1;
            if (externalSheet instanceof IEditorPart) {
                editor.addPage(pageID, (IEditorPart)externalSheet, editor.getEditorInput());
            } else if (externalSheet instanceof Control) {
                editor.addPage(pageID, (Control)externalSheet);
            }
            editor.getTabFolder().getItem(pageID).setText(sheetTitle);
            if (point.getAttribute("closable").equals("true")) {
                editor.getTabFolder().getItem(pageID).setShowClose(true);
            }
            editor.activatePage(pageID);
        }
        catch (Exception e) {
            logger.warning("error loading external sheets", e);
            e.printStackTrace();
        }
    }
}

