/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.trace;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.UUID;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandlerEvent;

public class RemoteTraceHandler
implements OMTraceHandler {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 2035;
    private static int uniqueCounter;
    private String agentID;
    private String host;
    private int port;
    private Socket socket;

    public RemoteTraceHandler() throws IOException {
        this(RemoteTraceHandler.uniqueAgentID());
    }

    public RemoteTraceHandler(String agentID) throws IOException {
        this(agentID, DEFAULT_HOST);
    }

    public RemoteTraceHandler(String agentID, String host) throws IOException {
        this(agentID, host, 2035);
    }

    public RemoteTraceHandler(String agentID, String host, int port) throws IOException {
        this.agentID = agentID;
        this.host = host;
        this.port = port;
        this.socket = this.connect();
    }

    public Exception close() {
        try {
            this.socket.close();
            return null;
        }
        catch (IOException ex) {
            OM.LOG.error(ex);
            return ex;
        }
    }

    public void traced(OMTraceHandlerEvent event) {
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            out.writeLong(event.getTimeStamp());
            this.writeUTF(out, this.agentID);
            this.writeUTF(out, event.getTracer().getBundle().getBundleID());
            this.writeUTF(out, event.getTracer().getFullName());
            this.writeUTF(out, event.getContext() == null ? "" : event.getContext().getName());
            this.writeUTF(out, event.getMessage());
            if (event.getThrowable() == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                String message = event.getThrowable().getMessage();
                this.writeUTF(out, message);
                StackTraceElement[] stackTrace = event.getThrowable().getStackTrace();
                int size = stackTrace == null ? 0 : stackTrace.length;
                out.writeInt(size);
                int i = 0;
                while (i < size) {
                    StackTraceElement element = stackTrace[i];
                    this.writeUTF(out, element.getClassName());
                    this.writeUTF(out, element.getMethodName());
                    this.writeUTF(out, element.getFileName());
                    out.writeInt(element.getLineNumber());
                    ++i;
                }
            }
            out.flush();
        }
        catch (IOException ex) {
            IOUtil.print(ex);
        }
    }

    protected Socket connect() throws IOException {
        return new Socket(this.host, this.port);
    }

    protected void writeUTF(DataOutputStream out, String str) throws IOException {
        out.writeUTF(str == null ? "" : str);
    }

    public static String uniqueAgentID() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            return String.valueOf(localMachine.getHostName()) + "#" + ++uniqueCounter;
        }
        catch (Exception ex) {
            UUID uuid = UUID.randomUUID();
            return uuid.toString();
        }
    }
}

