/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.URIUtil;
import org.eclipse.ocl.xtext.base.ui.messages.BaseUIMessages;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class SaveASHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window == null) {
            return null;
        }
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof XtextEditor)) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IXtextDocument document = ((XtextEditor)editor).getDocument();
        URI asURI = null;
        try {
            asURI = (URI)document.readOnly((IUnitOfWork)new IUnitOfWork<URI, XtextResource>(){

                public URI exec(@Nullable XtextResource resource) throws Exception {
                    if (resource instanceof BaseCSResource) {
                        ASResource asResource = ((BaseCSResource)resource).getASResource();
                        return asResource.getURI();
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (asURI == null) {
            return null;
        }
        IFile srcFile = ((IFileEditorInput)editorInput).getFile();
        IProject srcProject = srcFile.getProject();
        URI projectURI = URI.createPlatformResourceURI((String)(String.valueOf(srcProject.getFullPath().toString()) + "/"), (boolean)true);
        URI outURI = URIUtil.deresolve((URI)asURI, (URI)projectURI);
        Path outPath = new Path(outURI.toString());
        IFile outFile = srcProject.getFile((IPath)outPath);
        Shell shell = editor.getEditorSite().getShell();
        SaveAsDialog dlg = new SaveAsDialog(shell);
        dlg.setOriginalFile(outFile);
        dlg.create();
        dlg.getShell().setText(BaseUIMessages.SaveAS_ShellTitle);
        dlg.setTitle(BaseUIMessages.SaveAS_Title);
        dlg.setMessage(NLS.bind((String)BaseUIMessages.SaveAS_Description, (Object)asURI));
        int status = dlg.open();
        if (status != 0) {
            return null;
        }
        IPath file = dlg.getResult();
        if (file == null) {
            return null;
        }
        final URI newURI = URI.createPlatformResourceURI((String)file.toString(), (boolean)true);
        try {
            document.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                public Object exec(@Nullable XtextResource resource) throws Exception {
                    if (resource instanceof BaseCSResource) {
                        ASResource asResource = ((BaseCSResource)resource).getASResource();
                        URI oldURI = asResource.getURI();
                        boolean wasSaveable = asResource.isSaveable();
                        try {
                            asResource.setURI(newURI);
                            asResource.setSaveable(true);
                            asResource.save(null);
                        }
                        finally {
                            asResource.setURI(oldURI);
                            asResource.setSaveable(wasSaveable);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable e) {
            MessageDialog.openError((Shell)shell, (String)BaseUIMessages.SaveError_Title, (String)e.getLocalizedMessage());
        }
        return null;
    }
}

