/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.types.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.operations.CollectionTypeOperations;
import org.eclipse.ocl.util.OCLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceTypeOperations
extends CollectionTypeOperations {
    protected SequenceTypeOperations() {
    }

    public static <C, O> boolean checkCollectionTypeName(SequenceType<C, O> sequenceType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Environment env = OCLUtil.getValidationEnvironment(sequenceType, context);
        if (env != null) {
            String name = sequenceType.getName();
            Object elementType = sequenceType.getElementType();
            if (elementType != null) {
                String elementTypeName = env.getUMLReflection().getName(elementType);
                result = ("Sequence(" + elementTypeName + ")").equals(name);
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.types", 8, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkCollectionTypeName", EObjectValidator.getObjectLabel(sequenceType, context)}), new Object[]{sequenceType}));
        }
        return result;
    }
}

