/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.access;

import java.util.Map;
import java.util.Set;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.SystemReporter;
import org.eclipse.passage.lic.internal.base.permission.BasePermissionObservatory;
import org.eclipse.passage.lic.internal.base.permission.LimitedPermission;
import org.eclipse.passage.lic.internal.base.permission.PermissionObservatory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=org/eclipse/passage/lic/api/AccessEvents/conditionsEvaluated", "observatory.schedule:Integer=600"})
public final class EquinoxPermissionObservatory
implements EventHandler,
PermissionObservatory {
    private BasePermissionObservatory observatory;
    private LicensingReporter eventBus = SystemReporter.INSTANCE;

    @Activate
    public void activate(Map<String, Object> config) {
        int schedule = (Integer)config.get("observatory.schedule");
        this.observatory = new BasePermissionObservatory(schedule, this::fireExpiration);
        this.observatory.open();
    }

    public void handleEvent(Event event) {
        Iterable payload = (Iterable)event.getProperty("org.eclipse.e4.data");
        this.observatory.watch(payload);
    }

    @Reference
    public void bindLicensingReporter(LicensingReporter reporter) {
        this.eventBus = reporter;
    }

    public void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.eventBus == reporter) {
            this.eventBus = SystemReporter.INSTANCE;
        }
    }

    private void fireExpiration(Set<LimitedPermission> expired) {
        this.eventBus.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/api/AccessEvents/permissionsExpired", expired));
    }
}

