/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

class DynamicIntArray {
    final double RESIZEFAC = 1.1;
    final int RESIZEADD = 10;
    private int[] v = null;
    private int length = 0;

    DynamicIntArray(int reserveSize) {
        this.ensureSize(reserveSize);
    }

    DynamicIntArray() {
    }

    int length() {
        return this.length;
    }

    int get(int pos) {
        if (pos < 0 || pos >= this.length) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        return this.v[pos];
    }

    void pushBack(int value) {
        this.ensureSize(this.length + 1);
        this.v[this.length] = value;
        ++this.length;
    }

    private void ensureSize(int size) {
        if (this.v == null || this.v.length < size) {
            int[] newArray = new int[(int)((double)size * 1.1 + 10.0)];
            if (this.v != null) {
                System.arraycopy(this.v, 0, newArray, 0, this.length);
            }
            this.v = newArray;
        }
    }
}

