/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.photran.internal.ui.actions.FortranEditorActionDelegate;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class FortranBlockCommentActionDelegate
extends FortranEditorActionDelegate {
    public FortranBlockCommentActionDelegate() {
    }

    public FortranBlockCommentActionDelegate(FortranEditor ed) {
        super(ed);
    }

    public void run(IProgressMonitor progressMonitor) {
        FortranEditor editor = this.getFortranEditor();
        ITextSelection selection = editor.getSelection();
        IDocument document = editor.getIDocument();
        if (document == null) {
            return;
        }
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
        Edit.EditFactory factory = new Edit.EditFactory(document);
        try {
            try {
                this.runInternal(selection, factory);
            }
            catch (BadLocationException badLocationException) {
                factory.release();
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        finally {
            factory.release();
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    protected void executeEdits(List<Edit> edits) throws BadLocationException {
        for (Edit edit : edits) {
            edit.perform();
        }
    }

    protected void runInternal(ITextSelection selection, Edit.EditFactory factory) throws BadLocationException {
        int selectionLineStart = selection.getStartLine();
        int selectionLineEnd = selection.getEndLine();
        LinkedList<Edit> edits = new LinkedList<Edit>();
        IDocumentProvider dp = this.getFortranEditor().getDocumentProvider();
        IDocument doc = dp.getDocument((Object)this.getFortranEditor().getEditorInput());
        boolean addComment = doc.getChar(doc.getLineOffset(selectionLineStart)) != '!';
        int newLength = selection.getLength() + (addComment ? 1 : -1) * (selectionLineEnd - selectionLineStart);
        if (selection.getOffset() == doc.getLineOffset(selectionLineStart)) {
            newLength += addComment ? 1 : -1;
        }
        int newOffset = selection.getOffset();
        if (doc.getLineOffset(selectionLineStart) < selection.getOffset()) {
            newOffset += addComment ? 1 : -1;
        }
        int i = selectionLineStart;
        while (i <= selectionLineEnd) {
            int eff = doc.getLineOffset(i);
            if (addComment) {
                edits.add(factory.createEdit(eff, 0, "!"));
            } else {
                edits.add(factory.createEdit(eff, 1, ""));
            }
            ++i;
        }
        this.executeEdits(edits);
        this.getFortranEditor().selectAndReveal(newOffset, newLength);
    }

    static class Edit
    extends DocumentEvent {
        private Position fPosition;

        protected Edit(IDocument document, int length, String text, Position position) {
            super(document, 0, length, text);
            this.fPosition = position;
        }

        public int getOffset() {
            return this.fPosition.getOffset();
        }

        public void perform() throws BadLocationException {
            this.getDocument().replace(this.getOffset(), this.getLength(), this.getText());
        }

        public static class EditFactory {
            private static final String CATEGORY = "__positionalEditPositionCategory";
            private static int fgCount = 0;
            private final String fCategory = "__positionalEditPositionCategory" + fgCount++;
            private IDocument fDocument;
            private IPositionUpdater fUpdater;

            public EditFactory(IDocument document) {
                this.fDocument = document;
            }

            public Edit createEdit(int offset, int length, String text) throws BadLocationException {
                if (!this.fDocument.containsPositionCategory(this.fCategory)) {
                    this.fDocument.addPositionCategory(this.fCategory);
                    this.fUpdater = new DefaultPositionUpdater(this.fCategory);
                    this.fDocument.addPositionUpdater(this.fUpdater);
                }
                Position position = new Position(offset);
                try {
                    this.fDocument.addPosition(this.fCategory, position);
                }
                catch (BadPositionCategoryException e) {
                    System.err.println("BadPosition within Create edit");
                    Assert.isTrue((boolean)false);
                }
                return new Edit(this.fDocument, length, text, position);
            }

            public void release() {
                if (this.fDocument != null && this.fDocument.containsPositionCategory(this.fCategory)) {
                    this.fDocument.removePositionUpdater(this.fUpdater);
                    try {
                        this.fDocument.removePositionCategory(this.fCategory);
                    }
                    catch (BadPositionCategoryException e) {
                        Assert.isTrue((boolean)false);
                    }
                    this.fDocument = null;
                    this.fUpdater = null;
                }
            }
        }
    }
}

