/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContainmentAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.InheritanceAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class DatumCaches {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Property oclContainerProperty;
    protected final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    protected final @NonNull ContainmentAnalysis containmentAnalysis;
    protected final @NonNull CompleteModel completeModel;
    private @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull CompleteClass, @NonNull ClassDatum>> typedModel2completeClass2classDatum = new HashMap<TypedModel, Map<CompleteClass, ClassDatum>>();
    private @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Set<@NonNull CompleteClass>, @NonNull ClassDatum>> typedModel2completeClasses2classDatum = new HashMap<TypedModel, Map<Set<CompleteClass>, ClassDatum>>();
    private @NonNull Map<@NonNull ClassDatum, @NonNull Map<@NonNull Property, @NonNull PropertyDatum>> classDatum2property2propertyDatum = new HashMap<ClassDatum, Map<Property, PropertyDatum>>();
    private @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull PropertyDatum>> classDatum2oclContainerPropertyDatums = new HashMap<ClassDatum, List<PropertyDatum>>();

    protected DatumCaches(@NonNull ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
        this.oclContainerProperty = scheduleManager.getStandardLibraryHelper().getOclContainerProperty();
        this.domainUsageAnalysis = scheduleManager.getDomainUsageAnalysis();
        EnvironmentFactory environmentFactory = scheduleManager.getEnvironmentFactory();
        this.containmentAnalysis = new ContainmentAnalysis(environmentFactory);
        this.completeModel = environmentFactory.getCompleteModel();
    }

    private @NonNull Set<@NonNull PropertyDatum> analyseOclContainerCall(@NonNull TypedModel typedModel, @NonNull CompleteClass context) {
        InheritanceAnalysis inheritanceAnalysis = this.containmentAnalysis.getInheritanceAnalysis();
        HashSet<@NonNull PropertyDatum> result = new HashSet<PropertyDatum>();
        for (CompleteClass parentClass : this.containmentAnalysis.getContainerClasses(context)) {
            for (Property prop : parentClass.getProperties(FeatureFilter.SELECT_NON_STATIC)) {
                CompleteClass elementClass;
                Set<CompleteClass> allSuperAndSubClasses;
                if (!prop.isIsComposite() || !(allSuperAndSubClasses = inheritanceAnalysis.getAllSuperAndSelfAndSubClasses(context)).contains(elementClass = this.getElementClass((TypedElement)prop))) continue;
                result.add(this.getPropertyDatum(typedModel, parentClass, prop));
            }
        }
        return result;
    }

    public void analyzeCompletePackage(@NonNull TypedModel typedModel, @NonNull CompletePackage completePackage) {
        for (CompleteClass completeClass : PivotUtil.getOwnedCompleteClasses((CompletePackage)completePackage)) {
            Class asClass = completeClass.getPrimaryClass();
            TypedModel containingTypedModel = asClass instanceof DataType ? this.domainUsageAnalysis.getPrimitiveTypedModel() : typedModel;
            ClassDatum classDatum = this.getClassDatum(containingTypedModel, asClass);
            for (Property property : PivotUtil.getOwnedProperties((Class)asClass)) {
                if (property == this.oclContainerProperty) continue;
                PropertyDatum propertyDatum = this.getPropertyDatum(classDatum, property);
            }
        }
    }

    private boolean assertValidTypedModel(@NonNull TypedModel typedModel, @NonNull CompleteClass completeClass) {
        @NonNull Class aType = completeClass.getPrimaryClass();
        Type elementType = QVTbaseUtil.getElementalType((Type)aType);
        if (!(elementType instanceof DataType)) assert (typedModel != null);
        return true;
    }

    private @NonNull Set<@NonNull CompleteClass> computeContexts(@NonNull OCLExpression oclExp, @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext) {
        HashSet<@NonNull CompleteClass> result = new HashSet<CompleteClass>();
        if (oclExp instanceof VariableExp) {
            VariableExp varExp = (VariableExp)oclExp;
            Set<@NonNull CompleteClass> context = variable2BoundContext.get(varExp.getReferredVariable());
            if (context != null) {
                result.addAll(context);
            } else {
                result.add(this.completeModel.getCompleteClass(QVTbaseUtil.getType((TypedElement)varExp)));
            }
        } else if (oclExp instanceof CallExp) {
            CallExp callExp = (CallExp)oclExp;
            if (callExp instanceof OperationCallExp && this.isOclContainerOp(QVTbaseUtil.getReferredOperation((CallExp)callExp))) {
                OCLExpression ownedSource = QVTbaseUtil.getOwnedSource((CallExp)callExp);
                for (CompleteClass oclContainerOpContext : this.computeContexts(ownedSource, variable2BoundContext)) {
                    Iterables.addAll(result, this.containmentAnalysis.getContainerClasses(oclContainerOpContext));
                }
            } else {
                result.add(this.completeModel.getCompleteClass(QVTbaseUtil.getType((TypedElement)callExp)));
            }
        } else if (oclExp instanceof ShadowExp) {
            result.add(this.completeModel.getCompleteClass(QVTbaseUtil.getType((TypedElement)oclExp)));
        } else {
            throw new IllegalStateException("OCLExpression has not been considered yet");
        }
        return result;
    }

    public @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatums(@NonNull ClassDatum classDatum) {
        return this.getAllPropertyDatumsInternal(new HashSet<ClassDatum>(), new HashSet<PropertyDatum>(), classDatum);
    }

    private @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatumsInternal(@NonNull Set<@NonNull ClassDatum> classDatums, @NonNull Set<@NonNull PropertyDatum> propertyDatums, @NonNull ClassDatum cDatum) {
        if (classDatums.add(cDatum)) {
            Iterables.addAll(propertyDatums, (Iterable)QVTscheduleUtil.getOwnedPropertyDatums((ClassDatum)cDatum));
        }
        for (ClassDatum superClassDatum : this.scheduleManager.getSuperClassDatums(cDatum)) {
            if (superClassDatum == cDatum) continue;
            this.getAllPropertyDatumsInternal(classDatums, propertyDatums, superClassDatum);
        }
        return propertyDatums;
    }

    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull Class asClass) {
        CompleteClass completeClass = this.completeModel.getCompleteClass((Type)asClass);
        return this.getClassDatum(typedModel, completeClass);
    }

    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull CompleteClass completeClass) {
        ClassDatum classDatum;
        assert (this.assertValidTypedModel(typedModel, completeClass));
        Map<@NonNull CompleteClass, @NonNull ClassDatum> completeClass2classDatums = this.typedModel2completeClass2classDatum.get(typedModel);
        if (completeClass2classDatums == null) {
            completeClass2classDatums = new HashMap<CompleteClass, ClassDatum>();
            this.typedModel2completeClass2classDatum.put(typedModel, completeClass2classDatums);
        }
        if ((classDatum = completeClass2classDatums.get(completeClass)) == null) {
            @NonNull Class primaryClass = completeClass.getPrimaryClass();
            if (primaryClass instanceof CollectionType) {
                Type elementType = PivotUtil.getElementType((CollectionType)((CollectionType)primaryClass));
                @NonNull Class primaryElementClass = PivotUtil.getClass((Type)elementType, (StandardLibrary)this.scheduleManager.getStandardLibrary());
                CompleteClass completeElementClass = this.scheduleManager.getEnvironmentFactory().getCompleteModel().getCompleteClass((Type)primaryElementClass);
                ClassDatum elementClassDatum = this.getClassDatum(typedModel, completeElementClass);
                CollectionClassDatum collectionClassDatum = QVTscheduleFactory.eINSTANCE.createCollectionClassDatum();
                collectionClassDatum.setElementalClassDatum(elementClassDatum);
                classDatum = collectionClassDatum;
            } else {
                classDatum = QVTscheduleFactory.eINSTANCE.createClassDatum();
            }
            classDatum.setOwningScheduleModel(this.scheduleManager.getScheduleModel());
            classDatum.getCompleteClasses().add(completeClass);
            classDatum.setReferredClass(primaryClass);
            classDatum.setName(primaryClass.getName());
            classDatum.setReferredTypedModel(typedModel);
            boolean cfr_ignored_0 = primaryClass instanceof DataType;
            completeClass2classDatums.put(completeClass, classDatum);
        }
        return classDatum;
    }

    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull Set<@NonNull CompleteClass> completeClasses) {
        ClassDatum classDatum;
        assert (completeClasses.size() >= 2);
        for (CompleteClass completeClass : completeClasses) {
            assert (this.assertValidTypedModel(typedModel, completeClass));
        }
        Map<@NonNull Set<@NonNull CompleteClass>, @NonNull ClassDatum> completeClasses2classDatums = this.typedModel2completeClasses2classDatum.get(typedModel);
        if (completeClasses2classDatums == null) {
            completeClasses2classDatums = new HashMap<Set<CompleteClass>, ClassDatum>();
            this.typedModel2completeClasses2classDatum.put(typedModel, completeClasses2classDatums);
        }
        if ((classDatum = completeClasses2classDatums.get(completeClasses)) == null) {
            @NonNull Class primaryClass = completeClasses.iterator().next().getPrimaryClass();
            if (primaryClass instanceof CollectionType) {
                Type elementType = PivotUtil.getElementType((CollectionType)((CollectionType)primaryClass));
                @NonNull Class primaryElementClass = PivotUtil.getClass((Type)elementType, (StandardLibrary)this.scheduleManager.getStandardLibrary());
                CompleteClass completeElementClass = this.scheduleManager.getEnvironmentFactory().getCompleteModel().getCompleteClass((Type)primaryElementClass);
                ClassDatum elementClassDatum = this.getClassDatum(typedModel, completeElementClass);
                CollectionClassDatum collectionClassDatum = QVTscheduleFactory.eINSTANCE.createCollectionClassDatum();
                collectionClassDatum.setElementalClassDatum(elementClassDatum);
                classDatum = collectionClassDatum;
            } else {
                classDatum = QVTscheduleFactory.eINSTANCE.createClassDatum();
            }
            classDatum.setOwningScheduleModel(this.scheduleManager.getScheduleModel());
            classDatum.getCompleteClasses().addAll(completeClasses);
            classDatum.setReferredClass(primaryClass);
            classDatum.setName(primaryClass.getName());
            classDatum.setReferredTypedModel(typedModel);
            boolean cfr_ignored_0 = primaryClass instanceof DataType;
            completeClasses2classDatums.put(completeClasses, classDatum);
        }
        return classDatum;
    }

    private @NonNull Set<@NonNull CompleteClass> getComputedContexts(@NonNull CallExp callExp, @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext) {
        OCLExpression source = QVTbaseUtil.getOwnedSource((CallExp)callExp);
        return this.computeContexts(source, variable2BoundContext);
    }

    public @NonNull ContainmentAnalysis getContainmentAnalysis() {
        return this.containmentAnalysis;
    }

    protected @NonNull CompleteClass getElementClass(@NonNull TypedElement typedElement) {
        Type type = QVTbaseUtil.getElementalType((Type)QVTbaseUtil.getType((TypedElement)typedElement));
        return this.completeModel.getCompleteClass(type);
    }

    public @NonNull Iterable<@NonNull PropertyDatum> getOclContainerPropertyDatums(@NonNull ClassDatum containedClassDatum) {
        List<@NonNull PropertyDatum> oclContainerPropertyDatums = this.classDatum2oclContainerPropertyDatums.get(containedClassDatum);
        if (oclContainerPropertyDatums == null) {
            oclContainerPropertyDatums = new ArrayList<PropertyDatum>();
            this.classDatum2oclContainerPropertyDatums.put(containedClassDatum, oclContainerPropertyDatums);
            for (CompleteClass containedCompleteClass : QVTscheduleUtil.getCompleteClasses((ClassDatum)containedClassDatum)) {
                Iterable<@NonNull Property> containmentProperties = this.containmentAnalysis.getContainmentProperties(containedCompleteClass);
                for (Property containmentProperty : containmentProperties) {
                    ClassDatum containingClassDatum = this.getClassDatum(QVTscheduleUtil.getReferredTypedModel((ClassDatum)containedClassDatum), PivotUtil.getOwningClass((Property)containmentProperty));
                    oclContainerPropertyDatums.add(this.getPropertyDatum(containingClassDatum, containmentProperty));
                }
            }
        }
        return oclContainerPropertyDatums;
    }

    protected @NonNull Set<@NonNull PropertyDatum> getOperationPropertyDatums(@NonNull OperationCallExp opCall, @NonNull CompleteClass context, @NonNull Map<@NonNull CompleteClass, @NonNull Set<@NonNull Operation>> type2VisitedOps, @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext) {
        Set<@NonNull Operation> visitedOps = type2VisitedOps.get(context);
        if (visitedOps == null) {
            visitedOps = new HashSet<Operation>();
            type2VisitedOps.put(context, visitedOps);
        }
        HashSet<@NonNull PropertyDatum> result = new HashSet<PropertyDatum>();
        Operation op = QVTbaseUtil.getReferredOperation((CallExp)opCall);
        if (!visitedOps.contains(op)) {
            visitedOps.add(op);
            if (this.isOclContainerOp(op)) {
                for (TypedModel typedModel : this.getTypedModels((Element)context.getPrimaryClass())) {
                    for (CompleteClass newContext : this.getComputedContexts((CallExp)opCall, variable2BoundContext)) {
                        result.addAll(this.analyseOclContainerCall(typedModel, newContext));
                    }
                }
            } else {
                result.addAll(this.getOperationPropertyDatums(op, context, type2VisitedOps));
            }
        }
        return result;
    }

    private @NonNull Set<@NonNull PropertyDatum> getOperationPropertyDatums(@NonNull Operation operation, @NonNull CompleteClass context, @NonNull Map<@NonNull CompleteClass, @NonNull Set<@NonNull Operation>> type2VisitedOps) {
        ExpressionInOCL expInOCL;
        HashSet<@NonNull PropertyDatum> result = new HashSet<PropertyDatum>();
        LanguageExpression langExp = operation.getBodyExpression();
        if (langExp instanceof ExpressionInOCL && (expInOCL = (ExpressionInOCL)langExp).getOwnedBody() != null) {
            HashMap<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext = new HashMap<Variable, Set<CompleteClass>>();
            HashSet<@NonNull CompleteClass> boundContexts = new HashSet<CompleteClass>();
            boundContexts.add(context);
            Variable ownedContext = expInOCL.getOwnedContext();
            if (ownedContext != null) {
                variable2BoundContext.put(ownedContext, boundContexts);
            }
            for (EObject eObject : new TreeIterable((EObject)expInOCL, true)) {
                if (eObject instanceof LetExp) {
                    this.updateVariableBindings((LetExp)eObject, variable2BoundContext);
                    continue;
                }
                if (eObject instanceof NavigationCallExp) {
                    NavigationCallExp navCallExp = (NavigationCallExp)eObject;
                    Property property = QVTbaseUtil.getReferredProperty((NavigationCallExp)navCallExp);
                    OCLExpression ownedSource = QVTbaseUtil.getOwnedSource((CallExp)navCallExp);
                    TypedModel typedModel = this.getTypedModel((Element)ownedSource);
                    for (CompleteClass newContext : this.getComputedContexts((CallExp)navCallExp, variable2BoundContext)) {
                        PropertyDatum propertyDatum = this.getPropertyDatum(typedModel, newContext, property);
                        result.add(propertyDatum);
                    }
                    continue;
                }
                if (!(eObject instanceof OperationCallExp)) continue;
                OperationCallExp opCallExp = (OperationCallExp)eObject;
                for (CompleteClass newContext : this.getComputedContexts((CallExp)opCallExp, variable2BoundContext)) {
                    result.addAll(this.getOperationPropertyDatums(opCallExp, newContext, type2VisitedOps, variable2BoundContext));
                }
            }
        }
        return result;
    }

    protected @NonNull PropertyDatum getPropertyDatum(@NonNull TypedModel typedModel, @NonNull Class context, @NonNull Property property) {
        CompleteClass completeClass = this.completeModel.getCompleteClass((Type)context);
        return this.getPropertyDatum(typedModel, completeClass, property);
    }

    protected @NonNull PropertyDatum getPropertyDatum(@NonNull TypedModel typedModel, @NonNull CompleteClass completeClass, @NonNull Property property) {
        ClassDatum classDatum = this.getClassDatum(typedModel, completeClass);
        return this.getPropertyDatum(classDatum, property);
    }

    public @NonNull PropertyDatum getPropertyDatum(@NonNull ClassDatum classDatum, @NonNull Property property) {
        ClassDatum oppositeClassDatum;
        Map<Property, PropertyDatum> oppositeProperty2propertyDatum;
        PropertyDatum oppositePropertyDatum;
        assert (property != this.oclContainerProperty);
        Map<@NonNull Property, @NonNull PropertyDatum> property2propertyDatum = this.getProperty2propertyDatum(classDatum);
        PropertyDatum cachedPropertyDatum = property2propertyDatum.get(property);
        if (cachedPropertyDatum != null) {
            return cachedPropertyDatum;
        }
        PropertyDatum propertyDatum = QVTscheduleFactory.eINSTANCE.createPropertyDatum();
        propertyDatum.setReferredProperty(property);
        propertyDatum.setName(property.getName());
        propertyDatum.setOwningClassDatum(classDatum);
        PropertyDatum oldPropertyDatum = property2propertyDatum.put(property, propertyDatum);
        assert (oldPropertyDatum == null);
        Property oppositeProperty = property.getOpposite();
        if (oppositeProperty != null && (oppositePropertyDatum = (oppositeProperty2propertyDatum = this.getProperty2propertyDatum(oppositeClassDatum = this.getClassDatum(QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum), PivotUtil.getOwningClass((Property)oppositeProperty)))).get(oppositeProperty)) != null) {
            propertyDatum.setOpposite(oppositePropertyDatum);
            oppositePropertyDatum.setOpposite(propertyDatum);
        }
        return propertyDatum;
    }

    private @NonNull Map<@NonNull Property, @NonNull PropertyDatum> getProperty2propertyDatum(@NonNull ClassDatum classDatum) {
        Map<@NonNull Property, @NonNull PropertyDatum> property2propertyDatum = this.classDatum2property2propertyDatum.get(classDatum);
        if (property2propertyDatum == null) {
            property2propertyDatum = new HashMap<Property, PropertyDatum>();
            this.classDatum2property2propertyDatum.put(classDatum, property2propertyDatum);
        }
        return property2propertyDatum;
    }

    public @NonNull PropertyDatum getSuccessPropertyDatum(@NonNull Property successProperty) {
        Class owningClass = QVTbaseUtil.getOwningClass((Property)successProperty);
        TypedModel typedModel = this.getTypedModel((Element)owningClass);
        return this.getPropertyDatum(typedModel, owningClass, successProperty);
    }

    protected @NonNull TypedModel getTypedModel(@NonNull Element element) {
        DomainUsage domainUsage = this.getUsage(element);
        if (domainUsage == null) {
            this.getUsage(element);
            throw new IllegalStateException("No DomainUsage for " + element);
        }
        Iterator<TypedModel> typedModels = this.getTypedModels(element).iterator();
        if (!typedModels.hasNext()) {
            throw new IllegalStateException("No TypedModel for " + element);
        }
        @NonNull TypedModel typedModel = typedModels.next();
        if (typedModels.hasNext()) {
            this.getUsage(element);
            throw new IllegalStateException("Ambiguous TypedModel: " + domainUsage + " for " + element);
        }
        return typedModel;
    }

    private @NonNull Iterable<@NonNull TypedModel> getTypedModels(@NonNull Element element) {
        DomainUsage domainUsage = this.getUsage(element);
        if (domainUsage == null) {
            this.getUsage(element);
            throw new IllegalStateException("No DomainUsage for " + element);
        }
        return domainUsage.getTypedModels();
    }

    protected @Nullable DomainUsage getUsage(@NonNull Element element) {
        Operation operation = QVTbaseUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            DomainUsageAnalysis analysis = this.domainUsageAnalysis.getAnalysis(operation);
            return analysis.getUsage(element);
        }
        return this.domainUsageAnalysis.getUsage(element);
    }

    private boolean isOclContainerOp(@NonNull Operation operation) {
        return operation.getOperationId() == this.domainUsageAnalysis.getOclContainerId();
    }

    private void updateVariableBindings(@NonNull LetExp letExp, @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext) {
        Variable variable = QVTbaseUtil.getOwnedVariable((LetExp)letExp);
        variable2BoundContext.put(variable, this.computeContexts(QVTbaseUtil.getOwnedInit((Variable)variable), variable2BoundContext));
    }
}

