/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.internal.dto;

import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.MissingTypeException;
import org.eclipse.scout.sdk.core.s.annotation.DataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.util.DtoUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.operation.CompilationUnitWriteOperation;
import org.eclipse.scout.sdk.s2e.trigger.AbstractDerivedResourceSingleHandler;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class DtoDerivedResourceHandler
extends AbstractDerivedResourceSingleHandler {
    public DtoDerivedResourceHandler(IType jdtType, IJavaEnvironmentProvider envProvider) {
        super(jdtType, envProvider);
    }

    @Override
    public String getName() {
        return "Update DTO for '" + this.getModelFullyQualifiedName() + "'.";
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(this.getName(), 1);
        try {
            CompilationUnitWriteOperation op = DtoDerivedResourceHandler.newDtoOp(this.getJdtType(), this.getModelType(), this.getJavaEnvironmentProvider());
            if (op == null) {
                return;
            }
            try {
                S2eUtils.writeFiles(Collections.singletonList(op), monitor, false);
            }
            catch (MissingTypeException e) {
                SdkLog.info((String)"Unable to update DTO for '{}' because there are compile errors in the compilation unit.", (Object[])new Object[]{this.getModelFullyQualifiedName(), e});
            }
        }
        finally {
            monitor.done();
        }
    }

    public static CompilationUnitWriteOperation newDtoOp(IType jdtType) throws CoreException {
        CachingJavaEnvironmentProvider envProvider = new CachingJavaEnvironmentProvider();
        return DtoDerivedResourceHandler.newDtoOp(jdtType, envProvider.jdtTypeToScoutType(jdtType), envProvider);
    }

    public static CompilationUnitWriteOperation newDtoOp(IType jdtType, org.eclipse.scout.sdk.core.model.api.IType modelType, IJavaEnvironmentProvider envProvider) throws CoreException {
        FormDataAnnotationDescriptor a1 = DtoDerivedResourceHandler.findDataAnnotationForFormData(modelType);
        if (a1 != null) {
            IType derivedJdtType = DtoDerivedResourceHandler.getDerivedJdtType(modelType, a1.getFormDataType(), jdtType);
            if (derivedJdtType == null) {
                return null;
            }
            IJavaProject derivedProject = derivedJdtType.getJavaProject();
            IJavaEnvironment sharedEnv = envProvider.get(derivedProject);
            ICompilationUnitSourceBuilder cuSrc = DtoUtils.createFormDataBuilder((org.eclipse.scout.sdk.core.model.api.IType)modelType, (FormDataAnnotationDescriptor)a1, (IJavaEnvironment)sharedEnv);
            String newSource = S2eUtils.createJavaCode((ISourceBuilder)cuSrc, derivedProject, sharedEnv);
            return new CompilationUnitWriteOperation(derivedJdtType, newSource);
        }
        DataAnnotationDescriptor a2 = DtoDerivedResourceHandler.findDataAnnotationForPageData(modelType);
        if (a2 != null) {
            IType derivedJdtType = DtoDerivedResourceHandler.getDerivedJdtType(modelType, a2.getDataType(), jdtType);
            if (derivedJdtType == null) {
                return null;
            }
            IJavaProject derivedProject = derivedJdtType.getJavaProject();
            IJavaEnvironment sharedEnv = envProvider.get(derivedProject);
            ICompilationUnitSourceBuilder cuSrc = DtoUtils.createPageDataBuilder((org.eclipse.scout.sdk.core.model.api.IType)modelType, (DataAnnotationDescriptor)a2, (IJavaEnvironment)sharedEnv);
            String newSource = S2eUtils.createJavaCode((ISourceBuilder)cuSrc, derivedProject, sharedEnv);
            return new CompilationUnitWriteOperation(derivedJdtType, newSource);
        }
        DataAnnotationDescriptor a3 = DtoDerivedResourceHandler.findDataAnnotationForRowData(modelType);
        if (a3 != null) {
            IType derivedJdtType = DtoDerivedResourceHandler.getDerivedJdtType(modelType, a3.getDataType(), jdtType);
            if (derivedJdtType == null) {
                return null;
            }
            IJavaProject derivedProject = derivedJdtType.getJavaProject();
            IJavaEnvironment sharedEnv = envProvider.get(derivedJdtType.getJavaProject());
            ICompilationUnitSourceBuilder cuSrc = DtoUtils.createTableRowDataBuilder((org.eclipse.scout.sdk.core.model.api.IType)modelType, (DataAnnotationDescriptor)a3, (IJavaEnvironment)sharedEnv);
            String newSource = S2eUtils.createJavaCode((ISourceBuilder)cuSrc, derivedProject, sharedEnv);
            return new CompilationUnitWriteOperation(derivedJdtType, newSource);
        }
        return null;
    }

    private static IType getDerivedJdtType(org.eclipse.scout.sdk.core.model.api.IType modelType, org.eclipse.scout.sdk.core.model.api.IType derivedType, IType modelJdtType) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)modelJdtType) || !S2eUtils.exists((IJavaElement)modelJdtType.getJavaProject())) {
            SdkLog.info((String)"Model jdt type '{}' does not exist.", (Object[])new Object[]{modelType.name(), new Exception()});
            return null;
        }
        String message = "Wrong derived resource annotation value.";
        if (modelType.equals(derivedType)) {
            SdkLog.error((String)"Model type declares itself as derived target. DTO generation not possible.", (Object[])new Object[]{new Exception(message)});
            return null;
        }
        IType derivedJdtType = modelJdtType.getJavaProject().findType(derivedType.name().replace('$', '.'));
        if (derivedJdtType == null) {
            SdkLog.error((String)"Derived resource type '{}' not found.", (Object[])new Object[]{derivedType.name(), new Exception(message)});
            return null;
        }
        if (derivedJdtType.isBinary()) {
            SdkLog.error((String)"Derived resource type '{}' is binary.", (Object[])new Object[]{derivedJdtType.getFullyQualifiedName(), new Exception(message)});
            return null;
        }
        return derivedJdtType;
    }

    private static FormDataAnnotationDescriptor findDataAnnotationForFormData(org.eclipse.scout.sdk.core.model.api.IType modelType) {
        FormDataAnnotationDescriptor formDataAnnotation = DtoUtils.getFormDataAnnotationDescriptor((org.eclipse.scout.sdk.core.model.api.IType)modelType);
        if (FormDataAnnotationDescriptor.isCreate((FormDataAnnotationDescriptor)formDataAnnotation) && formDataAnnotation.getFormDataType() != null) {
            return formDataAnnotation;
        }
        return null;
    }

    private static DataAnnotationDescriptor findDataAnnotationForPageData(org.eclipse.scout.sdk.core.model.api.IType model) {
        if (model.isInstanceOf("org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable")) {
            return DtoUtils.getDataAnnotationDescriptor((org.eclipse.scout.sdk.core.model.api.IType)model);
        }
        return null;
    }

    private static DataAnnotationDescriptor findDataAnnotationForRowData(org.eclipse.scout.sdk.core.model.api.IType model) {
        org.eclipse.scout.sdk.core.model.api.IType innerTableExtension;
        if (model.isInstanceOf("org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn") || model.isInstanceOf("org.eclipse.scout.rt.client.extension.ui.basic.table.ITableExtension")) {
            return DtoUtils.getDataAnnotationDescriptor((org.eclipse.scout.sdk.core.model.api.IType)model);
        }
        if (model.isInstanceOf("org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.IPageWithTableExtension") && (innerTableExtension = model.innerTypes().withInstanceOf("org.eclipse.scout.rt.client.extension.ui.basic.table.ITableExtension").first()) != null) {
            return DtoUtils.getDataAnnotationDescriptor((org.eclipse.scout.sdk.core.model.api.IType)model);
        }
        return null;
    }
}

