/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.lookupcall;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.s.sourcebuilder.lookupcall.LookupCallSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.testcase.TestSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;

public class LookupCallNewOperation
implements IOperation {
    private final IJavaEnvironmentProvider m_javaEnvironmentProvider;
    private String m_lookupCallName;
    private IPackageFragmentRoot m_sharedSourceFolder;
    private IPackageFragmentRoot m_serverSourceFolder;
    private IPackageFragmentRoot m_testSourceFolder;
    private String m_package;
    private IType m_superType;
    private IType m_keyType;
    private IType m_lookupServiceSuperType;
    private IType m_createdLookupCall;
    private IType m_createdLookupServiceIfc;
    private IType m_createdLookupServiceImpl;
    private IType m_createdLookupCallTest;

    public LookupCallNewOperation() {
        this(new CachingJavaEnvironmentProvider());
    }

    protected LookupCallNewOperation(IJavaEnvironmentProvider provider) {
        this.m_javaEnvironmentProvider = (IJavaEnvironmentProvider)Validate.notNull((Object)provider);
    }

    @Override
    public String getOperationName() {
        return "Create LookupCall '" + this.getLookupCallName() + "'.";
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getLookupCallName()), (String)"No lookup call name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSharedSourceFolder()), (String)"No shared source folder provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getKeyType()), (String)"No key type provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPackage()), (String)"No package name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSuperType()), (String)"No supertype provided", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        String suffix;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)4);
        String svcName = this.getLookupCallName();
        if (svcName.endsWith(suffix = "Call")) {
            svcName = svcName.substring(0, svcName.length() - suffix.length());
        }
        svcName = String.valueOf(svcName) + "Service";
        this.setCreatedLookupServiceIfc(this.createLookupServiceIfc(svcName, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        if (S2eUtils.exists((IJavaElement)this.getServerSourceFolder()) && S2eUtils.exists((IJavaElement)this.getLookupServiceSuperType())) {
            String serverPackage = ScoutTier.Shared.convert(ScoutTier.Server, this.getPackage());
            this.setCreatedLookupServiceImpl(this.createLookupServiceImpl(svcName, serverPackage, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        }
        progress.setWorkRemaining(1);
        this.setCreatedLookupCall(this.createLookupCall((IProgressMonitor)progress.newChild(1), workingCopyManager));
        this.setCreatedLookupCallTest(this.createLookupCallTest((IProgressMonitor)progress.newChild(1), workingCopyManager));
    }

    protected IType createLookupCallTest(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IType session;
        IPackageFragmentRoot testSourceFolder = this.getTestSourceFolder();
        if (!S2eUtils.exists((IJavaElement)testSourceFolder)) {
            return null;
        }
        IJavaEnvironment env = this.getEnvProvider().get(testSourceFolder.getJavaProject());
        ScoutTier targetTier = ScoutTier.valueOf((IJavaElement)testSourceFolder);
        String testPackage = ScoutTier.Shared.convert(targetTier, this.getPackage());
        boolean isClient = ScoutTier.Client.isIncludedIn(targetTier);
        String runnerFqn = null;
        runnerFqn = isClient ? "org.eclipse.scout.rt.testing.client.runner.ClientTestRunner" : "org.eclipse.scout.rt.testing.server.runner.ServerTestRunner";
        if (env.findType(runnerFqn) == null) {
            SdkLog.warning((String)"Cannot generate a LookupCall test class because the class '{}' is not on the classpath of project '{}'. Consider adding the required dependency.", (Object[])new Object[]{runnerFqn, testSourceFolder.getJavaProject().getElementName()});
            return null;
        }
        TestSourceBuilder lookupCallTestBuilder = new TestSourceBuilder(String.valueOf(this.getLookupCallName()) + "Test", testPackage, env);
        lookupCallTestBuilder.setClientTest(isClient);
        lookupCallTestBuilder.setRunnerSignature(Signature.createTypeSignature((String)runnerFqn));
        if (!isClient && S2eUtils.exists((IJavaElement)(session = S2eUtils.getSession(testSourceFolder.getJavaProject(), ScoutTier.Server, monitor)))) {
            lookupCallTestBuilder.setSessionSignature(Signature.createTypeSignature((String)session.getFullyQualifiedName()));
        }
        lookupCallTestBuilder.setup();
        ITypeSourceBuilder mainType = lookupCallTestBuilder.getMainType();
        MethodSourceBuilder createLookupCall = new MethodSourceBuilder("createLookupCall");
        createLookupCall.setFlags(4);
        final String lookupCallSig = Signature.createTypeSignature((String)this.getCreatedLookupCall().getFullyQualifiedName());
        createLookupCall.setReturnTypeSignature(lookupCallSig);
        createLookupCall.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return new ").append(validator.useSignature(lookupCallSig)).append("();");
            }
        });
        mainType.addMethod((IMethodSourceBuilder)createLookupCall);
        mainType.addMethod(this.createTestMethod(createLookupCall.getElementName(), "All"));
        mainType.addMethod(this.createTestMethod(createLookupCall.getElementName(), "Key"));
        mainType.addMethod(this.createTestMethod(createLookupCall.getElementName(), "Text"));
        return S2eUtils.writeType(testSourceFolder, (ICompilationUnitSourceBuilder)lookupCallTestBuilder, env, monitor, workingCopyManager);
    }

    protected IMethodSourceBuilder createTestMethod(final String lookupCallCreateMethodName, final String suffix) {
        MethodSourceBuilder testMethod = new MethodSourceBuilder("testLookupBy" + suffix);
        testMethod.setFlags(1);
        testMethod.setReturnTypeSignature("V");
        testMethod.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                String callVarName = "call";
                source.append(validator.useName(LookupCallNewOperation.this.getCreatedLookupCall().getFullyQualifiedName())).append(' ').append(callVarName).append(" = ").append(lookupCallCreateMethodName).append("();").append(lineDelimiter);
                source.append(CoreUtils.getCommentBlock((String)"fill call")).append(lineDelimiter);
                String dataType = "java.util.List" + '<' + "? extends " + "org.eclipse.scout.rt.shared.services.lookup.ILookupRow" + '<' + validator.useName(LookupCallNewOperation.this.getKeyType().getFullyQualifiedName()) + '>' + '>';
                source.append(validator.useName(dataType)).append(" data = ").append(callVarName).append(".getDataBy").append(suffix).append("();").append(lineDelimiter);
                source.append(CoreUtils.getCommentBlock((String)"verify data"));
            }
        });
        testMethod.addAnnotation(ScoutAnnotationSourceBuilderFactory.createTest());
        return testMethod;
    }

    protected IType createLookupServiceIfc(String svcName, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        String ifcName = String.valueOf('I') + svcName;
        CompilationUnitSourceBuilder ifcBuilder = new CompilationUnitSourceBuilder(String.valueOf(ifcName) + ".java", this.getPackage());
        ifcBuilder.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)ifcBuilder));
        TypeSourceBuilder lookupSvcIfcBuilder = new TypeSourceBuilder(ifcName);
        lookupSvcIfcBuilder.setFlags(513);
        lookupSvcIfcBuilder.setComment(CommentSourceBuilderFactory.createDefaultTypeComment((ITypeSourceBuilder)lookupSvcIfcBuilder));
        StringBuilder superTypeBuilder = new StringBuilder("org.eclipse.scout.rt.shared.services.lookup.ILookupService");
        superTypeBuilder.append('<');
        superTypeBuilder.append(this.getKeyType().getFullyQualifiedName());
        superTypeBuilder.append('>');
        lookupSvcIfcBuilder.addInterfaceSignature(Signature.createTypeSignature((String)superTypeBuilder.toString()));
        ifcBuilder.addType((ITypeSourceBuilder)lookupSvcIfcBuilder);
        lookupSvcIfcBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createTunnelToServer());
        return S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)ifcBuilder, this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected IType createLookupServiceImpl(String svcName, String serverPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        CompilationUnitSourceBuilder implBuilder = new CompilationUnitSourceBuilder(String.valueOf(svcName) + ".java", serverPackage);
        implBuilder.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)implBuilder));
        TypeSourceBuilder lookupSvcImplBuilder = new TypeSourceBuilder(svcName);
        lookupSvcImplBuilder.setFlags(1);
        StringBuilder superTypeBuilder = new StringBuilder(this.getLookupServiceSuperType().getFullyQualifiedName());
        superTypeBuilder.append('<');
        superTypeBuilder.append(this.getKeyType().getFullyQualifiedName());
        superTypeBuilder.append('>');
        lookupSvcImplBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeBuilder.toString()));
        lookupSvcImplBuilder.addInterfaceSignature(Signature.createTypeSignature((String)this.getCreatedLookupServiceIfc().getFullyQualifiedName()));
        implBuilder.addType((ITypeSourceBuilder)lookupSvcImplBuilder);
        IJavaEnvironment env = this.getEnvProvider().get(this.getServerSourceFolder().getJavaProject());
        List unimplementedMethods = MethodSourceBuilderFactory.createUnimplementedMethods((String)lookupSvcImplBuilder.getSuperTypeSignature(), null, (String)serverPackage, (IJavaEnvironment)env);
        for (IMethodSourceBuilder methodSourceBuilder : unimplementedMethods) {
            lookupSvcImplBuilder.addMethod(methodSourceBuilder);
        }
        return S2eUtils.writeType(this.getServerSourceFolder(), (ICompilationUnitSourceBuilder)implBuilder, this.getEnvProvider().get(this.getServerSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected IType createLookupCall(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        IJavaEnvironment env = this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject());
        LookupCallSourceBuilder lcsb = new LookupCallSourceBuilder(this.getLookupCallName(), this.getPackage(), env);
        lcsb.setSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        if (S2eUtils.exists((IJavaElement)this.getCreatedLookupServiceIfc())) {
            lcsb.setLookupServiceIfcSignature(Signature.createTypeSignature((String)this.getCreatedLookupServiceIfc().getFullyQualifiedName()));
        }
        lcsb.setKeyTypeSignature(Signature.createTypeSignature((String)this.getKeyType().getFullyQualifiedName()));
        if (ClassIdGenerators.isAutomaticallyCreateClassIdAnnotation()) {
            lcsb.setClassIdValue(ClassIdGenerators.generateNewId(new ClassIdGenerationContext(String.valueOf(this.getPackage()) + '.' + this.getLookupCallName())));
        }
        lcsb.setup();
        List unimplementedMethods = MethodSourceBuilderFactory.createUnimplementedMethods((String)lcsb.getMainType().getSuperTypeSignature(), null, (String)this.getPackage(), (IJavaEnvironment)env);
        for (IMethodSourceBuilder methodSourceBuilder : unimplementedMethods) {
            lcsb.getMainType().addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)methodSourceBuilder), methodSourceBuilder);
        }
        return S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)lcsb, env, monitor, workingCopyManager);
    }

    public IType getCreatedLookupCall() {
        return this.m_createdLookupCall;
    }

    protected void setCreatedLookupCall(IType createdLookupCall) {
        this.m_createdLookupCall = createdLookupCall;
    }

    public String getLookupCallName() {
        return this.m_lookupCallName;
    }

    public void setLookupCallName(String lookupCallName) {
        this.m_lookupCallName = lookupCallName;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IType getKeyType() {
        return this.m_keyType;
    }

    public void setKeyType(IType keyType) {
        this.m_keyType = keyType;
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public IType getCreatedLookupServiceIfc() {
        return this.m_createdLookupServiceIfc;
    }

    protected void setCreatedLookupServiceIfc(IType createdLookupServiceIfc) {
        this.m_createdLookupServiceIfc = createdLookupServiceIfc;
    }

    public IType getCreatedLookupServiceImpl() {
        return this.m_createdLookupServiceImpl;
    }

    protected void setCreatedLookupServiceImpl(IType createdLookupServiceImpl) {
        this.m_createdLookupServiceImpl = createdLookupServiceImpl;
    }

    public IType getLookupServiceSuperType() {
        return this.m_lookupServiceSuperType;
    }

    public void setLookupServiceSuperType(IType lookupServiceSuperType) {
        this.m_lookupServiceSuperType = lookupServiceSuperType;
    }

    protected IJavaEnvironmentProvider getEnvProvider() {
        return this.m_javaEnvironmentProvider;
    }

    public IPackageFragmentRoot getTestSourceFolder() {
        return this.m_testSourceFolder;
    }

    public void setTestSourceFolder(IPackageFragmentRoot testSourceFolder) {
        this.m_testSourceFolder = testSourceFolder;
    }

    public IType getCreatedLookupCallTest() {
        return this.m_createdLookupCallTest;
    }

    protected void setCreatedLookupCallTest(IType createdLookupCallTest) {
        this.m_createdLookupCallTest = createdLookupCallTest;
    }
}

