/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.handles.CompartmentCollapseHandle;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.CompartmentCollapseTracker;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.ui.RefreshHelper;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class RegionResizableEditPolicy
extends AirResizableEditPolicy {
    public void setHost(EditPart host) {
        super.setHost(host);
        if (this.concernRegion()) {
            this.setResizeDirections(this.getParentStackDirection());
            this.setDragAllowed(false);
        }
    }

    protected void createResizeHandle(List handles, int direction) {
        if (!this.concernRegion() || (this.getResizeDirections() & direction) == direction) {
            super.createResizeHandle(handles, direction);
        }
    }

    @Override
    protected List createSelectionHandles() {
        List createSelectionHandles = super.createSelectionHandles();
        this.addCollapseHandle(createSelectionHandles);
        return createSelectionHandles;
    }

    protected void addCollapseHandle(List selectionHandles) {
        EditPart regionContainerPart = this.getRegionContainerPart();
        if (this.concernRegion() && regionContainerPart instanceof AbstractDiagramElementContainerEditPart && !((AbstractDiagramElementContainerEditPart)regionContainerPart).isRegion()) {
            AbstractDiagramElementContainerEditPart hostPart = (AbstractDiagramElementContainerEditPart)this.getHost();
            LabelAlignment textAlignment = this.getTextAlignment(hostPart);
            Iterable compartmentParts = Iterables.filter((Iterable)hostPart.getChildren(), IResizableCompartmentEditPart.class);
            if (new EditPartQuery(hostPart).getDrawerStyle() != null && !Iterables.isEmpty((Iterable)compartmentParts)) {
                selectionHandles.add(new RegionCollapseHandle((IGraphicalEditPart)compartmentParts.iterator().next(), textAlignment, hostPart));
            }
        }
    }

    private LabelAlignment getTextAlignment(AbstractDiagramElementContainerEditPart hostPart) {
        EList ownedElements;
        LabelAlignment alignment = (LabelAlignment)ViewpointPackage.eINSTANCE.getLabelStyle_LabelAlignment().getDefaultValue();
        DDiagramElement dde = hostPart.resolveDiagramElement();
        Style style = dde.getStyle();
        boolean hiddenLabel = new DDiagramElementQuery(dde).isLabelHidden();
        if (style instanceof LabelStyle && !hiddenLabel) {
            alignment = ((LabelStyle)style).getLabelAlignment();
        }
        if (hiddenLabel && dde instanceof DNodeList && !(ownedElements = ((DNodeList)dde).getOwnedElements()).isEmpty() && ((DNodeListElement)ownedElements.get(0)).getStyle() instanceof LabelStyle) {
            alignment = ((LabelStyle)((DNodeListElement)ownedElements.get(0)).getStyle()).getLabelAlignment();
        }
        return alignment;
    }

    public Command getCommand(Request request) {
        Object type = request.getType();
        if ("move".equals(type) && (this.isDragAllowed() || this.isAuthorizedMoveRequest(request))) {
            return this.getMoveCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    @Override
    protected Command getMoveCommand(ChangeBoundsRequest request) {
        if (this.concernRegion() && !this.isAuthorizedMoveRequest((Request)request)) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        return super.getMoveCommand(request);
    }

    private boolean isAuthorizedMoveRequest(Request request) {
        Object isAuthorizedMoveRequest = request.getExtendedData().get("sirius.pinned.elements.move.request");
        if (isAuthorizedMoveRequest instanceof Boolean) {
            return (Boolean)isAuthorizedMoveRequest;
        }
        return false;
    }

    @Override
    protected Command getAlignCommand(AlignmentRequest request) {
        if (this.concernRegion()) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        return super.getAlignCommand(request);
    }

    @Override
    protected Command getAutoSizeCommand(Request request) {
        Command autoSizeCommand = super.getAutoSizeCommand(request);
        if (this.concernRegion()) {
            EditPart regionContainerPart = this.getRegionContainerPart();
            Object object = request.getExtendedData().get("sirius.region.auto.size.propagator");
            if (object == this.getHost()) {
                autoSizeCommand = null;
            } else if (object != regionContainerPart) {
                Request req = new Request();
                req.setType(request.getType());
                req.getExtendedData().put("sirius.region.auto.size.propagator", this.getHost());
                Command regionContainerAutoSizeCommand = regionContainerPart.getCommand(req);
                if (this.getHost() instanceof IDiagramElementEditPart && regionContainerAutoSizeCommand != null) {
                    CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(((IDiagramElementEditPart)this.getHost()).getEditingDomain(), Messages.RegionResizableEditPolicy_regionAutoSizeCommandLabel);
                    ctc.add((IUndoableOperation)new CommandProxy(autoSizeCommand));
                    ctc.add((IUndoableOperation)new CommandProxy(regionContainerAutoSizeCommand));
                    autoSizeCommand = new ICommandProxy((ICommand)ctc);
                }
            }
        }
        return autoSizeCommand;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        Option<ChangeBoundsRequest> siblingRequest;
        super.showChangeBoundsFeedback(request);
        if (this.concernRegion() && (siblingRequest = this.getConstrainedSiblingRequest(request)).some() && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts() != null && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts().size() == 1) {
            if (((ChangeBoundsRequest)siblingRequest.get()).getTransformedRectangle(new Rectangle()).equals((Object)new Rectangle())) {
                return;
            }
            EditPart siblingPart = (EditPart)((ChangeBoundsRequest)siblingRequest.get()).getEditParts().get(0);
            siblingPart.showSourceFeedback((Request)siblingRequest.get());
        }
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        Option<ChangeBoundsRequest> siblingRequest;
        super.eraseChangeBoundsFeedback(request);
        if (this.concernRegion() && (siblingRequest = this.getConstrainedSiblingRequest(request)).some() && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts() != null && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts().size() == 1) {
            if (((ChangeBoundsRequest)siblingRequest.get()).getTransformedRectangle(new Rectangle()).equals((Object)new Rectangle())) {
                return;
            }
            EditPart siblingPart = (EditPart)((ChangeBoundsRequest)siblingRequest.get()).getEditParts().get(0);
            siblingPart.eraseSourceFeedback((Request)siblingRequest.get());
        }
    }

    @Override
    protected Command getResizeCommand(ChangeBoundsRequest request) {
        EditPart host = this.getHost();
        RequestQuery query = new RequestQuery((Request)request);
        if (host instanceof IGraphicalEditPart && new EditPartQuery((IGraphicalEditPart)host).isCollapsed()) {
            boolean forbiddenCollapseResize = false;
            if (this.getParentStackDirection() == 5) {
                forbiddenCollapseResize = (query.isResizeFromTop() || query.isResizeFromBottom()) && request.getSizeDelta().height() != 0;
            } else if (this.getParentStackDirection() == 24) {
                boolean bl = forbiddenCollapseResize = (query.isResizeFromLeft() || query.isResizeFromRight()) && request.getSizeDelta().width() != 0;
            }
            if (forbiddenCollapseResize) {
                return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
            }
        }
        if (this.isFirstRegionPart()) {
            request.getMoveDelta().setX(0);
            request.getMoveDelta().setY(0);
        } else if (this.getParentStackDirection() == 24) {
            request.getMoveDelta().setY(0);
        }
        return super.getResizeCommand(request);
    }

    @Override
    protected void completeResizeCommand(CompositeTransactionalCommand ctc, ChangeBoundsRequest request) {
        Option<ChangeBoundsRequest> siblingRequest;
        boolean invalidRequest;
        boolean bl = invalidRequest = request.getEditParts().size() > 1 && !request.isConstrainedResize() || request.isCenteredResize();
        if (invalidRequest || !this.validateResize(request)) {
            ctc.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
        }
        if ((siblingRequest = this.getConstrainedSiblingRequest(request)).some() && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts() != null && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts().size() == 1) {
            EditPart siblingPart = (EditPart)((ChangeBoundsRequest)siblingRequest.get()).getEditParts().get(0);
            ctc.add((IUndoableOperation)new CommandProxy(siblingPart.getCommand((Request)siblingRequest.get())));
        } else if (!request.isConstrainedMove() && !request.isConstrainedResize()) {
            ctc.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
        }
        Option<ChangeBoundsRequest> adjustChildrenRequest = this.getAdjustChildrenRequest(request);
        if (adjustChildrenRequest.some()) {
            super.completeResizeCommand(ctc, (ChangeBoundsRequest)adjustChildrenRequest.get());
        }
    }

    protected Option<ChangeBoundsRequest> getAdjustChildrenRequest(ChangeBoundsRequest request) {
        ChangeBoundsRequest requestToCompensate = null;
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (request.getExtendedData().get("sirius.region.resize.propagator") == this.getRegionContainerPart()) {
            Object object = request.getExtendedData().get("sirius.region.resize.initial.request");
            int stackDirection = this.getParentStackDirection();
            boolean needsAdjust = false;
            if (stackDirection == 5) {
                needsAdjust = requestQuery.isResizeFromLeft() || requestQuery.isResizeFromRight() || requestQuery.isResizeFromTop() && this.isFirstRegionPart();
            } else if (stackDirection == 24) {
                boolean bl = needsAdjust = requestQuery.isResizeFromTop() || requestQuery.isResizeFromBottom() || requestQuery.isResizeFromLeft() && this.isFirstRegionPart();
            }
            if (needsAdjust && object instanceof ChangeBoundsRequest) {
                requestToCompensate = (ChangeBoundsRequest)object;
            }
        } else {
            if (this.isFirstRegionPart() && (requestQuery.isResizeFromLeft() || requestQuery.isResizeFromTop())) {
                Dimension delta = request.getSizeDelta().getNegated();
                request.setMoveDelta(new Point(delta.width, delta.height));
            }
            requestToCompensate = request;
        }
        return Options.newSome((Object)requestToCompensate);
    }

    private boolean validateResize(ChangeBoundsRequest request) {
        IFigure hostFigure = this.getHostFigure();
        if (hostFigure != null) {
            Dimension minimumSize = hostFigure.getMinimumSize().getCopy();
            Rectangle resultingBounds = new RequestQuery((Request)request).getLogicalTransformedRectangle(hostFigure.getBounds().getCopy());
            return resultingBounds.width >= minimumSize.width && resultingBounds.height >= minimumSize.height;
        }
        return false;
    }

    private Option<ChangeBoundsRequest> getConstrainedSiblingRequest(ChangeBoundsRequest request) {
        Option constrainedRequest = Options.newNone();
        RequestQuery query = new RequestQuery((Request)request);
        Dimension sizeDelta = request.getSizeDelta().getCopy();
        EditPart regionContainer = this.getRegionContainerPart();
        boolean allowedRegionContainerPropagation = !request.isConstrainedResize() || request.getExtendedData().get("sirius.region.resize.propagator") != regionContainer;
        int stackDirection = this.getParentStackDirection();
        if (stackDirection == 5) {
            constrainedRequest = Options.newSome((Object)this.getVStackConstrainedSiblingRequest(request, query, sizeDelta, allowedRegionContainerPropagation, regionContainer));
        } else if (stackDirection == 24) {
            constrainedRequest = Options.newSome((Object)this.getHStackConstrainedSiblingRequest(request, query, sizeDelta, allowedRegionContainerPropagation, regionContainer));
        }
        return constrainedRequest;
    }

    private ChangeBoundsRequest getVStackConstrainedSiblingRequest(ChangeBoundsRequest request, RequestQuery query, Dimension sizeDelta, boolean allowedRegionContainerPropagation, EditPart regionContainer) {
        ChangeBoundsRequest constrainedRequest = null;
        ChangeBoundsRequest req = this.initSiblingRequest(request);
        if (query.isResizeFromTop()) {
            if (!this.isFirstRegionPart()) {
                Option<AbstractDiagramElementContainerEditPart> pred = this.getPrecedingRegion();
                if (pred.some() && !request.isConstrainedResize()) {
                    req.setEditParts((EditPart)pred.get());
                    req.setResizeDirection(4);
                    req.setSizeDelta(new Dimension(0, sizeDelta.getNegated().height));
                    constrainedRequest = req;
                }
            } else if (allowedRegionContainerPropagation) {
                req.setEditParts(regionContainer);
                req.setResizeDirection(request.getResizeDirection());
                req.setSizeDelta(new Dimension(0, sizeDelta.height));
                req.setMoveDelta(new Point(0, -sizeDelta.height));
                constrainedRequest = req;
            }
        } else if (query.isResizeFromBottom()) {
            if (!this.isLastRegionPart()) {
                Option<AbstractDiagramElementContainerEditPart> follo = this.getFollowingRegion();
                if (follo.some() && !request.isConstrainedResize()) {
                    Point moveDelta = new Point(sizeDelta.width, sizeDelta.height);
                    req.setEditParts((EditPart)follo.get());
                    req.setResizeDirection(1);
                    req.setSizeDelta(new Dimension(0, sizeDelta.getNegated().height));
                    req.setMoveDelta(new Point(0, moveDelta.y));
                    constrainedRequest = req;
                }
            } else if (allowedRegionContainerPropagation) {
                req.setEditParts(regionContainer);
                req.setResizeDirection(request.getResizeDirection());
                req.setSizeDelta(new Dimension(0, sizeDelta.height));
                constrainedRequest = req;
                constrainedRequest = this.handleEmptySpaceInContainerOnLastRegionResize(request, constrainedRequest);
            }
        } else if (query.isResizeFromRight() && allowedRegionContainerPropagation) {
            req.setEditParts(regionContainer);
            req.setResizeDirection(request.getResizeDirection());
            req.setSizeDelta(new Dimension(sizeDelta.width, 0));
            constrainedRequest = req;
        } else if (query.isResizeFromLeft() && allowedRegionContainerPropagation) {
            req.setEditParts(regionContainer);
            req.setResizeDirection(request.getResizeDirection());
            req.setSizeDelta(new Dimension(sizeDelta.width, 0));
            req.setMoveDelta(new Point(-sizeDelta.width, 0));
            constrainedRequest = req;
        }
        return constrainedRequest;
    }

    private ChangeBoundsRequest handleEmptySpaceInContainerOnLastRegionResize(ChangeBoundsRequest initialRequest, ChangeBoundsRequest constrainedRequest) {
        boolean keepSameAbsoluteLocation;
        ChangeBoundsRequest result = constrainedRequest;
        Object object = initialRequest.getExtendedData().get("keepSameAbsoluteLocation");
        boolean bl = keepSameAbsoluteLocation = object == null || object != null && (Boolean)object != false;
        if (!initialRequest.isConstrainedResize() && !keepSameAbsoluteLocation) {
            result.setMoveDelta(new Point(0, 0));
            result.setSizeDelta(new Dimension(0, 0));
            IFigure hostFigure = this.getHostFigure();
            IFigure parentFigure = hostFigure.getParent();
            if (!parentFigure.getBounds().contains(new RequestQuery((Request)initialRequest).getLogicalTransformedRectangle(hostFigure.getBounds()).getBottomRight())) {
                result = null;
            }
        }
        return result;
    }

    private ChangeBoundsRequest getHStackConstrainedSiblingRequest(ChangeBoundsRequest request, RequestQuery query, Dimension sizeDelta, boolean regionContainerPropagationAllowed, EditPart regionContainer) {
        ChangeBoundsRequest constrainedRequest = null;
        ChangeBoundsRequest req = this.initSiblingRequest(request);
        if (query.isResizeFromLeft()) {
            if (!this.isFirstRegionPart()) {
                Option<AbstractDiagramElementContainerEditPart> pred = this.getPrecedingRegion();
                if (pred.some() && !request.isConstrainedResize()) {
                    req.setEditParts((EditPart)pred.get());
                    req.setResizeDirection(16);
                    req.setSizeDelta(new Dimension(sizeDelta.getNegated().width, 0));
                    constrainedRequest = req;
                }
            } else if (regionContainerPropagationAllowed) {
                req.setEditParts(regionContainer);
                req.setResizeDirection(request.getResizeDirection());
                req.setSizeDelta(new Dimension(sizeDelta.width, 0));
                req.setMoveDelta(new Point(-sizeDelta.width, 0));
                constrainedRequest = req;
            }
        } else if (query.isResizeFromRight()) {
            if (!this.isLastRegionPart()) {
                Option<AbstractDiagramElementContainerEditPart> follo = this.getFollowingRegion();
                if (follo.some() && !request.isConstrainedResize()) {
                    req.setEditParts((EditPart)follo.get());
                    req.setResizeDirection(8);
                    req.setSizeDelta(new Dimension(-sizeDelta.width, 0));
                    req.setMoveDelta(new Point(sizeDelta.width, 0));
                    constrainedRequest = req;
                }
            } else if (regionContainerPropagationAllowed) {
                req.setEditParts(regionContainer);
                req.setResizeDirection(request.getResizeDirection());
                req.setSizeDelta(new Dimension(sizeDelta.width, 0));
                constrainedRequest = req;
                constrainedRequest = this.handleEmptySpaceInContainerOnLastRegionResize(request, constrainedRequest);
            }
        } else if (query.isResizeFromBottom() && regionContainerPropagationAllowed) {
            req.setEditParts(regionContainer);
            req.setResizeDirection(request.getResizeDirection());
            req.setSizeDelta(new Dimension(0, sizeDelta.height));
            constrainedRequest = req;
        } else if (query.isResizeFromTop() && regionContainerPropagationAllowed) {
            req.setEditParts(regionContainer);
            req.setResizeDirection(request.getResizeDirection());
            req.setSizeDelta(new Dimension(0, sizeDelta.height));
            req.setMoveDelta(new Point(0, -sizeDelta.height));
            constrainedRequest = req;
        }
        return constrainedRequest;
    }

    private ChangeBoundsRequest initSiblingRequest(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        req.setConstrainedResize(true);
        req.setConstrainedMove(true);
        req.setType(request.getType());
        req.getExtendedData().put("sirius.region.resize.propagator", this.getHost());
        req.getExtendedData().put("keepSameAbsoluteLocation", request.getExtendedData().get("keepSameAbsoluteLocation"));
        req.getExtendedData().put("sirius.region.resize.initial.request", request);
        return req;
    }

    private EditPart getRegionContainerPart() {
        EditPart regionContainer = this.getHost().getParent();
        if (regionContainer != null) {
            regionContainer = regionContainer.getParent();
        }
        return regionContainer;
    }

    private Option<AbstractDiagramElementContainerEditPart> getPrecedingRegion() {
        List<AbstractDiagramElementContainerEditPart> siblingRegions = this.getSiblingRegionParts();
        int precedingIndex = siblingRegions.indexOf(this.getHost()) - 1;
        if (precedingIndex >= 0 && siblingRegions.size() >= precedingIndex) {
            return Options.newSome((Object)siblingRegions.get(precedingIndex));
        }
        return Options.newNone();
    }

    private Option<AbstractDiagramElementContainerEditPart> getFollowingRegion() {
        List<AbstractDiagramElementContainerEditPart> siblingRegions = this.getSiblingRegionParts();
        int followingIndex = siblingRegions.indexOf(this.getHost()) + 1;
        if (followingIndex > 0 && siblingRegions.size() > followingIndex) {
            return Options.newSome((Object)siblingRegions.get(followingIndex));
        }
        return Options.newNone();
    }

    private boolean concernRegion() {
        boolean regionImpacted = false;
        EditPart hostPart = this.getHost();
        if (hostPart instanceof AbstractDiagramElementContainerEditPart) {
            IDiagramElementEditPart ideep = (IDiagramElementEditPart)hostPart;
            DDiagramElement dde = ideep.resolveDiagramElement();
            regionImpacted = dde instanceof DDiagramElementContainer && new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dde).isRegion();
        }
        return regionImpacted;
    }

    private int getParentStackDirection() {
        int direction = 0;
        EditPart hostPart = this.getHost();
        if (hostPart instanceof AbstractDiagramElementContainerEditPart) {
            direction = ((AbstractDiagramElementContainerEditPart)hostPart).getParentStackDirection();
        }
        return direction;
    }

    private List<AbstractDiagramElementContainerEditPart> getSiblingRegionParts() {
        EditPart parent;
        EditPart editPart = parent = this.getHost() != null ? this.getHost().getParent() : null;
        if (parent instanceof AbstractDNodeContainerCompartmentEditPart) {
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)parent.getChildren(), AbstractDiagramElementContainerEditPart.class));
        }
        return Collections.emptyList();
    }

    private boolean isFirstRegionPart() {
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getSiblingRegionParts();
        return !Iterables.isEmpty(regionParts) && Iterables.getFirst(regionParts, null) == this.getHost();
    }

    private boolean isLastRegionPart() {
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getSiblingRegionParts();
        return !Iterables.isEmpty(regionParts) && Iterables.getLast(regionParts, null) == this.getHost();
    }

    private static class RegionCollapseHandle
    extends CompartmentCollapseHandle {
        private AbstractDiagramElementContainerEditPart regionPart;

        RegionCollapseHandle(IGraphicalEditPart owner, LabelAlignment alignment, AbstractDiagramElementContainerEditPart regionPart) {
            super(owner);
            this.regionPart = regionPart;
            this.setLocator(new RegionCollapseHandleLocator(alignment));
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed() == notification.getFeature()) {
                this.regionPart.notifyChanged(notification);
            }
        }

        protected DragTracker createDragTracker() {
            return new CompartmentCollapseTracker((IResizableCompartmentEditPart)this.getOwner()){

                protected Command getCommand(Boolean expand) {
                    Command command = super.getCommand(expand);
                    CompoundCommand commandPlusForceRefresh = new CompoundCommand(command.getLabel());
                    if (!RefreshHelper.isAutoRefresh()) {
                        commandPlusForceRefresh.add(new Command(){

                            public void execute() {
                                Session session;
                                Optional<DDiagram> optionalDDiagram = new org.eclipse.sirius.diagram.ui.business.api.query.EditPartQuery(regionPart).getDDiagram();
                                if (optionalDDiagram.isPresent() && (session = SessionManager.INSTANCE.getSession((EObject)optionalDDiagram.get())) != null) {
                                    session.getRefreshEditorsListener().setForceRefresh(true);
                                }
                            }

                            public void undo() {
                                this.execute();
                            }
                        });
                    }
                    commandPlusForceRefresh.add(command);
                    return commandPlusForceRefresh;
                }
            };
        }

        private class RegionCollapseHandleLocator
        implements Locator {
            private boolean isRegionTextLeftAligned;

            RegionCollapseHandleLocator(LabelAlignment alignment) {
                this.isRegionTextLeftAligned = LabelAlignment.LEFT.equals((Object)alignment);
            }

            public void relocate(IFigure target) {
                IFigure handleOwner = RegionCollapseHandle.this.getOwnerFigure();
                if (handleOwner.getParent() != null) {
                    handleOwner = handleOwner.getParent();
                }
                Rectangle theBounds = handleOwner.getClientArea().getCopy();
                handleOwner.translateToAbsolute((Translatable)theBounds);
                target.translateToRelative((Translatable)theBounds);
                int leftOffset = 5;
                int topOffset = 0;
                if (handleOwner instanceof DefaultSizeNodeFigure) {
                    topOffset = 5;
                } else if (handleOwner.getBorder() != null && handleOwner.getBorder().getInsets(null) != null) {
                    topOffset = 5 - handleOwner.getBorder().getInsets(null).top;
                }
                if (this.isRegionTextLeftAligned) {
                    target.setLocation(theBounds.getTopRight().getTranslated(-RegionCollapseHandle.this.getBounds().width(), topOffset));
                } else {
                    target.setLocation(theBounds.getLocation().getTranslated(leftOffset, topOffset));
                }
            }
        }
    }
}

