/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.validation;

import java.io.IOException;
import java.util.Stack;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.json.core.internal.JSONCoreMessages;
import org.eclipse.wst.json.core.internal.parser.JSONLineTokenizer;
import org.eclipse.wst.json.core.util.JSONUtil;
import org.eclipse.wst.json.core.validation.AnnotationMsg;
import org.eclipse.wst.json.core.validation.ISeverityProvider;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSONSyntaxValidatorHelper {
    private static final int ERROR_THRESHOLD = 25;

    public static void validate(JSONLineTokenizer tokenizer, IReporter reporter, IValidator validator, ISeverityProvider provider) {
        String type = null;
        Stack<Token> tagStack = new Stack<Token>();
        int tagErrorCount = 0;
        Token previousRegion = null;
        while ((type = JSONSyntaxValidatorHelper.getNextToken(tokenizer)) != null) {
            Token lastToken;
            Token token = new Token(type, tokenizer.yytext(), tokenizer.getOffset(), tokenizer.yylength(), tokenizer.getLine());
            boolean hasError = JSONSyntaxValidatorHelper.checkExpectedRegion(token, previousRegion, tagStack, reporter, validator, provider);
            if (type == "JSON_OBJECT_OPEN" || type == "JSON_ARRAY_OPEN") {
                tagStack.push(token);
            } else if (type == "JSON_OBJECT_CLOSE") {
                if (tagStack.isEmpty()) {
                    JSONSyntaxValidatorHelper.createMissingTagError(token, false, reporter, tagErrorCount, tagStack, validator, provider);
                } else {
                    lastToken = tagStack.peek();
                    if (lastToken.type == "JSON_OBJECT_OPEN") {
                        tagStack.pop();
                    }
                }
            } else if (type == "JSON_ARRAY_CLOSE") {
                if (tagStack.isEmpty()) {
                    JSONSyntaxValidatorHelper.createMissingTagError(token, false, reporter, tagErrorCount, tagStack, validator, provider);
                } else {
                    lastToken = tagStack.peek();
                    if (lastToken.type == "JSON_ARRAY_OPEN" && !tagStack.isEmpty()) {
                        tagStack.pop();
                    }
                }
            } else if (type.equalsIgnoreCase("UNDEFINED")) {
                if ("{".equals(token.text)) {
                    tagStack.push(token);
                } else if ("}".equals(token.text)) {
                    if (!tagStack.isEmpty()) {
                        tagStack.pop();
                    }
                } else if ("[".equals(token.text)) {
                    tagStack.push(token);
                } else if ("]".equals(token.text)) {
                    if (!tagStack.isEmpty()) {
                        tagStack.pop();
                    }
                } else if (!hasError) {
                    String messageText = "Unexpected token";
                    LocalizedMessage message = JSONSyntaxValidatorHelper.createMessage(token, messageText, "missingBracket", provider);
                    JSONSyntaxValidatorHelper.getAnnotationMsg(reporter, 2, message, null, token.length, validator);
                }
            }
            if (JSONSyntaxValidatorHelper.isIgnoreRegion(type)) continue;
            previousRegion = token;
        }
        if (!tagStack.isEmpty()) {
            while (!tagStack.isEmpty()) {
                JSONSyntaxValidatorHelper.createMissingTagError((Token)tagStack.pop(), true, reporter, tagErrorCount, tagStack, validator, provider);
            }
        }
    }

    private static boolean isIgnoreRegion(String type) {
        return type == "JSON_COMMENT" || type == "WHITE_SPACE" || type.equalsIgnoreCase("UNDEFINED");
    }

    private static boolean checkExpectedRegion(Token current, Token previous, Stack<Token> tagStack, IReporter reporter, IValidator validator, ISeverityProvider provider) {
        if (previous == null || JSONSyntaxValidatorHelper.isIgnoreRegion(current.type)) {
            return false;
        }
        if (previous.type == "JSON_OBJECT_OPEN") {
            if (current.type != "JSON_OBJECT_CLOSE" && current.type != "JSON_OBJECT_KEY") {
                String messageText = "Expected object key but found " + current.type;
                LocalizedMessage message = JSONSyntaxValidatorHelper.createMessage(current, messageText, "missingBracket", provider);
                JSONSyntaxValidatorHelper.getAnnotationMsg(reporter, 2, message, null, current.length, validator);
                return true;
            }
        } else if (previous.type == "JSON_OBJECT_KEY") {
            if (current.type != "JSON_COLON") {
                String messageText = "Expected colon but found " + current.type;
                LocalizedMessage message = JSONSyntaxValidatorHelper.createMessage(current, messageText, "missingBracket", provider);
                JSONSyntaxValidatorHelper.getAnnotationMsg(reporter, 2, message, null, current.length, validator);
                return true;
            }
        } else if (previous.type == "JSON_COLON") {
            if (!JSONUtil.isJSONSimpleValue(current.type) && !JSONUtil.isStartJSONStructure(current.type)) {
                String messageText = "Expected JSON value but found " + current.type;
                LocalizedMessage message = JSONSyntaxValidatorHelper.createMessage(current, messageText, "missingBracket", provider);
                JSONSyntaxValidatorHelper.getAnnotationMsg(reporter, 2, message, null, current.length, validator);
                return true;
            }
        } else if (previous.type == "JSON_COMMA") {
            if (tagStack.isEmpty()) {
                String messageText = "Unexpected comma";
                LocalizedMessage message = JSONSyntaxValidatorHelper.createMessage(current, messageText, "missingBracket", provider);
                JSONSyntaxValidatorHelper.getAnnotationMsg(reporter, 2, message, null, current.length, validator);
                return true;
            }
            if (tagStack.peek().type == "JSON_ARRAY_OPEN") {
                if (!JSONUtil.isJSONSimpleValue(current.type) && current.type != "JSON_ARRAY_OPEN" && current.type != "JSON_OBJECT_OPEN") {
                    String messageText = "Expected JSON value but found " + current.type;
                    LocalizedMessage message = JSONSyntaxValidatorHelper.createMessage(current, messageText, "missingBracket", provider);
                    JSONSyntaxValidatorHelper.getAnnotationMsg(reporter, 2, message, null, current.length, validator);
                    return true;
                }
            } else if (current.type != "JSON_OBJECT_KEY") {
                String messageText = "Expected JSON key but found " + current.type;
                LocalizedMessage message = JSONSyntaxValidatorHelper.createMessage(current, messageText, "missingBracket", provider);
                JSONSyntaxValidatorHelper.getAnnotationMsg(reporter, 2, message, null, current.length, validator);
                return true;
            }
        }
        return false;
    }

    private static void createMissingTagError(Token token, boolean isStartTag, IReporter reporter, int tagErrorCount, Stack<Token> tagStack, IValidator validator, ISeverityProvider provider) {
        boolean isArray = token.type == "JSON_ARRAY_OPEN" || token.type == "JSON_ARRAY_CLOSE";
        Object[] args = new Object[]{token.text};
        String messageText = NLS.bind((String)JSONSyntaxValidatorHelper.getMessage(isStartTag, isArray), (Object[])args);
        LocalizedMessage message = JSONSyntaxValidatorHelper.createMessage(token, messageText, "missingBracket", provider);
        String fixInfo = token.text;
        JSONSyntaxValidatorHelper.getAnnotationMsg(reporter, isStartTag ? 2 : 1, message, fixInfo, token.length, validator);
        if (++tagErrorCount > 25) {
            tagStack.clear();
        }
    }

    private static LocalizedMessage createMessage(Token token, String messageText, String severityPreference, ISeverityProvider provider) {
        LocalizedMessage message = new LocalizedMessage(provider.getSeverity(severityPreference), messageText);
        message.setOffset(token.offset);
        message.setLength(token.length);
        message.setLineNo(JSONSyntaxValidatorHelper.getLine(token));
        return message;
    }

    private static void getAnnotationMsg(IReporter reporter, int problemId, LocalizedMessage message, Object attributeValueText, int len, IValidator validator) {
        AnnotationMsg annotation = new AnnotationMsg(problemId, attributeValueText, len);
        message.setAttribute(AnnotationMsg.ID, (Object)annotation);
        reporter.addMessage(validator, (IMessage)message);
    }

    private static String getMessage(boolean isStartTag, boolean isArray) {
        if (isArray) {
            return isStartTag ? JSONCoreMessages.Missing_end_array : JSONCoreMessages.Missing_start_array;
        }
        return isStartTag ? JSONCoreMessages.Missing_end_object : JSONCoreMessages.Missing_start_object;
    }

    private static int getLine(Token token) {
        return token.line + 1;
    }

    private static String getNextToken(JSONLineTokenizer tokenizer) {
        String token = null;
        try {
            if (!tokenizer.isEOF()) {
                token = tokenizer.primGetNextToken();
            }
        }
        catch (IOException iOException) {}
        return token;
    }

    private static class Token {
        String type;
        int offset;
        int length;
        int line;
        String text;

        public Token(String type, String text, int offset, int length, int line) {
            this.type = type;
            this.text = text;
            this.offset = offset;
            this.length = length;
            this.line = line;
        }

        public String toString() {
            return this.type + "[" + this.line + "-" + this.offset + "]: " + this.text;
        }
    }
}

