/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import lpg.lpgjavaruntime.MismatchedInputCharsException;
import lpg.lpgjavaruntime.PrsStream;

public abstract class AbstractToken {
    private int kind = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int tokenIndex = 0;
    private int adjunctIndex;
    private PrsStream prsStream;

    public AbstractToken() {
    }

    public AbstractToken(PrsStream prsStream, int startOffset, int endOffset, int kind) {
        this.prsStream = prsStream;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.kind = kind;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    public void setAdjunctIndex(int adjunctIndex) {
        this.adjunctIndex = adjunctIndex;
    }

    public int getAdjunctIndex() {
        return this.adjunctIndex;
    }

    public PrsStream getPrsStream() {
        return this.prsStream;
    }

    public int getLine() {
        return this.prsStream == null ? 0 : this.prsStream.getLexStream().getLineNumberOfCharAt(this.startOffset);
    }

    public int getColumn() {
        return this.prsStream == null ? 0 : this.prsStream.getLexStream().getColumnOfCharAt(this.startOffset);
    }

    public int getEndLine() {
        return this.prsStream == null ? 0 : this.prsStream.getLexStream().getLineNumberOfCharAt(this.endOffset);
    }

    public int getEndColumn() {
        return this.prsStream == null ? 0 : this.prsStream.getLexStream().getColumnOfCharAt(this.endOffset);
    }

    public String getValue(char[] inputChars) {
        if (inputChars != this.prsStream.getInputChars() && this.prsStream != null) {
            throw new MismatchedInputCharsException();
        }
        return this.toString();
    }

    public String toString() {
        if (this.prsStream == null) {
            return "<toString>";
        }
        if (this.endOffset >= this.prsStream.getInputChars().length) {
            return String.valueOf('\uffff');
        }
        int len = this.endOffset - this.startOffset + 1;
        return new String(this.prsStream.getInputChars(), this.startOffset, len);
    }
}

