/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.index.IndexReader;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.PreliminaryIndexImpl;
import org.eclipse.mat.parser.internal.SnapshotImplBuilder;
import org.eclipse.mat.parser.internal.snapshot.ObjectMarker;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.snapshot.UnreachableObjectsHistogram;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SilentProgressListener;

class GarbageCleaner {
    private static final int PARALLEL_CHUNK_SIZE = 0x1000000;

    GarbageCleaner() {
    }

    public static int[] clean(final PreliminaryIndexImpl idx, SnapshotImplBuilder builder, Map<String, String> arguments, IProgressListener listener) throws IOException, InterruptedException, ExecutionException {
        IndexManager idxManager = new IndexManager();
        ExecutorService es = Executors.newWorkStealingPool();
        try {
            listener.beginTask(Messages.GarbageCleaner_RemovingUnreachableObjects, 11);
            listener.subTask(Messages.GarbageCleaner_SearchingForUnreachableObjects);
            int oldNoOfObjects = idx.identifiers.size();
            boolean[] reachable = new boolean[oldNoOfObjects];
            int newNoOfObjects = 0;
            int[] newRoots = idx.gcRoots.getAllKeys();
            IIndexReader.IOne2LongIndex identifiers = idx.identifiers;
            IIndexReader.IOne2ManyIndex preOutbound = idx.outbound;
            IIndexReader.IOne2OneIndex object2classId = idx.object2classId;
            HashMapIntObject<ClassImpl> classesById = idx.classesById;
            ObjectMarker marker = new ObjectMarker(newRoots, reachable, preOutbound, (IProgressListener)new SilentProgressListener(listener));
            int numProcessors = Runtime.getRuntime().availableProcessors();
            if (numProcessors > 1) {
                try {
                    marker.markMultiThreaded(numProcessors);
                }
                catch (InterruptedException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                boolean[] blArray = reachable;
                int n = reachable.length;
                int ioe = 0;
                while (ioe < n) {
                    boolean b = blArray[ioe];
                    if (b) {
                        ++newNoOfObjects;
                    }
                    ++ioe;
                }
            } else {
                try {
                    newNoOfObjects = marker.markSingleThreaded();
                }
                catch (IProgressListener.OperationCanceledException e) {
                    idx.delete();
                    if (idxManager != null && listener.isCanceled()) {
                        idxManager.delete();
                    }
                    return null;
                }
            }
            marker = null;
            if (newNoOfObjects < oldNoOfObjects) {
                Serializable un = idx.getSnapshotInfo().getProperty("keep_unreachable_objects");
                if (un instanceof Integer) {
                    int newRoot = (Integer)un;
                    newNoOfObjects = GarbageCleaner.markUnreachableAsGCRoots(idx, reachable, newNoOfObjects, newRoot, listener);
                }
                if (newNoOfObjects < oldNoOfObjects) {
                    GarbageCleaner.createHistogramOfUnreachableObjects(es, idx, reachable);
                }
            }
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(Messages.GarbageCleaner_ReIndexingObjects);
            final int[] map = new int[oldNoOfObjects];
            long[] id2a = new long[newNoOfObjects];
            ArrayList<ClassImpl> classes2remove = new ArrayList<ClassImpl>();
            IIndexReader.IOne2SizeIndex preA2size = idx.array2size;
            long memFree = 0L;
            int ii = 0;
            int jj = 0;
            while (ii < oldNoOfObjects) {
                if (reachable[ii]) {
                    map[ii] = jj;
                    id2a[jj++] = identifiers.get(ii);
                } else {
                    map[ii] = -1;
                }
                ++ii;
            }
            ArrayList<CalculateGarbageCleanupForClass> tasks = new ArrayList<CalculateGarbageCleanupForClass>();
            int i = 0;
            while (i < oldNoOfObjects) {
                int start = i;
                int length = Math.min(0x1000000, reachable.length - start);
                tasks.add(new CalculateGarbageCleanupForClass(idx, reachable, start, length));
                i += 0x1000000;
            }
            List wrappers = null;
            wrappers = es.invokeAll(tasks);
            for (Future wrapper : wrappers) {
                for (CleanupResult cr : ((CleanupWrapper)wrapper.get()).results.values()) {
                    long totalmem = cr.size;
                    int i2 = cr.count;
                    while (i2 > 0) {
                        long instsize = totalmem / (long)i2;
                        totalmem -= instsize;
                        cr.clazz.removeInstance(instsize);
                        --i2;
                    }
                    memFree += cr.size;
                }
                for (ClassImpl c : ((CleanupWrapper)wrapper.get()).classes2remove) {
                    classes2remove.add(c);
                }
            }
            if (newNoOfObjects < oldNoOfObjects) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.GarbageCleaner_RemovedUnreachableObjects, (Object[])new Object[]{oldNoOfObjects - newNoOfObjects, memFree}), null);
            }
            es.shutdown();
            for (ClassImpl c : classes2remove) {
                classesById.remove(c.getObjectId());
                ClassImpl superclass = (ClassImpl)classesById.get(c.getSuperClassId());
                if (superclass == null) continue;
                superclass.removeSubClass(c);
            }
            reachable = null;
            identifiers.close();
            identifiers.delete();
            identifiers = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(Messages.GarbageCleaner_ReIndexingClasses);
            HashMapIntObject classesByNewId = new HashMapIntObject(classesById.size());
            Iterator iter = classesById.values();
            while (iter.hasNext()) {
                ClassImpl clazz = (ClassImpl)iter.next();
                int index = map[clazz.getObjectId()];
                clazz.setObjectId(index);
                if (clazz.getSuperClassId() >= 0) {
                    clazz.setSuperClassIndex(map[clazz.getSuperClassId()]);
                }
                clazz.setClassLoaderIndex(map[clazz.getClassLoaderId()]);
                classesByNewId.put(index, (Object)clazz);
            }
            idx.getSnapshotInfo().setNumberOfClasses(classesByNewId.size());
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            File indexFile = IndexManager.Index.IDENTIFIER.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageUtil.format((String)Messages.GarbageCleaner_Writing, (Object[])new Object[]{indexFile.getAbsolutePath()}));
            idxManager.setReader(IndexManager.Index.IDENTIFIER, new IndexWriter.LongIndexStreamer().writeTo(indexFile, id2a));
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            indexFile = IndexManager.Index.O2CLASS.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageUtil.format((String)Messages.GarbageCleaner_Writing, (Object[])new Object[]{indexFile.getAbsolutePath()}));
            idxManager.setReader(IndexManager.Index.O2CLASS, new IndexWriter.IntIndexStreamer().writeTo(indexFile, new NewObjectIntIterator(){

                @Override
                int doGetNextInt(int index) {
                    return map[idx.object2classId.get(this.nextIndex)];
                }

                @Override
                int[] getMap() {
                    return map;
                }
            }));
            object2classId.close();
            object2classId.delete();
            object2classId = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            indexFile = IndexManager.Index.A2SIZE.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageUtil.format((String)Messages.GarbageCleaner_Writing, (Object[])new Object[]{indexFile.getAbsolutePath()}));
            final BitField arrayObjects = new BitField(newNoOfObjects);
            IIndexReader.IOne2OneIndex newIdx = new IndexWriter.IntIndexStreamer().writeTo(indexFile, new NewObjectIntIterator(preA2size){
                IIndexReader.IOne2SizeIndex a2size;
                int newIndex;
                {
                    this.a2size = iOne2SizeIndex;
                    this.newIndex = 0;
                }

                @Override
                int doGetNextInt(int index) {
                    int size = this.a2size.get(this.nextIndex);
                    if (size != 0) {
                        arrayObjects.set(this.newIndex);
                    }
                    ++this.newIndex;
                    return size;
                }

                @Override
                int[] getMap() {
                    return map;
                }
            });
            idxManager.setReader(IndexManager.Index.A2SIZE, new IndexReader.SizeIndexReader(newIdx));
            preA2size.close();
            preA2size.delete();
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(Messages.GarbageCleaner_ReIndexingOutboundIndex);
            IndexWriter.IntArray1NSortedWriter w_out = new IndexWriter.IntArray1NSortedWriter(newNoOfObjects, IndexManager.Index.OUTBOUND.getFile(idx.snapshotInfo.getPrefix()));
            IndexWriter.InboundWriter w_in = new IndexWriter.InboundWriter(newNoOfObjects, IndexManager.Index.INBOUND.getFile(idx.snapshotInfo.getPrefix()));
            int ii2 = 0;
            while (ii2 < oldNoOfObjects) {
                int k = map[ii2];
                if (k >= 0) {
                    int[] a = preOutbound.get(ii2);
                    int[] tl = new int[a.length];
                    int jj2 = 0;
                    while (jj2 < a.length) {
                        int t;
                        tl[jj2] = t = map[a[jj2]];
                        w_in.log(t, k, jj2 == 0);
                        ++jj2;
                    }
                    w_out.log(k, tl);
                }
                ++ii2;
            }
            preOutbound.close();
            preOutbound.delete();
            preOutbound = null;
            if (listener.isCanceled()) {
                w_in.cancel();
                w_out.cancel();
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(MessageUtil.format((String)Messages.GarbageCleaner_Writing, (Object[])new Object[]{w_in.getIndexFile().getAbsolutePath()}));
            idxManager.setReader(IndexManager.Index.INBOUND, w_in.flush(listener, new KeyWriterImpl((HashMapIntObject<ClassImpl>)classesByNewId)));
            w_in = null;
            if (listener.isCanceled()) {
                w_out.cancel();
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(MessageUtil.format((String)Messages.GarbageCleaner_Writing, (Object[])new Object[]{w_out.getIndexFile().getAbsolutePath()}));
            idxManager.setReader(IndexManager.Index.OUTBOUND, w_out.flush());
            w_out = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            HashMapIntObject<XGCRootInfo[]> roots = GarbageCleaner.fix(idx.gcRoots, map);
            idx.getSnapshotInfo().setNumberOfGCRoots(roots.size());
            HashMapIntObject rootsPerThread = new HashMapIntObject();
            IteratorInt iter2 = idx.thread2objects2roots.keys();
            while (iter2.hasNext()) {
                int threadId = iter2.next();
                int fixedThreadId = map[threadId];
                if (fixedThreadId < 0) continue;
                rootsPerThread.put(fixedThreadId, GarbageCleaner.fix((HashMapIntObject<List<XGCRootInfo>>)((HashMapIntObject)idx.thread2objects2roots.get(threadId)), map));
            }
            builder.setIndexManager(idxManager);
            builder.setClassCache((HashMapIntObject<ClassImpl>)classesByNewId);
            builder.setArrayObjects(arrayObjects);
            builder.setRoots(roots);
            builder.setRootsPerThread((HashMapIntObject<HashMapIntObject<XGCRootInfo[]>>)rootsPerThread);
            int[] nArray = map;
            return nArray;
        }
        finally {
            idx.delete();
            if (idxManager != null && listener.isCanceled()) {
                idxManager.delete();
            }
        }
    }

    private static HashMapIntObject<XGCRootInfo[]> fix(HashMapIntObject<List<XGCRootInfo>> roots, int[] map) {
        HashMapIntObject answer = new HashMapIntObject(roots.size());
        Iterator iter = roots.values();
        while (iter.hasNext()) {
            List r = (List)iter.next();
            XGCRootInfo[] a = new XGCRootInfo[r.size()];
            int ii = 0;
            while (ii < a.length) {
                a[ii] = (XGCRootInfo)((Object)r.get(ii));
                a[ii].setObjectId(map[a[ii].getObjectId()]);
                if (a[ii].getContextAddress() != 0L) {
                    a[ii].setContextId(map[a[ii].getContextId()]);
                }
                ++ii;
            }
            answer.put(a[0].getObjectId(), (Object)a);
        }
        return answer;
    }

    private static void createHistogramOfUnreachableObjects(ExecutorService es, PreliminaryIndexImpl idx, boolean[] reachable) throws InterruptedException, ExecutionException {
        ArrayList<CreateHistogramOfUnreachableObjectsChunk> tasks = new ArrayList<CreateHistogramOfUnreachableObjectsChunk>();
        int i = 0;
        while (i < reachable.length) {
            int start = i;
            int length = Math.min(0x1000000, reachable.length - start);
            tasks.add(new CreateHistogramOfUnreachableObjectsChunk(idx, reachable, start, length));
            i += 0x1000000;
        }
        List results = null;
        results = es.invokeAll(tasks);
        HashMap histogram = new HashMap(reachable.length);
        for (Future subhistogram : results) {
            histogram.putAll((Map)subhistogram.get());
        }
        ArrayList<UnreachableObjectsHistogram.Record> records = new ArrayList<UnreachableObjectsHistogram.Record>();
        for (Record r : histogram.values()) {
            records.add(new UnreachableObjectsHistogram.Record(r.clazz.getName(), r.clazz.getObjectAddress(), r.objectCount, r.size));
        }
        UnreachableObjectsHistogram deadObjectHistogram = new UnreachableObjectsHistogram(records);
        idx.getSnapshotInfo().setProperty(UnreachableObjectsHistogram.class.getName(), (Serializable)deadObjectHistogram);
    }

    private static int markUnreachableAsGCRoots(PreliminaryIndexImpl idx, boolean[] reachable, int noReachableObjects, int extraRootType, IProgressListener listener) {
        int noOfObjects = reachable.length;
        IIndexReader.IOne2LongIndex identifiers = idx.identifiers;
        IIndexReader.IOne2ManyIndex preOutbound = idx.outbound;
        byte[] inbounds = new byte[noOfObjects];
        int ii = 0;
        while (ii < noOfObjects) {
            if (!reachable[ii]) {
                int[] nArray = preOutbound.get(ii);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int out = nArray[n2];
                    if (out != ii && inbounds[out] != -1) {
                        int n3 = out;
                        inbounds[n3] = (byte)(inbounds[n3] + 1);
                    }
                    ++n2;
                }
            }
            ++ii;
        }
        ArrayInt unref = new ArrayInt();
        int ii2 = 0;
        while (ii2 < noOfObjects) {
            if (!reachable[ii2] && inbounds[ii2] == 0) {
                unref.add(ii2);
                XGCRootInfo xgc = new XGCRootInfo(identifiers.get(ii2), 0L, extraRootType);
                xgc.setObjectId(ii2);
                List<XGCRootInfo> xgcs = Collections.singletonList(xgc);
                idx.gcRoots.put(ii2, xgcs);
            }
            ++ii2;
        }
        ObjectMarker marker2 = new ObjectMarker(unref.toArray(), reachable, preOutbound, (IProgressListener)new SilentProgressListener(listener));
        int numProcessors = Runtime.getRuntime().availableProcessors();
        if (numProcessors > 1 && unref.size() > 1) {
            try {
                marker2.markMultiThreaded(numProcessors);
            }
            catch (InterruptedException e) {
                IProgressListener.OperationCanceledException oc = new IProgressListener.OperationCanceledException();
                oc.initCause((Throwable)e);
                throw oc;
            }
            int newNoOfObjects = 0;
            boolean[] blArray = reachable;
            int n = reachable.length;
            int n4 = 0;
            while (n4 < n) {
                boolean b = blArray[n4];
                if (b) {
                    ++newNoOfObjects;
                }
                ++n4;
            }
            noReachableObjects = newNoOfObjects;
        } else {
            int marked2 = marker2.markSingleThreaded();
            noReachableObjects += marked2;
        }
        unref.clear();
        int ii3 = 0;
        while (ii3 < noOfObjects) {
            if (!reachable[ii3]) {
                unref.add(ii3);
            }
            ++ii3;
        }
        int[] root = new int[1];
        ObjectMarker marker = new ObjectMarker(root, reachable, preOutbound, (IProgressListener)new SilentProgressListener(listener));
        int passes = 10;
        int pass = 0;
        while (pass < passes) {
            ArrayInt unref2 = new ArrayInt();
            byte[] outbounds = new byte[noOfObjects];
            for (int ii4 : unref) {
                if (reachable[ii4]) continue;
                unref2.add(ii4);
                int[] nArray = preOutbound.get(ii4);
                int n = nArray.length;
                int n5 = 0;
                while (n5 < n) {
                    int out = nArray[n5];
                    if (out != ii4 && !reachable[out] && outbounds[ii4] != -1) {
                        int n6 = ii4;
                        outbounds[n6] = (byte)(outbounds[n6] + 1);
                    }
                    ++n5;
                }
            }
            unref = unref2;
            IteratorInt it = unref.iterator();
            while (it.hasNext() && noReachableObjects < noOfObjects) {
                int ii4;
                ii4 = it.next();
                if ((ii4 = GarbageCleaner.selectRoot(ii4, pass, passes, reachable, preOutbound, outbounds, inbounds)) < 0) continue;
                root[0] = ii4;
                XGCRootInfo xgc = new XGCRootInfo(identifiers.get(ii4), 0L, extraRootType);
                xgc.setObjectId(ii4);
                List<XGCRootInfo> xgcs = Collections.singletonList(xgc);
                idx.gcRoots.put(ii4, xgcs);
                int marked = marker.markSingleThreaded();
                noReachableObjects += marked;
            }
            ++pass;
        }
        idx.setGcRoots(idx.gcRoots);
        idx.getSnapshotInfo().setNumberOfGCRoots(idx.gcRoots.size());
        return noReachableObjects;
    }

    private static int selectRoot(int ii, int pass, int passes, boolean[] reachable, IIndexReader.IOne2ManyIndex preOutbound, byte[] outbounds, byte[] inbounds) {
        if (reachable[ii]) {
            return -1;
        }
        if (pass == 0) {
            if ((inbounds[ii] & 0xFF) == 1) {
                int[] nArray = preOutbound.get(ii);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int out = nArray[n2];
                    if (out != ii && !reachable[out] && (inbounds[out] & 0xFF) == 1) {
                        int[] nArray2 = preOutbound.get(out);
                        int n3 = nArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int out2 = nArray2[n4];
                            if (out2 == ii) {
                                return ii;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            return -1;
        }
        boolean chooseAsRoot = (outbounds[ii] & 0xFF) > 0 && (pass == passes - 1 || (inbounds[ii] & 0xFF) > 1 && (outbounds[ii] & 0xFF) - (inbounds[ii] & 0xFF) >= passes - pass - 2);
        return chooseAsRoot ? ii : -1;
    }

    private static class CalculateGarbageCleanupForClass
    implements Callable<CleanupWrapper> {
        final PreliminaryIndexImpl idx;
        final boolean[] reachable;
        final int start;
        final int length;

        public CalculateGarbageCleanupForClass(PreliminaryIndexImpl idx, boolean[] reachable, int start, int length) {
            this.idx = idx;
            this.reachable = reachable;
            this.start = start;
            this.length = length;
        }

        @Override
        public CleanupWrapper call() throws Exception {
            HashMap<Integer, CleanupResult> results = new HashMap<Integer, CleanupResult>();
            ArrayList<ClassImpl> classes2remove = new ArrayList<ClassImpl>();
            int ii = this.start;
            while (ii < this.start + this.length) {
                if (!this.reachable[ii]) {
                    long arraySize;
                    int classId = this.idx.object2classId.get(ii);
                    ClassImpl clazz = (ClassImpl)this.idx.classesById.get(classId);
                    CleanupResult cr = results.get(classId);
                    if (cr == null) {
                        cr = new CleanupResult(clazz);
                        results.put(classId, cr);
                    }
                    if ((arraySize = this.idx.array2size.getSize(ii)) > 0L) {
                        ++cr.count;
                        cr.size += arraySize;
                    } else {
                        ClassImpl c = (ClassImpl)this.idx.classesById.get(ii);
                        if (c == null) {
                            ++cr.count;
                            cr.size += clazz.getHeapSizePerInstance();
                        } else {
                            ++cr.count;
                            cr.size += c.getUsedHeapSize();
                            classes2remove.add(c);
                        }
                    }
                }
                ++ii;
            }
            return new CleanupWrapper(results, classes2remove);
        }
    }

    private static class CleanupResult {
        int count = 0;
        long size = 0L;
        final ClassImpl clazz;

        public CleanupResult(ClassImpl clazz) {
            this.clazz = clazz;
        }
    }

    private static class CleanupWrapper {
        final HashMap<Integer, CleanupResult> results;
        final List<ClassImpl> classes2remove;

        public CleanupWrapper(HashMap<Integer, CleanupResult> results, List<ClassImpl> classes2remove) {
            this.results = results;
            this.classes2remove = classes2remove;
        }
    }

    private static class CreateHistogramOfUnreachableObjectsChunk
    implements Callable<HashMap<Integer, Record>> {
        final PreliminaryIndexImpl idx;
        final boolean[] reachable;
        final int start;
        final int length;

        public CreateHistogramOfUnreachableObjectsChunk(PreliminaryIndexImpl idx, boolean[] reachable, int start, int length) {
            this.idx = idx;
            this.reachable = reachable;
            this.start = start;
            this.length = length;
        }

        @Override
        public HashMap<Integer, Record> call() {
            IIndexReader.IOne2SizeIndex array2size = this.idx.array2size;
            HashMap<Integer, Record> histogram = new HashMap<Integer, Record>(this.length);
            int ii = this.start;
            while (ii < this.start + this.length) {
                if (!this.reachable[ii]) {
                    long s;
                    int classId = this.idx.object2classId.get(ii);
                    Record r = histogram.get(classId);
                    if (r == null) {
                        r = new Record((ClassImpl)this.idx.classesById.get(classId));
                        histogram.put(classId, r);
                    }
                    if ((s = array2size.getSize(ii)) <= 0L) {
                        ClassImpl classImpl;
                        s = "java.lang.Class".equals(r.clazz.getName()) ? ((classImpl = (ClassImpl)this.idx.classesById.get(ii)) == null ? r.clazz.getHeapSizePerInstance() : classImpl.getUsedHeapSize()) : r.clazz.getHeapSizePerInstance();
                    }
                    r.size += s;
                    ++r.objectCount;
                }
                ++ii;
            }
            return histogram;
        }
    }

    private static class KeyWriterImpl
    implements IndexWriter.KeyWriter {
        HashMapIntObject<ClassImpl> classesByNewId;

        KeyWriterImpl(HashMapIntObject<ClassImpl> classesByNewId) {
            this.classesByNewId = classesByNewId;
        }

        @Override
        public void storeKey(int index, Serializable key) {
            ClassImpl impl = (ClassImpl)this.classesByNewId.get(index);
            impl.setCacheEntry(key);
        }
    }

    private static abstract class NewObjectIntIterator
    extends NewObjectIterator
    implements IteratorInt {
        private NewObjectIntIterator() {
        }

        public int next() {
            int answer = this.doGetNextInt(this.nextIndex);
            this.findNext();
            return answer;
        }

        abstract int doGetNextInt(int var1);
    }

    private static abstract class NewObjectIterator {
        int nextIndex = -1;
        int[] $map = this.getMap();

        public NewObjectIterator() {
            this.findNext();
        }

        protected void findNext() {
            ++this.nextIndex;
            while (this.nextIndex < this.$map.length && this.$map[this.nextIndex] < 0) {
                ++this.nextIndex;
            }
        }

        public boolean hasNext() {
            return this.nextIndex < this.$map.length;
        }

        abstract int[] getMap();
    }

    private static final class Record {
        ClassImpl clazz;
        int objectCount;
        long size;

        public Record(ClassImpl clazz) {
            this.clazz = clazz;
        }
    }
}

