/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.compiler.adaptor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.objectteams.otdt.core.ext.OTJavaNature;

public class ProjectUtil {
    static final String PLUGIN_ID = "org.eclipse.objectteams.otdt.internal.compiler.adaptor";
    static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";

    public static IProject safeGetOTPluginProject(ICompilationUnit unitElem) {
        IJavaProject project = unitElem.getJavaProject();
        if (ProjectUtil.isOTPluginProject(project.getProject())) {
            return project.getProject();
        }
        return null;
    }

    public static boolean isOTPluginProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            return project.hasNature(PLUGIN_NATURE) && OTJavaNature.hasOTJavaNature((IProject)project);
        }
        catch (CoreException e) {
            if (!" ".equals(project.getName())) {
                JavaCore.getJavaCore().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error reading project natures", (Throwable)e));
            }
            return false;
        }
    }
}

