/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteEntryState;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PaletteUtil;
import org.eclipse.ui.IMemento;

public class PapyrusPaletteEntryState
extends PaletteEntryState {
    public static final String PARENT_ID_KEY = "parent";
    protected String parentID;

    public PapyrusPaletteEntryState(PaletteEntry entry) {
        super(entry);
    }

    public void applyChangesFromMemento(IMemento entryMemento) {
        super.applyChangesFromMemento(entryMemento);
        PaletteEntry entry = this.getPaletteEntry();
        String sValue = entryMemento.getString(PARENT_ID_KEY);
        if (sValue != null && !entry.getParent().getId().equals(sValue)) {
            PaletteContainer container = PaletteUtil.getContainerByID(entry, sValue);
            container.add(entry);
        }
    }

    public void rollback() {
        super.rollback();
        PaletteEntry entry = this.getPaletteEntry();
        entry.setParent(PaletteUtil.getContainerByID(entry, this.parentID));
    }

    public void storeChangesInMemento(IMemento memento) {
        super.storeChangesInMemento(memento);
        PaletteEntry entry = this.getPaletteEntry();
        if (this.parentID != null && !this.parentID.equals(entry.getParent().getId()) || this.parentID == null && entry.getParent() != null) {
            memento.putString(PARENT_ID_KEY, entry.getParent().getId());
        }
    }

    public void storeState() {
        super.storeState();
        PaletteEntry entry = this.getPaletteEntry();
        this.parentID = entry.getParent().getId();
    }
}

