/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ComboSelectionRule
extends GenerationSimpleRule {
    private String newSelection;
    private int newSelectionIndex;
    private int index;
    private Combo combo;

    @Override
    public boolean appliesTo(Event event) {
        if (!(event.widget instanceof Combo)) {
            return false;
        }
        Combo combo = (Combo)event.widget;
        return event.type == 13 && Arrays.asList(combo.getItems()).contains(combo.getText());
    }

    @Override
    public void initializeForEvent(Event event) {
        this.combo = (Combo)event.widget;
        this.newSelection = this.combo.getText();
        this.newSelectionIndex = this.combo.getSelectionIndex();
        this.index = WidgetUtils.getIndex((Control)this.combo);
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder res = new StringBuilder();
        if (this.index != 0) {
            res.append("bot.comboBox(" + this.index + ")");
        } else {
            res.append("bot.comboBox()");
        }
        res.append(".setSelection(");
        if (this.newSelection != null) {
            res.append('\"');
            res.append(this.newSelection);
            res.append("\")");
        } else {
            res.append(this.newSelectionIndex);
            res.append(")");
        }
        actions.add(res.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    public Combo getWidget() {
        return this.combo;
    }
}

