/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.tags.TagContentAssistProcessor;
import org.eclipse.team.internal.ccvs.ui.tags.TagRefreshButtonArea;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ccvs.ui.wizards.MergeWizard;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.PlatformUI;

public class MergeWizardPage
extends CVSWizardPage {
    private Text endTagField;
    private Button endTagBrowseButton;
    private TagSource tagSource;
    private Text startTagField;
    private Button startTagBrowseButton;
    private TagRefreshButtonArea tagRefreshArea;
    private CVSTag startTag;
    private CVSTag endTag;
    private Button previewButton;
    private Button noPreviewButton;
    protected boolean preview = true;
    private Button onlyPreviewConflicts;
    private boolean isOnlyPreviewConflicts = false;

    public MergeWizardPage(String pageName, String title, ImageDescriptor titleImage, String description, TagSource tagSource) {
        super(pageName, title, titleImage, description);
        this.tagSource = tagSource;
    }

    public void createControl(Composite parent) {
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)-1));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.merge_wizard_page_context");
        Composite mainArea = new Composite(composite, 0);
        mainArea.setLayoutData((Object)SWTUtils.createHFillGridData());
        mainArea.setLayout((Layout)SWTUtils.createGridLayout((int)2, (PixelConverter)converter, (int)0));
        this.createEndTagArea(mainArea);
        this.createStartTagArea(mainArea);
        SWTUtils.equalizeControls((PixelConverter)converter, (Control[])new Button[]{this.endTagBrowseButton, this.startTagBrowseButton});
        this.createPreviewOptionArea(composite, converter);
        this.createTagRefreshArea(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private void createPreviewOptionArea(Composite parent, PixelConverter converter) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SWTUtils.createHFillGridData());
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)0));
        this.previewButton = SWTUtils.createRadioButton((Composite)composite, (String)CVSUIMessages.MergeWizardPage_0);
        if (MergeWizard.isShowModelSync()) {
            this.onlyPreviewConflicts = SWTUtils.createCheckBox((Composite)composite, (String)CVSUIMessages.MergeWizardPage_14);
            GridData data = SWTUtils.createHFillGridData((int)1);
            data.horizontalIndent = 10;
            this.onlyPreviewConflicts.setLayoutData((Object)data);
        }
        this.noPreviewButton = SWTUtils.createRadioButton((Composite)composite, (String)CVSUIMessages.MergeWizardPage_1);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeWizardPage.this.preview = MergeWizardPage.this.previewButton.getSelection();
                MergeWizardPage.this.updateEnablements();
            }
        };
        this.previewButton.setSelection(this.preview);
        this.noPreviewButton.setSelection(!this.preview);
        this.previewButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.noPreviewButton.addSelectionListener((SelectionListener)selectionAdapter);
        if (this.onlyPreviewConflicts != null) {
            this.onlyPreviewConflicts.setEnabled(this.preview);
            this.onlyPreviewConflicts.setSelection(this.isOnlyPreviewConflicts);
            this.onlyPreviewConflicts.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MergeWizardPage.this.isOnlyPreviewConflicts = MergeWizardPage.this.onlyPreviewConflicts.getSelection();
                }
            });
        }
    }

    private void createTagRefreshArea(Composite composite) {
        this.tagRefreshArea = new TagRefreshButtonArea(this.getShell(), this.getTagSource(), null){

            @Override
            public void refresh(boolean background) {
                super.refresh(background);
                MergeWizardPage.this.updateStartTag(MergeWizardPage.this.startTagField.getText());
                MergeWizardPage.this.updateEndTag(MergeWizardPage.this.endTagField.getText());
            }
        };
        this.tagRefreshArea.setRunnableContext((IRunnableContext)this.getContainer());
        this.tagRefreshArea.createArea(composite);
    }

    private void createEndTagArea(Composite parent) {
        SWTUtils.createLabel((Composite)parent, (String)CVSUIMessages.MergeWizardPage_2, (int)2);
        this.endTagField = SWTUtils.createText((Composite)parent);
        this.endTagField.addModifyListener(e -> this.updateEndTag(this.endTagField.getText()));
        TagContentAssistProcessor.createContentAssistant(this.endTagField, this.tagSource, 13);
        this.endTagBrowseButton = this.createPushButton(parent, CVSUIMessages.MergeWizardPage_3);
        this.endTagBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagSelectionDialog dialog = new TagSelectionDialog(MergeWizardPage.this.getShell(), MergeWizardPage.this.getTagSource(), CVSUIMessages.MergeWizardPage_4, CVSUIMessages.MergeWizardPage_5, 13, false, "org.eclipse.team.cvs.ui.merge_end_page_context");
                if (dialog.open() == 0) {
                    CVSTag selectedTag = dialog.getResult();
                    MergeWizardPage.this.setEndTag(selectedTag);
                }
            }
        });
    }

    private void createStartTagArea(Composite parent) {
        SWTUtils.createLabel((Composite)parent, (String)CVSUIMessages.MergeWizardPage_6, (int)2);
        this.startTagField = SWTUtils.createText((Composite)parent);
        this.startTagField.addModifyListener(e -> this.updateStartTag(this.startTagField.getText()));
        TagContentAssistProcessor.createContentAssistant(this.startTagField, this.tagSource, 8);
        this.startTagBrowseButton = this.createPushButton(parent, CVSUIMessages.MergeWizardPage_7);
        this.startTagBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagSelectionDialog dialog = new TagSelectionDialog(MergeWizardPage.this.getShell(), MergeWizardPage.this.getTagSource(), CVSUIMessages.MergeWizardPage_8, CVSUIMessages.MergeWizardPage_9, 24, false, "org.eclipse.team.cvs.ui.merge_start_page_context");
                if (dialog.open() == 0) {
                    CVSTag selectedTag = dialog.getResult();
                    MergeWizardPage.this.setStartTag(selectedTag);
                }
            }
        });
    }

    protected void updateEndTag(String text) {
        if (this.endTag == null || !this.endTag.getName().equals(text)) {
            CVSTag tag = this.getTagFor(text, false);
            this.setEndTag(tag);
        }
        this.updateEnablements();
    }

    protected void updateStartTag(String text) {
        if (this.startTag == null || !this.startTag.getName().equals(text)) {
            CVSTag tag = this.getTagFor(text, true);
            this.setStartTag(tag);
        }
        this.updateEnablements();
    }

    private CVSTag getTagFor(String text, boolean versionsOnly) {
        if (text.equals(CVSTag.DEFAULT.getName())) {
            if (versionsOnly) {
                return null;
            }
            return CVSTag.DEFAULT;
        }
        if (text.equals(CVSTag.BASE.getName())) {
            if (versionsOnly) {
                return null;
            }
            return CVSTag.BASE;
        }
        CVSTag[] tags = versionsOnly ? this.tagSource.getTags(new int[]{2, 3}) : this.tagSource.getTags(new int[]{2, 1, 3});
        CVSTag[] cVSTagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            CVSTag tag = cVSTagArray[n2];
            if (tag.getName().equals(text)) {
                return tag;
            }
            ++n2;
        }
        return null;
    }

    protected void setEndTag(CVSTag selectedTag) {
        if (selectedTag == null || this.endTag == null || !this.endTag.equals((Object)selectedTag)) {
            this.endTag = selectedTag;
            if (this.endTagField != null) {
                CVSTag tag;
                String name = this.endTagField.getText();
                if (this.endTag != null) {
                    name = this.endTag.getName();
                }
                if (!this.endTagField.getText().equals(name)) {
                    this.endTagField.setText(name);
                }
                if (this.startTag == null && this.endTag != null && this.endTag.getType() == 1 && (tag = this.findCommonBaseTag(this.endTag)) != null) {
                    this.setStartTag(tag);
                }
            }
            this.updateEnablements();
        }
    }

    protected void setStartTag(CVSTag selectedTag) {
        if (selectedTag == null || this.startTag != null || this.endTag == null || !this.endTag.equals((Object)selectedTag)) {
            this.startTag = selectedTag;
            if (this.startTagField != null) {
                String name = this.startTagField.getText();
                if (this.startTag != null) {
                    name = this.startTag.getName();
                }
                if (!this.startTagField.getText().equals(name)) {
                    this.startTagField.setText(name);
                }
            }
            this.updateEnablements();
        }
    }

    private CVSTag findCommonBaseTag(CVSTag tag) {
        CVSTag[] tags;
        CVSTag[] cVSTagArray = tags = this.tagSource.getTags(2);
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            CVSTag potentialMatch = cVSTagArray[n2];
            if (potentialMatch.getName().contains(tag.getName())) {
                return potentialMatch;
            }
            ++n2;
        }
        return null;
    }

    private void updateEnablements() {
        if (this.onlyPreviewConflicts != null) {
            this.onlyPreviewConflicts.setEnabled(this.preview);
        }
        if (this.endTag == null && this.endTagField.getText().length() > 0) {
            this.setErrorMessage(CVSUIMessages.MergeWizardPage_10);
        } else if (this.startTag == null && this.startTagField.getText().length() > 0) {
            this.setErrorMessage(CVSUIMessages.MergeWizardPage_11);
        } else if (this.endTag != null && this.startTag != null && this.startTag.equals((Object)this.endTag)) {
            this.setErrorMessage(CVSUIMessages.MergeWizardPage_12);
        } else if (this.startTag == null && this.endTag != null && this.preview) {
            this.setErrorMessage(CVSUIMessages.MergeWizardPage_13);
        } else {
            this.setErrorMessage(null);
        }
        this.setPageComplete(!(this.startTag == null && this.preview || this.endTag == null || this.startTag != null && this.startTag.equals((Object)this.endTag)));
    }

    protected TagSource getTagSource() {
        return this.tagSource;
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setLayoutData((Object)new GridData(4, 128, false, false));
        return button;
    }

    public CVSTag getStartTag() {
        return this.startTag;
    }

    public CVSTag getEndTag() {
        return this.endTag;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public boolean isOnlyPreviewConflicts() {
        return this.isOnlyPreviewConflicts;
    }
}

