/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.dred;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.ITcRelation;

public class DRedTcRelation<V>
implements ITcRelation<V> {
    private Map<V, Set<V>> tuplesForward = new HashMap<V, Set<V>>();
    private Map<V, Set<V>> tuplesBackward = new HashMap<V, Set<V>>();

    public void clear() {
        this.tuplesForward.clear();
        this.tuplesBackward.clear();
    }

    public boolean isEmpty() {
        return this.tuplesForward.isEmpty();
    }

    public void removeTuple(V source, V target) {
        Set<V> tSet;
        Set<V> sSet = this.tuplesForward.get(source);
        if (sSet != null) {
            sSet.remove(target);
            if (sSet.size() == 0) {
                this.tuplesForward.remove(source);
            }
        }
        if ((tSet = this.tuplesBackward.get(target)) != null) {
            tSet.remove(source);
            if (tSet.size() == 0) {
                this.tuplesBackward.remove(target);
            }
        }
    }

    public boolean addTuple(V source, V target) {
        Set<V> sSet = this.tuplesForward.get(source);
        if (sSet == null) {
            HashSet<V> newSet = new HashSet<V>();
            newSet.add(target);
            this.tuplesForward.put(source, newSet);
        } else {
            sSet.add(target);
        }
        Set<V> tSet = this.tuplesBackward.get(target);
        if (tSet == null) {
            HashSet<V> newSet = new HashSet<V>();
            newSet.add(source);
            this.tuplesBackward.put(target, newSet);
            return true;
        }
        boolean ret = tSet.add(source);
        return ret;
    }

    public void union(DRedTcRelation<V> rA) {
        for (V source : rA.tuplesForward.keySet()) {
            for (V target : rA.tuplesForward.get(source)) {
                this.addTuple(source, target);
            }
        }
    }

    public void difference(DRedTcRelation<V> rA) {
        for (V source : rA.tuplesForward.keySet()) {
            for (V target : rA.tuplesForward.get(source)) {
                this.removeTuple(source, target);
            }
        }
    }

    @Override
    public Set<V> getTupleEnds(V source) {
        Set<V> t = this.tuplesForward.get(source);
        return t == null ? new HashSet() : new HashSet<V>(t);
    }

    public Set<V> getTupleStarts(V target) {
        Set<V> t = this.tuplesBackward.get(target);
        return t == null ? new HashSet() : new HashSet<V>(t);
    }

    @Override
    public Set<V> getTupleStarts() {
        Set<V> t = this.tuplesForward.keySet();
        return new HashSet<V>(t);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TcRelation = ");
        for (Map.Entry<V, Set<V>> entry : this.tuplesForward.entrySet()) {
            V source = entry.getKey();
            for (V target : entry.getValue()) {
                sb.append("(" + source + "," + target + ") ");
            }
        }
        return sb.toString();
    }

    public boolean containsTuple(V source, V target) {
        return this.tuplesForward.containsKey(source) && this.tuplesForward.get(source).contains(target);
    }

    public boolean equals(Object obj) {
        V source;
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DRedTcRelation aTR = (DRedTcRelation)obj;
        for (Map.Entry<V, Set<V>> entry : aTR.tuplesForward.entrySet()) {
            source = entry.getKey();
            for (V target : entry.getValue()) {
                if (this.containsTuple(source, target)) continue;
                return false;
            }
        }
        for (Map.Entry<V, Set<V>> entry : this.tuplesForward.entrySet()) {
            source = entry.getKey();
            for (V target : entry.getValue()) {
                if (aTR.containsTuple(source, target)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.tuplesForward.hashCode();
        hash = 31 * hash + this.tuplesBackward.hashCode();
        return hash;
    }

    public Map<V, Set<V>> getTuplesForward() {
        return this.tuplesForward;
    }
}

