/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.misc;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.viatra.query.runtime.rete.network.BaseNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.BehaviorChangingMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public abstract class SimpleReceiver
extends BaseNode
implements Receiver {
    protected Supplier parent = null;
    protected final Mailbox mailbox = this.instantiateMailbox();

    public SimpleReceiver(ReteContainer reteContainer) {
        super(reteContainer);
        reteContainer.registerClearable(this.mailbox);
    }

    protected Mailbox instantiateMailbox() {
        if (this.reteContainer.isDifferentialDataFlowEvaluation()) {
            return new TimelyMailbox(this, this.reteContainer);
        }
        return new BehaviorChangingMailbox(this, this.reteContainer);
    }

    @Override
    public Mailbox getMailbox() {
        return this.mailbox;
    }

    @Override
    public void appendParent(Supplier supplier) {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Illegal RETE edge: " + this + " already has a parent (" + this.parent + ") and cannot connect to additional parent (" + supplier + ") as it is not a Uniqueness Enforcer Node. ");
        }
        this.parent = supplier;
    }

    @Override
    public void removeParent(Supplier supplier) {
        if (this.parent != supplier) {
            throw new IllegalArgumentException("Illegal RETE edge removal: the parent of " + this + " is not " + supplier);
        }
        this.parent = null;
    }

    @Override
    public Collection<Supplier> getParents() {
        if (this.parent == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.parent);
    }

    public void disconnectFromNetwork() {
        if (this.parent != null) {
            this.reteContainer.disconnect(this.parent, this);
        }
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateFromStandardNodeToSupplierParent() && this.parent != null) {
            this.parent.acceptPropagatedTraceInfo(traceInfo);
        }
    }
}

