/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.beans;

import java.util.Collections;
import java.util.List;
import org.eclipse.wb.internal.core.databinding.model.IObserveDecoration;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.IObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.presentation.SimpleObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.reference.StringReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.ui.decorate.IObserveDecorator;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.SeparatorUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.ElPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ElPropertyUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ElPropertyUiConfiguration;
import org.eclipse.wb.internal.swing.databinding.ui.providers.TypeImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElPropertyObserveInfo
extends ObserveInfo
implements IObserveDecoration {
    private static final ElPropertyUiConfiguration CONFIGURATION = new ElPropertyUiConfiguration();
    private final ObserveInfo m_parent;
    private final IObservePresentation m_presentation;

    public ElPropertyObserveInfo(ObserveInfo parent, IGenericType objectType) {
        super(objectType, StringReferenceProvider.EMPTY);
        this.m_parent = parent instanceof BeanPropertyObserveInfo ? parent : null;
        this.m_presentation = new SimpleObservePresentation("<EL Expression>", "${XXX}", TypeImageProvider.EL_PROPERTY_IMAGE);
    }

    public ObserveType getType() {
        return null;
    }

    @Override
    public ObserveCreationType getCreationType() {
        return ObserveCreationType.AnyProperty;
    }

    @Override
    public PropertyInfo createProperty(ObserveInfo observeObject) throws Exception {
        return new ElPropertyInfo(observeObject.getObjectType(), ClassGenericType.OBJECT_CLASS, this.m_parent == null ? null : this.m_parent.createProperty(observeObject), "");
    }

    public IObserveInfo getParent() {
        return this.m_parent;
    }

    public List<IObserveInfo> getChildren(IObserveInfo.ChildrenContext context) {
        return Collections.emptyList();
    }

    public IObservePresentation getPresentation() {
        return this.m_presentation;
    }

    public IObserveDecorator getDecorator() {
        return IObserveDecorator.BOLD;
    }

    @Override
    public void createContentProviders(List<IUiContentProvider> providers, ObserveInfo observeObject, PropertyInfo observeAstProperty) throws Exception {
        providers.add(new ElPropertyUiContentProvider(CONFIGURATION, (ElPropertyInfo)observeAstProperty));
        providers.add((IUiContentProvider)new SeparatorUiContentProvider());
    }
}

