/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.lang.reflect.Field;
import java.util.HashSet;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CatchAll;
import org.eclipse.bpel.model.CompensateScope;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.Else;
import org.eclipse.bpel.model.ElseIf;
import org.eclipse.bpel.model.Empty;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.If;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.MessageExchanges;
import org.eclipse.bpel.model.OnAlarm;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.RepeatUntil;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Throw;
import org.eclipse.bpel.model.Validate;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.model.Wait;
import org.eclipse.bpel.model.While;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyViewer;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BPELTabbedPropertySheetPage
extends TabbedPropertySheetPage {
    protected BPELEditor editor;
    protected TabbedPropertyViewer viewer;
    protected TabbedPropertyRegistry registry;

    public BPELTabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor, BPELEditor editor) {
        super(tabbedPropertySheetPageContributor);
        this.editor = editor;
    }

    public BPELEditor getEditor() {
        return this.editor;
    }

    public TabbedPropertyViewer getTabbedPropertyViewer() {
        if (this.viewer == null) {
            try {
                Field field = TabbedPropertySheetPage.class.getDeclaredField("tabbedPropertyViewer");
                field.setAccessible(true);
                this.viewer = (TabbedPropertyViewer)field.get((Object)this);
            }
            catch (Exception e) {
                BPELUIPlugin.log(e);
            }
        }
        return this.viewer;
    }

    public void setBPELEditorActions() {
        IPageSite pageSite = this.getSite();
        IActionBars actionBars = pageSite.getActionBars();
        String id = ActionFactory.REVERT.getId();
        IAction action = this.editor.getActionRegistry().getAction((Object)id);
        actionBars.setGlobalActionHandler(id, action);
        id = ActionFactory.UNDO.getId();
        action = this.editor.getActionRegistry().getAction((Object)id);
        actionBars.setGlobalActionHandler(id, action);
        id = ActionFactory.REDO.getId();
        action = this.editor.getActionRegistry().getAction((Object)id);
        actionBars.setGlobalActionHandler(id, action);
        actionBars.updateActionBars();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.setBPELEditorActions();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            return;
        }
        selection = this.calculateSelection(selection);
        super.selectionChanged(part, selection);
    }

    protected ISelection calculateSelection(ISelection selection) {
        HashSet newSet = new HashSet();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                if (o instanceof EditPart) {
                    o = ((EditPart)o).getModel();
                }
                if (this.editor.getMultipageEditor().getActiveEditor() == this.editor.getMultipageEditor().getTextEditor()) {
                    while (o != null && o instanceof EObject && !this.hasPropertySheetPage(o)) {
                        o = ((EObject)o).eContainer();
                    }
                }
                newSet.add(o);
            }
        }
        return new StructuredSelection(newSet.toArray(new Object[newSet.size()]));
    }

    private boolean hasPropertySheetPage(Object o) {
        return o instanceof Activity || o instanceof Assign || o instanceof Catch || o instanceof CatchAll || o instanceof CompensateScope || o instanceof CorrelationSet || o instanceof Else || o instanceof ElseIf || o instanceof Empty || o instanceof ForEach || o instanceof If || o instanceof Invoke || o instanceof Link || o instanceof MessageExchange || o instanceof MessageExchanges || o instanceof OnAlarm || o instanceof OnEvent || o instanceof OnMessage || o instanceof PartnerLink || o instanceof PartnerLinks || o instanceof Pick || o instanceof Process || o instanceof Receive || o instanceof RepeatUntil || o instanceof Reply || o instanceof Scope || o instanceof Throw || o instanceof Validate || o instanceof Variable || o instanceof Variables || o instanceof Wait || o instanceof While;
    }

    protected TabbedPropertyRegistry getRegistry() {
        if (this.registry == null) {
            try {
                Field field = TabbedPropertySheetPage.class.getDeclaredField("registry");
                field.setAccessible(true);
                this.registry = (TabbedPropertyRegistry)field.get((Object)this);
            }
            catch (Exception e) {
                BPELUIPlugin.log(e);
            }
        }
        return this.registry;
    }
}

