/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDTempObjectImpl
extends AbstractCDOID
implements CDOIDTemp {
    private static final long serialVersionUID = 1L;
    private static final IntInterner INTERNER = new IntInterner();
    private final int value;

    private CDOIDTempObjectImpl(int value) {
        CheckUtil.checkArg((value != 0 ? 1 : 0) != 0, (String)"Zero not allowed");
        this.value = value;
    }

    private CDOIDTempObjectImpl() {
        this.value = 0;
    }

    public int getIntValue() {
        return this.value;
    }

    @Override
    public void write(CDODataOutput out) throws IOException {
        out.writeXInt(this.value);
    }

    @Override
    public String toURIFragment() {
        return String.valueOf(this.value);
    }

    @Override
    public CDOID.Type getType() {
        return CDOID.Type.TEMP_OBJECT;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public int hashCode() {
        return ObjectUtil.hashCode((long)this.value);
    }

    @Override
    public String toString() {
        return "oid" + this.value;
    }

    @Override
    protected int doCompareTo(CDOID o) throws ClassCastException {
        CDOIDTempObjectImpl that = (CDOIDTempObjectImpl)o;
        if (this.value < that.value) {
            return -1;
        }
        if (this.value > that.value) {
            return 1;
        }
        return 0;
    }

    private static int getHashCode(int value) {
        return value;
    }

    public static CDOIDTempObjectImpl create(int value) {
        return INTERNER.intern(value);
    }

    public static CDOIDTempObjectImpl create(CDODataInput in) throws IOException {
        int value = in.readXInt();
        return CDOIDTempObjectImpl.create(value);
    }

    public static CDOIDTempObjectImpl create(String fragmentPart) {
        int value = Integer.parseInt(fragmentPart);
        return CDOIDTempObjectImpl.create(value);
    }

    /* synthetic */ CDOIDTempObjectImpl(int n, CDOIDTempObjectImpl cDOIDTempObjectImpl) {
        this(n);
    }

    private static final class IntInterner
    extends Interner<CDOIDTempObjectImpl> {
        private IntInterner() {
        }

        public synchronized CDOIDTempObjectImpl intern(int value) {
            int hashCode = CDOIDTempObjectImpl.getHashCode(value);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDTempObjectImpl id = (CDOIDTempObjectImpl)entry.get();
                if (id != null && id.value == value) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDTempObjectImpl id = new CDOIDTempObjectImpl(value, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDTempObjectImpl id) {
            return CDOIDTempObjectImpl.getHashCode(id.value);
        }
    }
}

