/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marcel Bruch - initial API and implementation.
 */
package org.eclipse.epp.internal.logging.aeri.ide.custom;

import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.impl.IdeFactoryImpl;

public class CustomModelFactory extends IdeFactoryImpl {

    @Override
    public IServerDescriptor createServerDescriptor() {
        return new CustomServerDescriptor();
    }

    @Override
    public IProcessorDescriptor createProcessorDescriptor() {
        return new CustomProcessorDescriptor();
    }

}
