/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.single;

import java.util.Map;
import org.eclipse.jst.pagedesigner.commands.single.SingleNodeCommand;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class ChangeAttributeCommand
extends SingleNodeCommand {
    private IDOMElement _element;
    private String _attrValue;
    private String _attrName;
    private Map _attributes;
    private boolean _keepEmptyAttribute = false;

    public ChangeAttributeCommand(String label, IDOMElement node, String attrName, String attrValue) {
        super(label, node);
        this._element = node;
        this._attrName = attrName;
        this._attrValue = attrValue;
        this._attributes = null;
    }

    public ChangeAttributeCommand(String label, IDOMElement node, Map attributes) {
        super(label, node);
        this._element = node;
        this._attributes = attributes;
        this._attrName = null;
        this._attrValue = null;
    }

    protected void doExecute() {
        if (this._attrName != null) {
            this.updateElement(this._attrName, this._attrValue);
        } else if (this._attributes != null) {
            for (String name : this._attributes.keySet()) {
                String value = (String)this._attributes.get(name);
                if (this.isSameValue(value, this._element.getAttribute(name))) continue;
                this.updateElement(name, value);
            }
        }
    }

    private void updateElement(String name, String value) {
        if (this._element.hasAttribute(name) && this.isEmptyString(value) && !this._keepEmptyAttribute) {
            this._element.removeAttribute(name);
        }
        if (!this.isEmptyString(value) || this._keepEmptyAttribute) {
            this._element.setAttribute(name, value);
        }
    }

    private boolean isSameValue(String value1, String value2) {
        value1 = value1 == null ? "" : value1;
        value2 = value2 == null ? "" : value2;
        return value1.equals(value2);
    }

    private boolean isEmptyString(String str) {
        return str == null || str.equals("");
    }

    public boolean isKeepEmptyAttribute() {
        return this._keepEmptyAttribute;
    }

    public void setKeepEmptyAttribute(boolean keepEmptyAttribute) {
        this._keepEmptyAttribute = keepEmptyAttribute;
    }
}

