/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileRevisionEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput {
    private final IFileRevision fileRevision;
    private final IProgressMonitor runningMonitor;

    public FileRevisionEditorInput(IFileRevision fileRevision, IProgressMonitor monitor) {
        this.fileRevision = fileRevision;
        this.runningMonitor = monitor;
    }

    public IStorage getStorage() {
        try {
            return this.fileRevision.getStorage(this.runningMonitor);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.reviews.ui", "Cannot retrieve file revision contents from local repository, defaulting to review contents instead"));
            return null;
        }
    }

    public boolean exists() {
        return this.fileRevision.exists();
    }

    public String getName() {
        return this.fileRevision.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fileRevision.getURI().getPath();
    }

    public boolean equals(Object aObject) {
        if (aObject == this) {
            return true;
        }
        if (aObject instanceof FileRevisionEditorInput) {
            FileRevisionEditorInput other = (FileRevisionEditorInput)((Object)aObject);
            return other.fileRevision.equals(this.fileRevision);
        }
        return false;
    }

    public int hashCode() {
        return this.fileRevision.hashCode();
    }

    public IFileRevision getFileRevision() {
        return this.fileRevision;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.fileRevision.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }
}

