/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class CompositionProperty
extends AbstractProperty {
    protected final @NonNull EReference eContainmentFeature;
    protected final @NonNull PropertyId propertyId;

    public CompositionProperty(@NonNull EReference eContainmentFeature, @NonNull PropertyId propertyId) {
        this.eContainmentFeature = eContainmentFeature;
        this.propertyId = propertyId;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        EObject eObject = CompositionProperty.asNavigableObject(sourceValue, (Object)this.eContainmentFeature, executor);
        EObject eContainer = eObject.eContainer();
        if (eContainer == null) {
            return null;
        }
        EReference eContainmentFeature = ClassUtil.nonNullModel(eObject.eContainmentFeature());
        if (eContainmentFeature != this.eContainmentFeature && !this.isReferenced(eContainmentFeature)) {
            return null;
        }
        return executor.getIdResolver().boxedValueOf(eContainer);
    }

    protected boolean isReferenced(EReference eObject) {
        EAnnotation eAnnotation = eObject.getEAnnotation("subsets");
        if (eAnnotation == null) {
            return false;
        }
        for (EObject eReference : eAnnotation.getReferences()) {
            if (eReference == this.eContainmentFeature) {
                return true;
            }
            if (!(eReference instanceof EReference) || !this.isReferenced((EReference)eReference)) continue;
            return true;
        }
        return false;
    }
}

