/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies.LinksLFConnectionEndPointEditPolicy;
import org.eclipse.swt.graphics.Color;

public class DebugShowConnectionEndPointsAndAnchorsEditPolicy
extends LinksLFConnectionEndPointEditPolicy {
    private FeedbackBase mySourceAnchor;
    private FeedbackBase myTargetAnchor;
    private List<FeedbackBase> myRoutingConstraint;

    protected void showAnchors() {
        if (this.mySourceAnchor == null) {
            this.mySourceAnchor = this.createSourceAnchorFocus();
        }
        this.addFeedback((IFigure)this.mySourceAnchor);
        if (this.myTargetAnchor == null) {
            this.myTargetAnchor = this.createTargetAnchorFocus();
        }
        this.addFeedback((IFigure)this.myTargetAnchor);
    }

    protected void showRouting() {
        if (this.myRoutingConstraint == null) {
            this.myRoutingConstraint = new LinkedList<FeedbackBase>();
            if (this.getConnection().getRoutingConstraint() instanceof List) {
                List bendpoints = (List)this.getConnection().getRoutingConstraint();
                int i = 1;
                while (i < bendpoints.size() - 1) {
                    RoutingBendpointFeedback feedback = new RoutingBendpointFeedback(this.getConnection(), i);
                    this.myRoutingConstraint.add(feedback);
                    this.addFeedback((IFigure)feedback);
                    ++i;
                }
            }
        }
    }

    protected void showSelection() {
        super.showSelection();
        this.showAnchors();
        this.showRouting();
    }

    protected void hideSelection() {
        this.hideRouting();
        this.hideAnchors();
        super.hideSelection();
    }

    protected void hideAnchors() {
        if (this.mySourceAnchor != null) {
            this.removeFeedback((IFigure)this.mySourceAnchor);
            this.mySourceAnchor = null;
        }
        if (this.myTargetAnchor != null) {
            this.removeFeedback((IFigure)this.myTargetAnchor);
            this.myTargetAnchor = null;
        }
    }

    protected void hideRouting() {
        if (this.myRoutingConstraint != null) {
            for (FeedbackBase next : this.myRoutingConstraint) {
                this.removeFeedback((IFigure)next);
            }
            this.myRoutingConstraint = null;
        }
    }

    private SourceAnchorFeedback createSourceAnchorFocus() {
        return new SourceAnchorFeedback(this.getConnection());
    }

    private TargetAnchorFeedback createTargetAnchorFocus() {
        return new TargetAnchorFeedback(this.getConnection());
    }

    public ConnectionEditPart getHost() {
        return (ConnectionEditPart)super.getHost();
    }

    private static abstract class AnchorFeedback
    extends FeedbackBase {
        public AnchorFeedback(Connection connection, Color color) {
            super(connection, color);
        }

        protected abstract ConnectionAnchor getAnchor(Connection var1);

        @Override
        protected void updateFeedback() {
            ConnectionAnchor anchor = this.getAnchor(this.getConnection());
            Point refPoint = anchor.getReferencePoint().getCopy();
            this.translateToRelative((Translatable)refPoint);
            this.showAt(refPoint);
        }
    }

    private static abstract class FeedbackBase
    extends Ellipse {
        private AncestorListener myAncestorListener = new AncestorListener.Stub(){

            public void ancestorMoved(IFigure ancestor) {
                FeedbackBase.this.revalidate();
            }
        };
        private Connection myConnection;

        public FeedbackBase(Connection connection, Color color) {
            this.myConnection = connection;
            this.setSize(10, 10);
            this.setLineWidth(2);
            this.setFill(false);
            this.setOpaque(true);
            if (color != null) {
                this.setBackgroundColor(color);
                this.setForegroundColor(color);
            }
        }

        protected abstract void updateFeedback();

        public void addNotify() {
            super.addNotify();
            this.myConnection.addAncestorListener(this.myAncestorListener);
        }

        public void removeNotify() {
            this.myConnection.removeAncestorListener(this.myAncestorListener);
            super.removeNotify();
        }

        public void validate() {
            if (this.isValid()) {
                return;
            }
            this.updateFeedback();
        }

        public void showAt(Point point) {
            Dimension halfSize = this.getSize().getScaled(-0.5);
            this.setLocation(point.getTranslated(halfSize));
        }

        protected Connection getConnection() {
            return this.myConnection;
        }
    }

    private static class RoutingBendpointFeedback
    extends FeedbackBase {
        private int myIndex;

        public RoutingBendpointFeedback(Connection connection, int idx) {
            super(connection, ColorConstants.green);
            this.myIndex = idx;
        }

        @Override
        protected void updateFeedback() {
            List routing = (List)this.getConnection().getRoutingConstraint();
            if (routing == null) {
                routing = Collections.emptyList();
            }
            Bendpoint bendpoint = null;
            if (routing.size() > this.myIndex) {
                bendpoint = (Bendpoint)routing.get(this.myIndex);
            }
            if (bendpoint == null) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                Point point = bendpoint.getLocation().getCopy();
                this.getConnection().translateToAbsolute((Translatable)point);
                this.translateToRelative((Translatable)point);
                this.showAt(point);
            }
        }
    }

    private static class SourceAnchorFeedback
    extends AnchorFeedback {
        public SourceAnchorFeedback(Connection connection) {
            super(connection, ColorConstants.blue);
        }

        @Override
        protected ConnectionAnchor getAnchor(Connection connection) {
            return connection.getSourceAnchor();
        }
    }

    private static class TargetAnchorFeedback
    extends AnchorFeedback {
        public TargetAnchorFeedback(Connection connection) {
            super(connection, ColorConstants.red);
        }

        @Override
        protected ConnectionAnchor getAnchor(Connection connection) {
            return connection.getTargetAnchor();
        }
    }
}

