/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ptp.internal.etfw.Activator;
import org.osgi.service.prefs.BackingStoreException;

public final class Preferences {
    private static final IScopeContext[] contexts = new IScopeContext[]{DefaultScope.INSTANCE, InstanceScope.INSTANCE};
    private static final int DEFAULT_CONTEXT = 0;
    private static final int INSTANCE_CONTEXT = 1;

    public static void addPreferenceChangeListener(String qualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
        contexts[0].getNode(qualifier).addPreferenceChangeListener(listener);
        contexts[1].getNode(qualifier).addPreferenceChangeListener(listener);
    }

    public static boolean contains(String qualifier, String name) {
        return contexts[1].getNode(qualifier).get(name, null) != null || contexts[0].getNode(qualifier).get(name, null) != null;
    }

    public static boolean getBoolean(String qualifier, String key) {
        return Platform.getPreferencesService().getBoolean(qualifier, key, false, null);
    }

    public static byte[] getByteArray(String qualifier, String key) {
        return Platform.getPreferencesService().getByteArray(qualifier, key, null, null);
    }

    public static synchronized boolean getDefaultBoolean(String qualifier, String key, boolean defaultvalue) {
        return contexts[0].getNode(qualifier).getBoolean(key, defaultvalue);
    }

    public static synchronized byte[] getDefaultByteArray(String qualifier, String key, byte[] defaultvalue) {
        return contexts[0].getNode(qualifier).getByteArray(key, defaultvalue);
    }

    public static synchronized double getDefaultDouble(String qualifier, String key, double defaultvalue) {
        return contexts[0].getNode(qualifier).getDouble(key, defaultvalue);
    }

    public static synchronized float getDefaultFloat(String qualifier, String key, float defaultvalue) {
        return contexts[0].getNode(qualifier).getFloat(key, defaultvalue);
    }

    public static synchronized int getDefaultInt(String qualifier, String key, int defaultvalue) {
        return contexts[0].getNode(qualifier).getInt(key, defaultvalue);
    }

    public static synchronized long getDefaultLong(String qualifier, String key, long defaultvalue) {
        return contexts[0].getNode(qualifier).getLong(key, defaultvalue);
    }

    public static synchronized String getDefaultString(String qualifier, String key, String defaultvalue) {
        return contexts[0].getNode(qualifier).get(key, defaultvalue);
    }

    public static double getDouble(String qualifier, String key) {
        return Platform.getPreferencesService().getDouble(qualifier, key, 0.0, null);
    }

    public static float getFloat(String qualifier, String key) {
        return Platform.getPreferencesService().getFloat(qualifier, key, 0.0f, null);
    }

    public static int getInt(String qualifier, String key) {
        return Platform.getPreferencesService().getInt(qualifier, key, 0, null);
    }

    public static long getLong(String qualifier, String key) {
        return Platform.getPreferencesService().getLong(qualifier, key, 0L, null);
    }

    public static String getString(String qualifier, String key) {
        return Platform.getPreferencesService().getString(qualifier, key, null, null);
    }

    public static boolean isDefault(String qualifier, String name) {
        String defVal = contexts[0].getNode(qualifier).get(name, null);
        if (defVal != null) {
            String val = contexts[1].getNode(qualifier).get(name, null);
            return val != null && val.equals(defVal);
        }
        return false;
    }

    public static void removePreferenceChangeListener(String qualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
        contexts[0].getNode(qualifier).removePreferenceChangeListener(listener);
        contexts[1].getNode(qualifier).removePreferenceChangeListener(listener);
    }

    public static synchronized void savePreferences(String qualifier) {
        try {
            contexts[0].getNode(qualifier).flush();
            contexts[1].getNode(qualifier).flush();
        }
        catch (BackingStoreException bse) {
            Activator.log(bse);
        }
    }

    public static synchronized void setBoolean(String qualifier, String key, boolean value) {
        contexts[1].getNode(qualifier).putBoolean(key, value);
    }

    public static synchronized void setByteArray(String qualifier, String key, byte[] value) {
        contexts[1].getNode(qualifier).putByteArray(key, value);
    }

    public static synchronized void setDefaultBoolean(String qualifier, String key, boolean value) {
        contexts[0].getNode(qualifier).putBoolean(key, value);
    }

    public static synchronized void setDefaultByteArray(String qualifier, String key, byte[] value) {
        contexts[0].getNode(qualifier).putByteArray(key, value);
    }

    public static synchronized void setDefaultDouble(String qualifier, String key, double value) {
        contexts[0].getNode(qualifier).putDouble(key, value);
    }

    public static synchronized void setDefaultFloat(String qualifier, String key, float value) {
        contexts[0].getNode(qualifier).putFloat(key, value);
    }

    public static synchronized void setDefaultInt(String qualifier, String key, int value) {
        contexts[0].getNode(qualifier).putInt(key, value);
    }

    public static synchronized void setDefaultLong(String qualifier, String key, long value) {
        contexts[0].getNode(qualifier).putLong(key, value);
    }

    public static synchronized void setDefaultString(String qualifier, String key, String value) {
        contexts[0].getNode(qualifier).put(key, value);
    }

    public static synchronized void setDouble(String qualifier, String key, double value) {
        contexts[1].getNode(qualifier).putDouble(key, value);
    }

    public static synchronized void setFloat(String qualifier, String key, float value) {
        contexts[1].getNode(qualifier).putFloat(key, value);
    }

    public static synchronized void setInt(String qualifier, String key, int value) {
        contexts[1].getNode(qualifier).putInt(key, value);
    }

    public static synchronized void setLong(String qualifier, String key, long value) {
        contexts[1].getNode(qualifier).putLong(key, value);
    }

    public static synchronized void setString(String qualifier, String key, String value) {
        contexts[1].getNode(qualifier).put(key, value);
    }

    public static synchronized void setToDefault(String qualifier, String key) {
        if (key != null) {
            contexts[1].getNode(qualifier).remove(key);
        }
    }

    private Preferences() {
    }
}

